/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.preprocessor;

import android.content.Context;
import android.graphics.Bitmap;
import android.opengl.GLES20;
import android.opengl.GLUtils;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.beauty.gpufilters.TXCGPUGaussianBlurFilter;
import com.tencent.ugc.beauty.gpufilters.TXCGPUGreenScreenFilter;
import com.tencent.ugc.beauty.gpufilters.TXCGPULookupFilterGroup;
import com.tencent.ugc.beauty.gpufilters.TXCGPUWatermarkFilter;
import com.tencent.ugc.preprocessor.BeautyProcessor;
import com.tencent.ugc.preprocessor.VideoPreprocessorListener;
import com.tencent.ugc.preprocessor.e;
import com.tencent.ugc.preprocessor.f;
import com.tencent.ugc.preprocessor.g;
import com.tencent.ugc.preprocessor.h;
import com.tencent.ugc.videobase.chain.GPUInterceptor;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilterChain;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.DelayQueue;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.videobase.ConvertParams;
import com.tencent.ugc.videobase.videobase.FrameConverter;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.List;

public class GPUPreprocessor {
    private final String mTAG = "GPUPreprocessor_" + this.hashCode();
    private final Context mAppContext;
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private final TXCGPUImageFilter[] mGPUImageFilters = new TXCGPUImageFilter[b.values().length];
    private final DelayQueue mRunOnDrawQueue = new DelayQueue();
    private final BeautyProcessor mBeautyProcessor;
    private final TXCGPUImageFilterChain mGPUImageFilterChain = new TXCGPUImageFilterChain();
    private final com.tencent.liteav.base.b.b mThrottlers = new com.tencent.liteav.base.b.b();
    private int mProcessWidth = 128;
    private int mProcessHeight = 128;
    private EGLCore mEGLCore;
    private Object mEGLContext;
    private PixelFrameRenderer mPixelFrameRenderer;
    private GLTexturePool mGLTexturePool;
    private final FrameConverter mAfterWatermarkConverter = new FrameConverter();
    private FrameConverter mBeforeWatermarkConverter;
    private final List<c> mNoNeedWatermarkListeners = new ArrayList<c>();
    private final List<c> mNeedWatermarkListeners = new ArrayList<c>();

    public GPUPreprocessor(Context context, BeautyProcessor beautyProcessor) {
        this.mAppContext = context.getApplicationContext();
        this.mBeautyProcessor = beautyProcessor;
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    }

    public void setProcessSize(int width, int height) {
        if (this.mProcessWidth == width && this.mProcessHeight == height) {
            return;
        }
        this.mProcessWidth = width;
        this.mProcessHeight = height;
        LiteavLog.i(this.mTAG, "process size update to %dx%d", width, height);
        if (!this.makeCurrent()) {
            return;
        }
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.evictAll();
        }
        this.mGPUImageFilterChain.onOutputSizeChanged(width, height);
    }

    private void setGLContext(Object eglContext) {
        if (!CommonUtil.equals(this.mEGLContext, eglContext)) {
            this.mEGLContext = eglContext;
            this.uninitializeGLComponents();
            LiteavLog.i(this.mTAG, "set unique eglcore: %s", eglContext);
        }
    }

    public void processFrame(PixelFrame pixelFrame, GLConstants.GLScaleType scaleType) {
        int n2;
        pixelFrame.getGLContext();
        this.setGLContext(pixelFrame.getGLContext());
        try {
            if (this.mEGLCore == null) {
                this.initializeGLComponents(pixelFrame.getGLContext());
            }
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("make"), this.mTAG, "initializeEGL failed. " + eGLException.getMessage(), new Object[0]);
            this.uninitializeGLComponents();
            return;
        }
        this.mRunOnDrawQueue.rerun();
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new PixelFrameRenderer(this.mProcessWidth, this.mProcessHeight);
        }
        PixelFrame pixelFrame2 = pixelFrame;
        OpenGlUtils.glViewport(0, 0, this.mProcessWidth, this.mProcessHeight);
        if (pixelFrame.getHeight() != this.mProcessHeight || pixelFrame.getWidth() != this.mProcessWidth || pixelFrame.getRotation() != l.a || pixelFrame.isMirrorVertical() || pixelFrame.isMirrorHorizontal() || pixelFrame.getPixelBufferType() != GLConstants.a.b) {
            GLTexture gLTexture = this.mGLTexturePool.obtain(this.mProcessWidth, this.mProcessHeight);
            gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
            this.mPixelFrameRenderer.renderFrame(pixelFrame, scaleType, gLTexture);
            pixelFrame2 = gLTexture.wrap(this.mEGLCore.getEglContext());
            gLTexture.release();
        } else {
            pixelFrame2.retain();
        }
        long l2 = pixelFrame.getTimestamp();
        this.mGPUImageFilterChain.setTimestamp(l2);
        GLTexture gLTexture = this.mGLTexturePool.obtain(this.mProcessWidth, this.mProcessHeight);
        gLTexture.setColorFormat(pixelFrame2.getColorRange(), pixelFrame2.getColorSpace());
        gLTexture.setMetaData(pixelFrame.getMetaData());
        this.mGPUImageFilterChain.setColorFormat(gLTexture.getColorRange(), gLTexture.getColorSpace());
        this.mGPUImageFilterChain.onDraw(pixelFrame2.getTextureId(), gLTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        pixelFrame2.release();
        gLTexture.release();
        while ((n2 = GLES20.glGetError()) != 0) {
            LiteavLog.e(this.mThrottlers.a("processFrame"), this.mTAG, "GL error occurred when preprocess frame, error :" + GLUtils.getEGLErrorString((int)n2), new Object[0]);
        }
    }

    public void registerVideoProcessedListener(int identity, ConvertParams params, GLConstants.a bufferType, GLConstants.PixelFormatType formatType, boolean withWatermark, VideoPreprocessorListener listener) {
        c c2 = new c(identity, params, bufferType, formatType, listener);
        if (!withWatermark) {
            this.addListenerToList(c2, this.mNoNeedWatermarkListeners);
        } else {
            this.addListenerToList(c2, this.mNeedWatermarkListeners);
        }
        this.registerListenersToRightConverter();
        LiteavLog.i(this.mTAG, "register listener, identity:%d, bufferType:%s, formatType:%s, withWatermark:%b, listener:%s", new Object[]{identity, bufferType, formatType, withWatermark, listener});
    }

    public void unregisterVideoProcessedListener(int identity, VideoPreprocessorListener listener) {
        c c2 = this.removeListenerFromList(identity, listener, this.mNoNeedWatermarkListeners);
        if (c2 == null && (c2 = this.removeListenerFromList(identity, listener, this.mNeedWatermarkListeners)) == null) {
            return;
        }
        this.mAfterWatermarkConverter.removeListener(identity, c2);
        if (this.mBeforeWatermarkConverter != null) {
            this.mBeforeWatermarkConverter.removeListener(identity, c2);
        }
        LiteavLog.i(this.mTAG, "unregister listener: identity: %d, listener: %s", identity, listener);
    }

    public void setWatermark(Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        LiteavLog.d(this.mTAG, "setWatermark xOffsetRatio: %.2f, yOffsetRatio: %.2f, widthRatio: %.2f", Float.valueOf(xOffsetRatio), Float.valueOf(yOffsetRatio), Float.valueOf(widthRatio));
        this.mRunOnDrawQueue.add(e.a(this, watermark, xOffsetRatio, yOffsetRatio, widthRatio));
    }

    public void setGaussianBlurLevel(float level) {
        this.mRunOnDrawQueue.add(f.a(this, level));
    }

    public void setFilterMixLevel(float mixLevel) {
        this.mRunOnDrawQueue.add(g.a(this, mixLevel));
    }

    public void setFilterGroupImages(float leftBitmapRatio, Bitmap leftBitmap, float leftSpecialRatio, Bitmap rightBitmap, float rightSpecialRatio) {
        this.mRunOnDrawQueue.add(h.a(this, leftBitmap, rightBitmap, leftBitmapRatio, leftSpecialRatio, rightSpecialRatio));
    }

    public BeautyProcessor getBeautyProcessor() {
        return this.mBeautyProcessor;
    }

    public void uninitialize() {
        this.uninitializeGLComponents();
        LiteavLog.i(this.mTAG, "destroy gpu preprocessor");
    }

    private void initializeGLComponents(Object eglContextFromPixelFrame) throws EGLException {
        LiteavLog.i(this.mThrottlers.a("initGL"), this.mTAG, "initialize internal, eglContextFromPixelFrame: %s", eglContextFromPixelFrame);
        this.mEGLCore = new EGLCore();
        this.mEGLCore.initialize(eglContextFromPixelFrame, null, 128, 128);
        this.mEGLCore.makeCurrent();
        this.mGLTexturePool = new GLTexturePool();
        this.mAfterWatermarkConverter.initialize(this.mGLTexturePool);
        this.mBeautyProcessor.initialize(this.mGLTexturePool);
        this.updateFilterChain();
    }

    public void uninitializeGLComponents() {
        if (!this.makeCurrent()) {
            return;
        }
        this.mAfterWatermarkConverter.uninitialize();
        if (this.mBeforeWatermarkConverter != null) {
            this.mBeforeWatermarkConverter.uninitialize();
            this.mBeforeWatermarkConverter = null;
        }
        this.mBeautyProcessor.uninitialize();
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.evictAll();
            this.mGLTexturePool.destroy();
            this.mGLTexturePool = null;
        }
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
        this.mGPUImageFilterChain.uninitialize();
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
        LiteavLog.i(this.mThrottlers.a("uninitGL"), this.mTAG, "uninitialize opengl components", new Object[0]);
    }

    private <T> T enableFilter(b filterType) {
        if (this.mGPUImageFilters[filterType.ordinal()] != null) {
            return (T)this.mGPUImageFilters[filterType.ordinal()];
        }
        TXCGPUImageFilter tXCGPUImageFilter = this.createFilter(filterType);
        tXCGPUImageFilter.initialize(this.mGLTexturePool);
        tXCGPUImageFilter.onOutputSizeChanged(this.mProcessWidth, this.mProcessHeight);
        this.mGPUImageFilters[filterType.ordinal()] = tXCGPUImageFilter;
        this.updateFilterChain();
        return (T)tXCGPUImageFilter;
    }

    private <T> T getFilter(b filterType) {
        return (T)this.mGPUImageFilters[filterType.ordinal()];
    }

    private void disableFilter(b filterType) {
        if (this.mGPUImageFilters[filterType.ordinal()] == null) {
            return;
        }
        TXCGPUImageFilter tXCGPUImageFilter = this.mGPUImageFilters[filterType.ordinal()];
        if (tXCGPUImageFilter == null) {
            return;
        }
        this.mGPUImageFilters[filterType.ordinal()] = null;
        tXCGPUImageFilter.uninitialize();
        this.updateFilterChain();
    }

    private void updateFilterChain() {
        this.mGPUImageFilterChain.removeAllFilterAndInterceptor();
        this.mGPUImageFilterChain.uninitialize();
        this.registerListenersToRightConverter();
        for (b b2 : b.values()) {
            if (b2 == b.e) {
                this.mGPUImageFilterChain.addInterceptor(new a(this.mBeforeWatermarkConverter));
            }
            if (b2 == b.a) {
                this.mGPUImageFilterChain.addFilter(this.mBeautyProcessor);
                continue;
            }
            this.mGPUImageFilterChain.addFilter(this.mGPUImageFilters[b2.ordinal()]);
        }
        this.mGPUImageFilterChain.addInterceptor(new a(this.mAfterWatermarkConverter));
        this.mGPUImageFilterChain.initialize(this.mGLTexturePool);
        this.mGPUImageFilterChain.onOutputSizeChanged(this.mProcessWidth, this.mProcessHeight);
    }

    private TXCGPUImageFilter createFilter(b filterType) {
        switch (filterType) {
            case e: {
                return new TXCGPUWatermarkFilter();
            }
            case b: {
                return new TXCGPUGaussianBlurFilter(0.8f);
            }
            case c: {
                return new TXCGPULookupFilterGroup();
            }
            case d: {
                return new TXCGPUGreenScreenFilter(this.mAppContext);
            }
        }
        throw new RuntimeException("unknown filter type");
    }

    private void addListenerToList(c params, List<c> infoList) {
        for (c c2 : infoList) {
            if (c2.a != params.a || c2.e != params.e) continue;
            return;
        }
        infoList.add(params);
    }

    private c removeListenerFromList(int identity, VideoPreprocessorListener listener, List<c> infoList) {
        for (int i2 = 0; i2 < infoList.size(); ++i2) {
            c c2 = infoList.get(i2);
            if (c2.a != identity || c2.e != listener) continue;
            infoList.remove(i2);
            return c2;
        }
        return null;
    }

    private void registerListenersToRightConverter() {
        if (!this.makeCurrent()) {
            return;
        }
        if (this.mGPUImageFilters[b.e.ordinal()] != null) {
            if (this.mBeforeWatermarkConverter == null) {
                this.mBeforeWatermarkConverter = new FrameConverter();
                this.mBeforeWatermarkConverter.initialize(this.mGLTexturePool);
            }
            for (c c2 : this.mNoNeedWatermarkListeners) {
                this.mAfterWatermarkConverter.removeListener(c2.a, c2);
                this.mBeforeWatermarkConverter.addListener(c2.b, c2.c, c2.d, c2.a, c2);
            }
        } else {
            for (c c2 : this.mNoNeedWatermarkListeners) {
                if (this.mBeforeWatermarkConverter != null) {
                    this.mBeforeWatermarkConverter.removeListener(c2.a, c2);
                }
                this.mAfterWatermarkConverter.addListener(c2.b, c2.c, c2.d, c2.a, c2);
            }
            if (this.mBeforeWatermarkConverter != null) {
                this.mBeforeWatermarkConverter.uninitialize();
                this.mBeforeWatermarkConverter = null;
            }
        }
        for (c c2 : this.mNeedWatermarkListeners) {
            this.mAfterWatermarkConverter.addListener(c2.b, c2.c, c2.d, c2.a, c2);
        }
    }

    private boolean makeCurrent() {
        try {
            if (this.mEGLCore != null) {
                this.mEGLCore.makeCurrent();
                return true;
            }
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "makeCurrent failed. ".concat(String.valueOf(eGLException)), new Object[0]);
        }
        return false;
    }

    static /* synthetic */ void lambda$setFilterGroupImages$3(GPUPreprocessor this_, Bitmap leftBitmap, Bitmap rightBitmap, float leftBitmapRatio, float leftSpecialRatio, float rightSpecialRatio) {
        if (leftBitmap == null && rightBitmap == null) {
            this_.disableFilter(b.c);
            return;
        }
        ((TXCGPULookupFilterGroup)this_.enableFilter(b.c)).setBitmap(leftBitmapRatio, leftBitmap, leftSpecialRatio, rightBitmap, rightSpecialRatio);
    }

    static /* synthetic */ void lambda$setFilterMixLevel$2(GPUPreprocessor this_, float mixLevel) {
        TXCGPULookupFilterGroup tXCGPULookupFilterGroup = (TXCGPULookupFilterGroup)this_.getFilter(b.c);
        if (tXCGPULookupFilterGroup != null) {
            tXCGPULookupFilterGroup.setIntensity(mixLevel);
        }
    }

    static /* synthetic */ void lambda$setGaussianBlurLevel$1(GPUPreprocessor this_, float level) {
        if (level < 0.0f) {
            this_.disableFilter(b.b);
            return;
        }
        TXCGPUGaussianBlurFilter tXCGPUGaussianBlurFilter = (TXCGPUGaussianBlurFilter)this_.enableFilter(b.b);
        if (tXCGPUGaussianBlurFilter != null) {
            tXCGPUGaussianBlurFilter.setBlurSize(level);
        }
    }

    static /* synthetic */ void lambda$setWatermark$0(GPUPreprocessor this_, Bitmap watermark, float xOffsetRatio, float yOffsetRatio, float widthRatio) {
        if (watermark == null) {
            this_.disableFilter(b.e);
            return;
        }
        TXCGPUWatermarkFilter tXCGPUWatermarkFilter = (TXCGPUWatermarkFilter)this_.enableFilter(b.e);
        tXCGPUWatermarkFilter.enableWatermark(true);
        tXCGPUWatermarkFilter.setWatermark(watermark, xOffsetRatio, yOffsetRatio, widthRatio);
    }

    static final class a
    extends GPUInterceptor {
        private final FrameConverter a;

        public a(FrameConverter frameConverter) {
            this.a = frameConverter;
        }

        @Override
        public final GLTexture intercept(long timestamp, GLTexture texture) {
            if (this.a != null) {
                this.a.processFrame(timestamp, texture);
            }
            return texture;
        }
    }

    final class c
    implements FrameConverter.FrameConvertListener {
        public int a;
        public ConvertParams b;
        public GLConstants.a c;
        public GLConstants.PixelFormatType d;
        public VideoPreprocessorListener e;

        public c(int n2, ConvertParams convertParams, GLConstants.a a2, GLConstants.PixelFormatType pixelFormatType, VideoPreprocessorListener videoPreprocessorListener) {
            this.a = n2;
            this.b = convertParams;
            this.d = pixelFormatType;
            this.c = a2;
            this.e = videoPreprocessorListener;
        }

        @Override
        public final void onFrameConverted(int identity, PixelFrame pixelFrame) {
            if (this.e == null || GPUPreprocessor.this.mEGLCore == null) {
                return;
            }
            this.e.didProcessFrame(identity, pixelFrame);
            GPUPreprocessor.this.makeCurrent();
        }
    }

    static enum b {
        a,
        b,
        c,
        d,
        e;

    }
}

