/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import android.opengl.GLES20;
import android.os.SystemClock;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.m;
import com.tencent.ugc.encoder.UGCVideoEncoderJNI;
import com.tencent.ugc.encoder.VideoEncodeParams;
import com.tencent.ugc.encoder.b;
import com.tencent.ugc.encoder.c;
import com.tencent.ugc.encoder.d;
import com.tencent.ugc.encoder.e;
import com.tencent.ugc.encoder.f;
import com.tencent.ugc.encoder.g;
import com.tencent.ugc.encoder.h;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.BlockingFrameQueue;
import com.tencent.ugc.videobase.utils.PixelFrameQueue;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;

public class UGCVideoEncodeController {
    private static final int THREAD_KEEP_ALIVE_TIME_IN_SECOND = 15;
    private static final int MAX_WAIT_TIME_MS = 2000;
    private static final int MAX_ENCODE_COST_TIME_PER_FRAME = 5000;
    private static final int MAX_ENCODING_FRAME_NUMBER = 30;
    private static final int FRAME_QUEUE_SIZE = 1;
    private static final int SCHEDULE_ENCODE_TASK_DELAY_TIME_MS = 3;
    private static final PixelFrame EOS_FRAME = new PixelFrame();
    private final String mTag = "UGCVideoEncodeController_" + this.hashCode();
    private final com.tencent.liteav.base.b.b mThrottlers;
    private final UGCVideoEncoderJNI.EncoderType mExceptEncodeType;
    private final m mSequenceTaskRunner;
    private final PixelFrameQueue mPendingEncodeFrameQueue;
    private final AtomicReference<UGCVideoEncoderJNI.VideoEncoderError> mEncoderErrorType = new AtomicReference<UGCVideoEncoderJNI.VideoEncoderError>(UGCVideoEncoderJNI.VideoEncoderError.SUCCESS);
    private final Map<Long, Long> mFrameDeliverToEncoderTimeMap = new HashMap<Long, Long>();
    private UGCVideoEncoderJNI mVideoEncoder;
    private UGCVideoEncoderJNI.UGCVideoEncoderListener mUGCEncoderControllerListener;
    private VideoEncodeParams mEncodeParams;
    private boolean mHasEncodeFailureNotified = false;
    private a mEncoderStats = a.a;
    private final UGCVideoEncoderJNI.UGCVideoEncoderListener mVideoEncoderListener = new UGCVideoEncoderJNI.UGCVideoEncoderListener(){

        @Override
        public final void onEncodedNAL(EncodedVideoFrame nal) {
            if (nal == null) {
                LiteavLog.d(UGCVideoEncodeController.this.mThrottlers.a("onEncodedNAL"), UGCVideoEncodeController.this.mTag, "on encoded frame is null.", new Object[0]);
                return;
            }
            UGCVideoEncodeController.this.mSequenceTaskRunner.a(h.a(this, nal));
        }

        @Override
        public final void onEncodedFail(UGCVideoEncoderJNI.VideoEncoderError encoderError) {
            LiteavLog.e(UGCVideoEncodeController.this.mThrottlers.a("onEncodedFail"), UGCVideoEncodeController.this.mTag, "on encoded fail. type is ".concat(String.valueOf((Object)encoderError)), new Object[0]);
            UGCVideoEncodeController.this.mEncoderErrorType.set(encoderError);
        }

        static /* synthetic */ void a(1 var0, EncodedVideoFrame encodedVideoFrame) {
            if (encodedVideoFrame.isEosFrame) {
                LiteavLog.i(var0.UGCVideoEncodeController.this.mTag, "got eos");
            }
            if (var0.UGCVideoEncodeController.this.mUGCEncoderControllerListener != null) {
                var0.UGCVideoEncodeController.this.mUGCEncoderControllerListener.onEncodedNAL(encodedVideoFrame);
            }
            var0.UGCVideoEncodeController.this.removeEarlierFrameFromFrameDeliverToEncoderTimeMap(encodedVideoFrame.pts);
            if (encodedVideoFrame.isEosFrame && !var0.UGCVideoEncodeController.this.mFrameDeliverToEncoderTimeMap.isEmpty()) {
                LiteavLog.e(var0.UGCVideoEncodeController.this.mTag, "got eos frame with unencoded frames left, causing an error");
                var0.UGCVideoEncodeController.this.mEncoderErrorType.set(UGCVideoEncoderJNI.VideoEncoderError.ENCODE_FAILED);
            }
        }
    };

    public UGCVideoEncodeController(UGCVideoEncoderJNI.EncoderType encoderType) {
        LiteavLog.i(this.mTag, "UGCVideoEncodeController construct encoderType = ".concat(String.valueOf((Object)encoderType)));
        this.mThrottlers = new com.tencent.liteav.base.b.b();
        this.mExceptEncodeType = encoderType;
        this.mSequenceTaskRunner = new m(15, this.mTag);
        this.mPendingEncodeFrameQueue = new BlockingFrameQueue(1);
    }

    public void start(VideoEncodeParams params, UGCVideoEncoderJNI.UGCVideoEncoderListener listener) {
        LiteavLog.i(this.mThrottlers.a("start"), this.mTag, "start", new Object[0]);
        this.mSequenceTaskRunner.a(com.tencent.ugc.encoder.a.a(this, params, listener));
    }

    public void stop() {
        LiteavLog.i(this.mThrottlers.a("stop"), this.mTag, "stop", new Object[0]);
        this.mSequenceTaskRunner.a(b.a(this));
    }

    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (frame.getGLContext() != null) {
            GLES20.glFinish();
        }
        this.mPendingEncodeFrameQueue.push(frame);
        this.mSequenceTaskRunner.a(c.a(this));
    }

    public void signalEndOfStream() {
        LiteavLog.i(this.mThrottlers.a("signalEndOfStream"), this.mTag, "signalEndOfStream", new Object[0]);
        this.mPendingEncodeFrameQueue.push(EOS_FRAME);
        this.mSequenceTaskRunner.a(d.a(this));
    }

    private boolean createEncoder() {
        PixelFrame pixelFrame = this.mPendingEncodeFrameQueue.peek();
        if (pixelFrame == null) {
            return false;
        }
        this.mVideoEncoder = new UGCVideoEncoderJNI();
        this.mEncodeParams.colorRange = pixelFrame.getColorRange();
        this.mEncodeParams.colorSpace = pixelFrame.getColorSpace();
        this.mVideoEncoder.start(this.mExceptEncodeType, this.mEncodeParams, this.mVideoEncoderListener);
        return true;
    }

    private void encodeFrameInternal() {
        if (this.mEncoderStats == a.a) {
            this.mPendingEncodeFrameQueue.evictAll();
            return;
        }
        if (this.mVideoEncoder == null && !this.createEncoder() || this.hasEncoderError()) {
            this.mPendingEncodeFrameQueue.evictAll();
            UGCVideoEncodeController uGCVideoEncodeController = this;
            uGCVideoEncodeController.notifyEncodedFail(uGCVideoEncodeController.mEncoderErrorType.get());
            return;
        }
        if (this.mEncoderStats == a.c) {
            this.mPendingEncodeFrameQueue.evictAll();
            this.mSequenceTaskRunner.b(e.a(this), 3L);
            return;
        }
        if (this.mVideoEncoder.isInputQueueFull()) {
            this.mSequenceTaskRunner.b(f.a(this), 3L);
            return;
        }
        PixelFrame pixelFrame = this.mPendingEncodeFrameQueue.poll();
        if (pixelFrame == null) {
            return;
        }
        this.mFrameDeliverToEncoderTimeMap.put(pixelFrame.getTimestamp(), SystemClock.elapsedRealtime());
        if (pixelFrame == EOS_FRAME) {
            this.mVideoEncoder.signalEndOfStream();
            this.mEncoderStats = a.c;
            this.mSequenceTaskRunner.b(g.a(this), 3L);
            return;
        }
        this.mVideoEncoder.encodeFrame(pixelFrame);
        pixelFrame.release();
    }

    private void notifyEncodedFail(UGCVideoEncoderJNI.VideoEncoderError videoEncoderError) {
        if (this.mHasEncodeFailureNotified) {
            return;
        }
        if (this.mUGCEncoderControllerListener != null) {
            this.mUGCEncoderControllerListener.onEncodedFail(videoEncoderError);
        }
        this.mHasEncodeFailureNotified = true;
    }

    private boolean hasEncoderError() {
        if (this.mEncoderErrorType.get() != UGCVideoEncoderJNI.VideoEncoderError.SUCCESS) {
            LiteavLog.e(this.mThrottlers.a("hasEncoderError"), this.mTag, "encoder error or encoder need restart", new Object[0]);
            return true;
        }
        long l2 = this.getEarliestTimeFromFrameDeliverToEncoderTimeMap();
        if (l2 != 0L && SystemClock.elapsedRealtime() - l2 > 5000L) {
            LiteavLog.e(this.mThrottlers.a("hasEncoderError"), this.mTag, "encoder output frame is outTime", new Object[0]);
            this.mEncoderErrorType.set(UGCVideoEncoderJNI.VideoEncoderError.ENCODER_THREAD_STUCK);
            return true;
        }
        if (this.mFrameDeliverToEncoderTimeMap.size() > 30) {
            LiteavLog.e(this.mThrottlers.a("isEncoderError"), this.mTag, "encoding frame is too many", new Object[0]);
            this.mEncoderErrorType.set(UGCVideoEncoderJNI.VideoEncoderError.ENCODER_THREAD_STUCK);
            return true;
        }
        return false;
    }

    private void destroyEncoder() {
        if (this.mVideoEncoder != null) {
            this.mVideoEncoder.stopSync(2000L);
            this.mVideoEncoder = null;
        }
    }

    private long getEarliestTimeFromFrameDeliverToEncoderTimeMap() {
        long l2 = Long.MAX_VALUE;
        for (long l3 : this.mFrameDeliverToEncoderTimeMap.values()) {
            if (l3 >= l2) continue;
            l2 = l3;
        }
        return l2;
    }

    private void removeEarlierFrameFromFrameDeliverToEncoderTimeMap(long pts) {
        Iterator<Map.Entry<Long, Long>> iterator = this.mFrameDeliverToEncoderTimeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            if (iterator.next().getKey() > pts) continue;
            iterator.remove();
        }
    }

    static /* synthetic */ void lambda$stop$1(UGCVideoEncodeController this_) {
        this_.mEncoderErrorType.set(UGCVideoEncoderJNI.VideoEncoderError.SUCCESS);
        this_.mFrameDeliverToEncoderTimeMap.clear();
        this_.mUGCEncoderControllerListener = null;
        this_.mEncodeParams = null;
        this_.mHasEncodeFailureNotified = false;
        this_.mEncoderStats = a.a;
        this_.mPendingEncodeFrameQueue.evictAll();
        this_.destroyEncoder();
    }

    static /* synthetic */ void lambda$start$0(UGCVideoEncodeController this_, VideoEncodeParams params, UGCVideoEncoderJNI.UGCVideoEncoderListener listener) {
        if (this_.mVideoEncoder != null) {
            LiteavLog.i(this_.mThrottlers.a("start"), this_.mTag, "VideoEncoder is started", new Object[0]);
            return;
        }
        this_.mEncodeParams = new VideoEncodeParams(params);
        this_.mUGCEncoderControllerListener = listener;
        this_.mEncoderStats = a.b;
    }

    static /* synthetic */ void access$lambda$0(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$2(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$3(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static /* synthetic */ void access$lambda$4(UGCVideoEncodeController uGCVideoEncodeController) {
        uGCVideoEncodeController.encodeFrameInternal();
    }

    static enum a {
        a,
        b,
        c;

    }
}

