/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.frame.PixelFrame;

@JNINamespace(value="liteav::ugc")
public class UGCHDRToSDRPixelFrameConverterJni {
    private static final String TAG = "UGCHDRToSDRPixelFrameConverterJni";
    private long mNativeHandler = UGCHDRToSDRPixelFrameConverterJni.nativeCreate();

    public UGCHDRToSDRPixelFrameConverterJni() {
        LiteavLog.i(TAG, "native handler is: " + this.mNativeHandler);
    }

    public PixelFrame convert(PixelFrame pixelFrame) {
        if (this.mNativeHandler == 0L) {
            pixelFrame.retain();
            return pixelFrame;
        }
        int n2 = UGCHDRToSDRPixelFrameConverterJni.nativeConvert(this.mNativeHandler, pixelFrame.getWidth(), pixelFrame.getHeight(), pixelFrame.getTextureId(), pixelFrame.getGLContext(), pixelFrame.getHdrType().getValue());
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        pixelFrame2.setTextureId(n2);
        pixelFrame2.setColorFormat(GLConstants.ColorRange.c, GLConstants.ColorSpace.c);
        pixelFrame2.retain();
        return pixelFrame2;
    }

    public void release() {
        if (this.mNativeHandler != 0L) {
            UGCHDRToSDRPixelFrameConverterJni.nativeDestroy(this.mNativeHandler);
        }
        this.mNativeHandler = 0L;
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native int nativeConvert(long var0, int var2, int var3, int var4, Object var5, int var6);
}

