/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.decoder.VideoDecoderDef;
import com.tencent.ugc.decoder.VideoDecoderInterface;
import com.tencent.ugc.decoder.VideoDecoderListener;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFramePool;
import java.nio.ByteBuffer;

@JNINamespace(value="liteav::ugc")
public class SoftwareVideoDecoder
implements VideoDecoderInterface {
    private static final String TAG = "SoftwareVideoDecoder";
    private long mNativeVideoDecoderWrapper = 0L;
    private final boolean mIsUseHevc;
    private VideoDecoderListener mListener;
    private PixelFramePool mPixelFramePool;

    public SoftwareVideoDecoder(boolean isUseHevc) {
        this.mIsUseHevc = isUseHevc;
    }

    @Override
    public void initialize() {
    }

    @Override
    public void uninitialize() {
    }

    @Override
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
    }

    @Override
    public void start(Object glContext, VideoDecoderListener listener) {
        if (this.mNativeVideoDecoderWrapper != 0L) {
            LiteavLog.w(TAG, "decoder is already started!");
            return;
        }
        this.mPixelFramePool = new PixelFramePool();
        this.mListener = listener;
        this.mNativeVideoDecoderWrapper = SoftwareVideoDecoder.nativeCreate(this);
        if (this.mNativeVideoDecoderWrapper == 0L) {
            this.handleDecoderError();
            LiteavLog.e(TAG, "create native instance failed.");
            return;
        }
        if (SoftwareVideoDecoder.nativeStart(this.mNativeVideoDecoderWrapper, this.mIsUseHevc) != 0) {
            this.handleDecoderError();
            LiteavLog.e(TAG, "Start software decoder failed.");
            return;
        }
        LiteavLog.i(TAG, "decoder Start success.");
    }

    @Override
    public boolean decode(EncodedVideoFrame frame) {
        if (frame == null) {
            return false;
        }
        if (frame.isEosFrame && this.mListener != null) {
            this.mListener.onDecodeCompleted();
            return true;
        }
        if (frame.data == null || frame.data.remaining() == 0) {
            return false;
        }
        SoftwareVideoDecoder.nativeDecodeFrame(this.mNativeVideoDecoderWrapper, frame);
        return true;
    }

    @Override
    public void stop() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        if (this.mPixelFramePool != null) {
            this.mPixelFramePool.destroy();
        }
        SoftwareVideoDecoder.nativeStop(this.mNativeVideoDecoderWrapper);
        SoftwareVideoDecoder.nativeDestroy(this.mNativeVideoDecoderWrapper);
        this.mNativeVideoDecoderWrapper = 0L;
        LiteavLog.i(TAG, "decoder stop.");
    }

    @Override
    public void abandonDecodingFrames() {
        if (this.mNativeVideoDecoderWrapper == 0L) {
            LiteavLog.w(TAG, "decoder has already stopped");
            return;
        }
        SoftwareVideoDecoder.nativeAbandonDecodingFrames(this.mNativeVideoDecoderWrapper);
        if (this.mListener != null) {
            this.mListener.onAbandonDecodingFramesCompleted();
        }
    }

    @Override
    public VideoDecoderInterface.DecoderType getDecoderType() {
        return VideoDecoderInterface.DecoderType.SOFTWARE;
    }

    private void handleDecoderError() {
        if (this.mListener != null) {
            this.mListener.onDecodeFailed();
        }
    }

    private void onDecodedFrame(PixelFrame frame, long errCode) {
        if (errCode != 0L) {
            this.handleDecoderError();
            LiteavLog.e(TAG, "decode failed.".concat(String.valueOf(errCode)));
            if (frame != null) {
                frame.release();
            }
            return;
        }
        if (frame != null) {
            if (this.mListener != null) {
                PixelFrame pixelFrame = frame;
                this.mListener.onDecodeFrame(pixelFrame, pixelFrame.getTimestamp());
            }
            frame.release();
        }
    }

    private PixelFrame obtainPixelFrame(int formatType, int width, int height, int rotation, long timestamp, int colorSpace, int colorRange) {
        GLConstants.PixelFormatType pixelFormatType = GLConstants.PixelFormatType.a(formatType);
        if (pixelFormatType == null) {
            this.handleDecoderError();
            LiteavLog.e(TAG, "obtainPixelFrame formatType: ".concat(String.valueOf(formatType)));
            return null;
        }
        if (this.mPixelFramePool == null) {
            LiteavLog.i(TAG, "obtainPixelFrame mPixelFramePool is null.");
            return null;
        }
        PixelFrame pixelFrame = this.mPixelFramePool.obtain(width, height, GLConstants.a.a, pixelFormatType);
        pixelFrame.setColorFormat(GLConstants.ColorRange.a(colorRange), GLConstants.ColorSpace.a(colorSpace));
        pixelFrame.setRotation(l.a(rotation));
        pixelFrame.setTimestamp(timestamp);
        return pixelFrame;
    }

    private ByteBuffer getByteBufferFromPixelFrame(PixelFrame frame) {
        return frame.getBuffer();
    }

    private static native long nativeCreate(SoftwareVideoDecoder var0);

    private static native void nativeDestroy(long var0);

    private static native int nativeStart(long var0, boolean var2);

    private static native int nativeStop(long var0);

    private static native int nativeDecodeFrame(long var0, EncodedVideoFrame var2);

    private static native void nativeAbandonDecodingFrames(long var0);
}

