/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.opengl.GLES20;
import android.os.Build;
import android.view.Surface;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.decoder.MediaCodecDecoder;
import com.tencent.ugc.decoder.MediaCodecWrapper;
import com.tencent.ugc.decoder.UGCHDRToSDRPixelFrameConverterJni;
import com.tencent.ugc.decoder.h;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.HDRType;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.frame.RefCounted;
import com.tencent.ugc.videobase.frame.TextureHolderPool;
import com.tencent.ugc.videobase.utils.HardwareDecoderMediaFormatBuilder;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.util.concurrent.TimeUnit;

public class MediaCodecOutputOESTextureDecoder
extends MediaCodecDecoder
implements SurfaceTexture.OnFrameAvailableListener {
    private EGLCore mEGLCore;
    private int mOESTextureId = -1;
    private TextureHolderPool mTextureHolderPool;
    private SurfaceTexture mSurfaceTexture;
    private Surface mOutputSurface;
    private PixelFrameRenderer mOESPixelFrameRenderer;
    private PixelFrameRenderer mHDRPixelFrameRenderer;
    private GLTexturePool mGLTexturePool;
    private UGCHDRToSDRPixelFrameConverterJni mUgcHdrToSdrPixelFrameConverterJni;

    public MediaCodecOutputOESTextureDecoder(HardwareDecoderMediaFormatBuilder builder, Size resolution, boolean useSoftDecoder, MediaCodecDecoder.MediaCodecDecoderListener listener, CustomHandler handler) {
        super(builder, resolution, useSoftDecoder, listener, handler);
        this.mTAG = "MediaCodecOutputOESTextureDecoder" + this.hashCode();
    }

    @Override
    protected boolean configureMediaCodec(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        MediaCodecWrapper.configure(mediaCodec, mediaFormat, this.mOutputSurface, null, 0);
        LiteavLog.i(this.mTAG, "configure mediacodec with " + this.mOutputSurface);
        return true;
    }

    @Override
    protected void updateOutputSurface(MediaCodec preloadMediaCodec) {
        if (Build.VERSION.SDK_INT >= 23) {
            preloadMediaCodec.setOutputSurface(this.mOutputSurface);
        }
    }

    @Override
    public boolean start(Object sharedGLContext) {
        return this.initializeGLComponents(sharedGLContext);
    }

    @Override
    protected boolean handleOutputBuffer(MediaCodec mediaCodec, MediaCodec.BufferInfo bufferInfo, int bufferIndex) {
        mediaCodec.releaseOutputBuffer(bufferIndex, true);
        if ((bufferInfo.flags & 4) != 0) {
            LiteavLog.i(this.mTAG, "meet end of stream.");
            if (this.mListener != null) {
                this.mListener.onDecodeFrame(null, true);
            }
            return false;
        }
        return true;
    }

    @Override
    public void stop() {
        super.stop();
        this.uninitializeGLComponents();
    }

    private boolean initializeGLComponents(Object sharedGLContext) {
        if (this.mEGLCore != null) {
            LiteavLog.w(this.mTAG, "Decoder already started.");
            return true;
        }
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(sharedGLContext, null, 128, 128);
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("initGL"), this.mTAG, "create EGLCore failed.", eGLException);
            if (this.mListener != null) {
                this.mListener.onDecoderError();
            }
            return false;
        }
        this.mOESTextureId = OpenGlUtils.generateTextureOES();
        this.mTextureHolderPool = new TextureHolderPool(1);
        try {
            this.mSurfaceTexture = new SurfaceTexture(this.mOESTextureId);
            this.mOutputSurface = new Surface(this.mSurfaceTexture);
            this.mSurfaceTexture.setOnFrameAvailableListener((SurfaceTexture.OnFrameAvailableListener)this);
        }
        catch (Surface.OutOfResourcesException outOfResourcesException) {
            LiteavLog.e(this.mThrottlers.a("surface"), this.mTAG, "create SurfaceTexture failed.", outOfResourcesException);
            if (this.mListener != null) {
                this.mListener.onDecoderError();
            }
            return false;
        }
        LiteavLog.i(this.mThrottlers.a("initGL"), this.mTAG, "initialize gl components", new Object[0]);
        return true;
    }

    private void uninitializeGLComponents() {
        LiteavLog.i(this.mTAG, "uninitialize gl components");
        if (!this.makeCurrent()) {
            return;
        }
        if (this.mTextureHolderPool != null) {
            this.mTextureHolderPool.destroy();
        }
        if (this.mOutputSurface != null) {
            this.mOutputSurface.release();
            this.mOutputSurface = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.destroy();
            this.mGLTexturePool = null;
        }
        if (this.mOESPixelFrameRenderer != null) {
            this.mOESPixelFrameRenderer.uninitialize();
            this.mOESPixelFrameRenderer = null;
        }
        if (this.mHDRPixelFrameRenderer != null) {
            this.mHDRPixelFrameRenderer.uninitialize();
            this.mHDRPixelFrameRenderer = null;
        }
        if (this.mUgcHdrToSdrPixelFrameConverterJni != null) {
            this.mUgcHdrToSdrPixelFrameConverterJni.release();
            this.mUgcHdrToSdrPixelFrameConverterJni = null;
        }
        OpenGlUtils.deleteTexture(this.mOESTextureId);
        this.mOESTextureId = -1;
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    public void onFrameAvailable(SurfaceTexture surfaceTexture) {
        MediaCodecOutputOESTextureDecoder mediaCodecOutputOESTextureDecoder = this;
        mediaCodecOutputOESTextureDecoder.runOnWorkThread(h.a(mediaCodecOutputOESTextureDecoder, surfaceTexture));
    }

    private PixelFrame hdrFrameConvertToSdrFrame(PixelFrame pixelFrame) {
        if (this.mUgcHdrToSdrPixelFrameConverterJni == null) {
            this.mUgcHdrToSdrPixelFrameConverterJni = new UGCHDRToSDRPixelFrameConverterJni();
        }
        pixelFrame.setHdrType(this.mHDRType);
        PixelFrame pixelFrame2 = this.mUgcHdrToSdrPixelFrameConverterJni.convert(pixelFrame);
        if (pixelFrame2 == pixelFrame) {
            return pixelFrame2;
        }
        PixelFrame pixelFrame3 = this.copyPixelFrameFromNativeTextureId(pixelFrame2);
        pixelFrame2.release();
        return pixelFrame3;
    }

    private PixelFrame copyPixelFrameFromNativeTextureId(PixelFrame pixelFrame) {
        if (this.mHDRPixelFrameRenderer == null) {
            this.mHDRPixelFrameRenderer = new PixelFrameRenderer(pixelFrame.getWidth(), pixelFrame.getHeight());
        }
        this.makeCurrent();
        OpenGlUtils.glViewport(0, 0, pixelFrame.getWidth(), pixelFrame.getHeight());
        GLTexture gLTexture = this.mGLTexturePool.obtain(pixelFrame.getWidth(), pixelFrame.getHeight());
        gLTexture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        this.mHDRPixelFrameRenderer.renderFrame(pixelFrame, GLConstants.GLScaleType.a, gLTexture);
        PixelFrame pixelFrame2 = gLTexture.wrap(this.mEGLCore.getEglContext());
        pixelFrame2.setTimestamp(pixelFrame.getTimestamp());
        pixelFrame2.setRotation(pixelFrame.getRotation());
        gLTexture.release();
        GLES20.glFinish();
        return pixelFrame2;
    }

    private PixelFrame convertOESFrameToTexture2DFrame(PixelFrame srcPixelFrame) {
        Object object;
        int n2 = srcPixelFrame.getWidth();
        int n3 = srcPixelFrame.getHeight();
        if (this.mOESPixelFrameRenderer != null) {
            object = this.mOESPixelFrameRenderer.getOutputSize();
            if (((Size)object).width != n2 || ((Size)object).height != n3) {
                this.mOESPixelFrameRenderer.uninitialize();
                this.mOESPixelFrameRenderer = null;
            }
        }
        if (this.mOESPixelFrameRenderer == null) {
            this.mOESPixelFrameRenderer = new PixelFrameRenderer(n2, n3);
        }
        if (this.mGLTexturePool == null) {
            this.mGLTexturePool = new GLTexturePool();
        }
        OpenGlUtils.glViewport(0, 0, n2, n3);
        object = this.mGLTexturePool.obtain(n2, n3);
        ((GLTexture)object).setColorFormat(srcPixelFrame.getColorRange(), srcPixelFrame.getColorSpace());
        this.mOESPixelFrameRenderer.renderFrame(srcPixelFrame, GLConstants.GLScaleType.a, (GLTexture)object);
        PixelFrame pixelFrame = ((GLTexture)object).wrap(this.mEGLCore.getEglContext());
        GLES20.glFinish();
        ((RefCounted)object).release();
        srcPixelFrame.release();
        return pixelFrame;
    }

    private boolean makeCurrent() {
        try {
            if (this.mEGLCore != null) {
                this.mEGLCore.makeCurrent();
            }
            return true;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "makeCurrent failed.", eGLException);
            return false;
        }
    }

    static /* synthetic */ void lambda$onFrameAvailable$0(MediaCodecOutputOESTextureDecoder this_, SurfaceTexture surfaceTexture) {
        if (this_.mSurfaceTexture == null || surfaceTexture != this_.mSurfaceTexture) {
            return;
        }
        this_.makeCurrent();
        TextureHolderPool.TextureHolder textureHolder = null;
        try {
            textureHolder = (TextureHolderPool.TextureHolder)this_.mTextureHolderPool.obtain();
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.w(this_.mTAG, "textureholderpool obtain interrupted.");
        }
        textureHolder.updateTexture(36197, this_.mOESTextureId, this_.mResolution.width, this_.mResolution.height);
        textureHolder.setColorFormat(GLConstants.ColorRange.b, GLConstants.ColorSpace.b);
        PixelFrame pixelFrame = textureHolder.wrap(this_.mEGLCore.getEglContext());
        if (pixelFrame.getMatrix() == null) {
            pixelFrame.setMatrix(new float[16]);
        }
        try {
            surfaceTexture.updateTexImage();
            surfaceTexture.getTransformMatrix(pixelFrame.getMatrix());
        }
        catch (Throwable throwable) {
            LiteavLog.w(this_.mThrottlers.a("updateImage"), this_.mTAG, "updateTexImage exception: ".concat(String.valueOf(throwable)), new Object[0]);
        }
        long l2 = TimeUnit.NANOSECONDS.toMillis(surfaceTexture.getTimestamp());
        if (l2 == 0L) {
            l2 = TimeUnit.MICROSECONDS.toMillis(this_.mBufferInfo.presentationTimeUs);
        }
        pixelFrame = this_.convertOESFrameToTexture2DFrame(pixelFrame);
        pixelFrame.setTimestamp(l2);
        if (this_.mHDRType == HDRType.HDR10 || this_.mHDRType == HDRType.HLG) {
            PixelFrame pixelFrame2 = this_.hdrFrameConvertToSdrFrame(pixelFrame);
            pixelFrame.release();
            pixelFrame = pixelFrame2;
        }
        this_.mListener.onDecodeFrame(pixelFrame, false);
        textureHolder.release();
        pixelFrame.release();
    }
}

