/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.decoder.DecodeAbilityProvider;
import com.tencent.ugc.decoder.MediaCodecDecoder;
import com.tencent.ugc.decoder.MediaCodecWrapper;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.HardwareDecoderMediaFormatBuilder;
import com.tencent.ugc.videobase.utils.MemoryAllocator;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.ByteBuffer;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class MediaCodecOutputBufferDecoder
extends MediaCodecDecoder {
    private int mStride = 0;
    private int mSliceHeight = 0;

    public MediaCodecOutputBufferDecoder(HardwareDecoderMediaFormatBuilder builder, Size resolution, boolean useSoftDecoder, MediaCodecDecoder.MediaCodecDecoderListener listener, CustomHandler handler) {
        super(builder, resolution, useSoftDecoder, listener, handler);
        this.mTAG = "MediaCodecOutputBufferDecoder" + this.hashCode();
    }

    @Override
    public boolean start(Object sharedGLContext) {
        return true;
    }

    @Override
    protected boolean configureMediaCodec(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        int n2 = DecodeAbilityProvider.getInstance().getSupportColorFormat(mediaFormat.getString("mime"));
        if (n2 <= 0) {
            return false;
        }
        mediaFormat.setInteger("color-format", n2);
        MediaCodecWrapper.configure(mediaCodec, mediaFormat, null, null, 0);
        return true;
    }

    @Override
    protected void updateOutputSurface(MediaCodec preloadMediaCodec) {
    }

    @Override
    protected boolean handleOutputBuffer(MediaCodec mediaCodec, MediaCodec.BufferInfo bufferInfo, int bufferIndex) {
        if (this.mListener == null) {
            return false;
        }
        if ((bufferInfo.flags & 4) != 0) {
            LiteavLog.i(this.mTAG, "meet end of stream.");
            this.mListener.onDecodeFrame(null, true);
        } else {
            MediaFormat mediaFormat;
            ByteBuffer byteBuffer = mediaCodec.getOutputBuffer(bufferIndex);
            ByteBuffer byteBuffer2 = this.copyYuvBuffer(byteBuffer, bufferInfo, (mediaFormat = mediaCodec.getOutputFormat()).getInteger("color-format"));
            if (byteBuffer2 == null) {
                return false;
            }
            PixelFrame pixelFrame = this.createPixelFrame(byteBuffer2, mediaFormat, bufferInfo.presentationTimeUs);
            if (pixelFrame != null) {
                this.mListener.onDecodeFrame(pixelFrame, false);
            } else {
                String string = String.format(Locale.ENGLISH, "output color format(%d) is unknown", mediaFormat.getInteger("color-format"));
                LiteavLog.e(this.mThrottlers.a("handleOutputBuffer"), this.mTAG, string, new Object[0]);
                this.mListener.onDecoderError();
            }
        }
        mediaCodec.releaseOutputBuffer(bufferIndex, false);
        return false;
    }

    @Override
    protected void outputFormatChange(MediaFormat mediaFormat) {
        LiteavLog.i(this.mTAG, "decode output format changed: ".concat(String.valueOf(mediaFormat)));
        int n2 = mediaFormat.getInteger("width");
        int n3 = mediaFormat.getInteger("height");
        this.mStride = n2;
        this.mSliceHeight = n3;
        if (mediaFormat.containsKey("stride")) {
            this.mStride = mediaFormat.getInteger("stride");
        }
        if (mediaFormat.containsKey("slice-height")) {
            this.mSliceHeight = mediaFormat.getInteger("slice-height");
        }
        this.mStride = Math.max(n2, this.mStride);
        this.mSliceHeight = Math.max(n3, this.mSliceHeight);
    }

    public static boolean isSupportColorFormat(int colorFormat) {
        return colorFormat == 19 || colorFormat == 21;
    }

    private ByteBuffer copyYuvBuffer(ByteBuffer srcBuffer, MediaCodec.BufferInfo bufferInfo, int colorFormat) {
        if (srcBuffer == null) {
            return null;
        }
        srcBuffer.position(bufferInfo.offset);
        srcBuffer.limit(bufferInfo.offset + bufferInfo.size);
        srcBuffer.rewind();
        ByteBuffer byteBuffer = MemoryAllocator.allocateDirectBuffer(this.mResolution.width * this.mResolution.height * 3 / 2);
        if (byteBuffer == null) {
            return null;
        }
        if (colorFormat == 19) {
            this.copyI420Buffer(srcBuffer, byteBuffer, this.mResolution.width, this.mResolution.height, this.mStride, this.mSliceHeight);
        } else if (colorFormat == 21) {
            this.copyNV12Buffer(srcBuffer, byteBuffer, this.mResolution.width, this.mResolution.height, this.mStride, this.mSliceHeight);
        } else {
            return null;
        }
        byteBuffer.rewind();
        return byteBuffer;
    }

    private PixelFrame createPixelFrame(ByteBuffer yuvBuffer, MediaFormat mediaFormat, long pts) {
        int n2 = mediaFormat.getInteger("color-format");
        if (!MediaCodecOutputBufferDecoder.isSupportColorFormat(n2)) {
            return null;
        }
        PixelFrame pixelFrame = new PixelFrame();
        pixelFrame.setWidth(this.mResolution.width);
        pixelFrame.setHeight(this.mResolution.height);
        pixelFrame.setTimestamp(TimeUnit.MICROSECONDS.toMillis(pts));
        pixelFrame.setPixelBufferType(GLConstants.a.a);
        pixelFrame.setBuffer(yuvBuffer);
        pixelFrame.setPixelFormatType(n2 == 19 ? GLConstants.PixelFormatType.a : GLConstants.PixelFormatType.b);
        GLConstants.ColorRange colorRange = this.getMediaFormatValue(mediaFormat, "color-range", 2) == 1 ? GLConstants.ColorRange.c : GLConstants.ColorRange.b;
        GLConstants.ColorSpace colorSpace = this.getMediaFormatValue(mediaFormat, "color-standard", 2) == 1 ? GLConstants.ColorSpace.c : GLConstants.ColorSpace.b;
        pixelFrame.setColorFormat(colorRange, colorSpace);
        return pixelFrame;
    }

    private int getMediaFormatValue(MediaFormat mediaFormat, String keyName, int defaultValue) {
        if (mediaFormat.containsKey(keyName)) {
            return mediaFormat.getInteger(keyName);
        }
        return defaultValue;
    }

    private void copyI420Buffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer, int width, int height, int stride, int sliceHeight) {
        this.copyPlane(srcBuffer, 0, dstBuffer, 0, stride, width, height);
        int srcOffset = 0 + stride * sliceHeight;
        int dstOffset = 0 + width * height;
        this.copyPlane(srcBuffer, srcOffset, dstBuffer, dstOffset, stride / 2, width / 2, height / 2);
        this.copyPlane(srcBuffer, srcOffset += stride * sliceHeight / 4, dstBuffer, dstOffset += width * height / 4, stride / 2, width / 2, height / 2);
    }

    private void copyNV12Buffer(ByteBuffer srcBuffer, ByteBuffer dstBuffer, int width, int height, int stride, int sliceHeight) {
        this.copyPlane(srcBuffer, 0, dstBuffer, 0, stride, width, height);
        int srcOffset = 0 + stride * sliceHeight;
        int dstOffset = 0 + width * height;
        this.copyPlane(srcBuffer, srcOffset, dstBuffer, dstOffset, stride, width, height / 2);
    }

    private void copyPlane(ByteBuffer srcBuffer, int srcOffset, ByteBuffer dstBuffer, int dstOffset, int stride, int width, int height) {
        OpenGlUtils.nativeCopyYuvFromByteBufferToByteBuffer(srcBuffer, srcOffset, dstBuffer, dstOffset, stride, width, height);
    }
}

