/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.os.HandlerThread;
import android.view.Surface;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.decoder.DecodeAbilityProvider;
import com.tencent.ugc.decoder.MediaCodecDecoder;
import com.tencent.ugc.decoder.MediaCodecOutputBufferDecoder;
import com.tencent.ugc.decoder.MediaCodecOutputOESTextureDecoder;
import com.tencent.ugc.decoder.VideoDecoderDef;
import com.tencent.ugc.decoder.VideoDecoderInterface;
import com.tencent.ugc.decoder.VideoDecoderListener;
import com.tencent.ugc.decoder.b;
import com.tencent.ugc.decoder.c;
import com.tencent.ugc.decoder.d;
import com.tencent.ugc.decoder.e;
import com.tencent.ugc.decoder.f;
import com.tencent.ugc.decoder.g;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.HardwareDecoderMediaFormatBuilder;
import org.json.JSONArray;

public class HardwareVideoDecoder
implements MediaCodecDecoder.MediaCodecDecoderListener,
VideoDecoderInterface {
    private String mTAG = "HardwareVideoDecoder";
    private static final int INTERVAL_DRAIN_ONE_FRAME_MORE = 30;
    private final com.tencent.liteav.base.b.b mThrottlers = new com.tencent.liteav.base.b.b();
    private Surface mOutputSurface = null;
    private MediaCodecDecoder mMediaCodecDecoder = null;
    private volatile CustomHandler mWorkHandler = null;
    private VideoDecoderListener mListener = null;
    private EncodedVideoFrame mPendingDecodeFrame = null;
    private boolean mAllowDrainDecodedFrames = true;
    private VideoDecoderDef.ConsumerScene mScene = VideoDecoderDef.ConsumerScene.UNKNOWN;
    private boolean mEnableLimitMaxDecFrameBufferingInH264Sps = false;
    private boolean mIsNeedNotifyAbandonCompleted = false;
    private final HardwareDecoderMediaFormatBuilder mDecoderMediaFormatBuilder;
    private long mDecodedFrameCount = 0L;
    private final HardwareVideoDecoderParams mParams;
    private MediaCodec mPreloadMediaCodec;

    public HardwareVideoDecoder(HardwareVideoDecoderParams params, MediaCodec preloadMediaCodec) {
        String string;
        this.mParams = new HardwareVideoDecoderParams(params);
        this.mPreloadMediaCodec = preloadMediaCodec;
        String string2 = string = this.mParams.useHevc ? "video/hevc" : "video/avc";
        if (params.mediaFormat != null) {
            this.mParams.resolution = new Size(params.mediaFormat.getInteger("width"), params.mediaFormat.getInteger("height"));
            string = params.mediaFormat.getString("mime");
        }
        this.mDecoderMediaFormatBuilder = new HardwareDecoderMediaFormatBuilder().setMediaFormat(this.mParams.mediaFormat).setMediaCodecDeviceRelatedParams(this.mParams.mediaCodecDeviceRelatedParams).setMimeType(string).setWidth(this.mParams.resolution.getWidth()).setHeight(this.mParams.resolution.getHeight());
        this.mTAG = this.mTAG + "_" + this.hashCode();
    }

    @Override
    public void initialize() {
        HandlerThread handlerThread = new HandlerThread("HardwareVideoDecoder_" + this.hashCode());
        handlerThread.start();
        this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
    }

    @Override
    public void uninitialize() {
        if (this.mWorkHandler != null) {
            LiteavLog.i(this.mTAG, "uninitialize quitLooper");
            this.mWorkHandler.quitLooper();
        }
    }

    @Override
    public void start(Object glContext, VideoDecoderListener listener) {
        HardwareVideoDecoder hardwareVideoDecoder = this;
        hardwareVideoDecoder.runOnWorkThread(b.a(hardwareVideoDecoder, glContext, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean decode(EncodedVideoFrame frame) {
        HardwareVideoDecoder hardwareVideoDecoder = this;
        synchronized (hardwareVideoDecoder) {
            if (this.mPendingDecodeFrame != null || frame == null) {
                HardwareVideoDecoder hardwareVideoDecoder2 = this;
                hardwareVideoDecoder2.runOnWorkThread(c.a(hardwareVideoDecoder2));
                return false;
            }
            this.mPendingDecodeFrame = frame;
            HardwareVideoDecoder hardwareVideoDecoder3 = this;
            hardwareVideoDecoder3.runOnWorkThread(d.a(hardwareVideoDecoder3));
            return true;
        }
    }

    @Override
    public void stop() {
        HardwareVideoDecoder hardwareVideoDecoder = this;
        hardwareVideoDecoder.runOnWorkThread(e.a(hardwareVideoDecoder));
    }

    @Override
    public void abandonDecodingFrames() {
        LiteavLog.i(this.mTAG, "flush");
        HardwareVideoDecoder hardwareVideoDecoder = this;
        hardwareVideoDecoder.runOnWorkThread(f.a(hardwareVideoDecoder));
    }

    @Override
    public void setScene(VideoDecoderDef.ConsumerScene scene) {
        HardwareVideoDecoder hardwareVideoDecoder = this;
        hardwareVideoDecoder.runOnWorkThread(g.a(hardwareVideoDecoder, scene));
    }

    @Override
    public VideoDecoderInterface.DecoderType getDecoderType() {
        if (this.mParams == null || !this.mParams.useSoftDecoder) {
            return VideoDecoderInterface.DecoderType.HARDWARE;
        }
        return VideoDecoderInterface.DecoderType.SOFTWARE_DEVICE;
    }

    @Override
    public void onDecodeFrame(PixelFrame pixelFrame, boolean isEOS) {
        if (isEOS) {
            this.notifyEndOfStream();
            this.mAllowDrainDecodedFrames = true;
            return;
        }
        if (pixelFrame == null) {
            return;
        }
        ++this.mDecodedFrameCount;
        this.mAllowDrainDecodedFrames = true;
        if (this.mListener != null) {
            PixelFrame pixelFrame2 = pixelFrame;
            this.mListener.onDecodeFrame(pixelFrame2, pixelFrame2.getTimestamp());
        }
        try {
            if (this.allowDrainOneFrameMore() && this.drainDecodedFrame()) {
                LiteavLog.d(this.mTAG, "drain more frame success");
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mThrottlers.a("drainDecodedFrame"), this.mTAG, "exception from drain decoded frame, message:" + throwable.getMessage(), new Object[0]);
        }
        if (this.mIsNeedNotifyAbandonCompleted) {
            this.notifyOnAbandonDecodingFramesCompleted();
            this.mIsNeedNotifyAbandonCompleted = false;
        }
    }

    @Override
    public void onDecoderError() {
        this.handleDecoderError();
    }

    private void startInternal(Object glContext, VideoDecoderListener listener) {
        boolean bl2;
        String string;
        LiteavLog.i(this.mTAG, "Start decoder with eglContext:%s", glContext);
        System.currentTimeMillis();
        if (this.mMediaCodecDecoder != null) {
            LiteavLog.w(this.mTAG, "Decoder already started.");
            return;
        }
        String string2 = string = this.mParams.useHevc ? "video/hevc" : "video/avc";
        if (this.mParams.mediaFormat != null) {
            string = this.mParams.mediaFormat.getString("mime");
        }
        int n2 = DecodeAbilityProvider.getInstance().getSupportColorFormat(string);
        if (this.mParams.useOutputBuffer && MediaCodecOutputBufferDecoder.isSupportColorFormat(n2)) {
            HardwareVideoDecoder hardwareVideoDecoder = this;
            this.mMediaCodecDecoder = new MediaCodecOutputBufferDecoder(this.mDecoderMediaFormatBuilder, this.mParams.resolution, this.mParams.useSoftDecoder, hardwareVideoDecoder, hardwareVideoDecoder.mWorkHandler);
        } else {
            HardwareVideoDecoder hardwareVideoDecoder = this;
            this.mMediaCodecDecoder = new MediaCodecOutputOESTextureDecoder(this.mDecoderMediaFormatBuilder, this.mParams.resolution, this.mParams.useSoftDecoder, hardwareVideoDecoder, hardwareVideoDecoder.mWorkHandler);
        }
        this.mMediaCodecDecoder.enableLimitMaxDecFrameBuffer(this.mEnableLimitMaxDecFrameBufferingInH264Sps && this.mScene == VideoDecoderDef.ConsumerScene.RTC);
        this.mMediaCodecDecoder.start(glContext);
        this.mListener = listener;
        MediaCodecDecoder.BuildResult buildResult = this.mMediaCodecDecoder.buildMediaCodec(this.mParams.isLowLatencyEnabled, this.mPreloadMediaCodec);
        boolean bl3 = bl2 = this.mParams.isLowLatencyEnabled && buildResult.isSuccess;
        if (!buildResult.isSuccess) {
            buildResult = this.mMediaCodecDecoder.buildMediaCodec(false, null);
        }
        if (buildResult.isSuccess) {
            if (this.mListener != null) {
                this.mListener.onDecodeLatencyChanged(bl2);
            }
            System.currentTimeMillis();
            return;
        }
        this.stopInternal();
        this.handleDecoderError();
    }

    private void stopInternal() {
        LiteavLog.i(this.mTAG, "Stop decoder");
        if (this.mMediaCodecDecoder != null) {
            this.mMediaCodecDecoder.stop();
            this.mMediaCodecDecoder = null;
        }
        this.releasePendingDecodeFrame();
        this.mAllowDrainDecodedFrames = true;
        this.mDecodedFrameCount = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainAndFeedFrame() {
        if (this.mMediaCodecDecoder == null) {
            LiteavLog.w(this.mTAG, "MediaCodec is stopped.");
            this.releasePendingDecodeFrame();
            return;
        }
        try {
            EncodedVideoFrame encodedVideoFrame;
            if (this.mAllowDrainDecodedFrames) {
                this.drainDecodedFrame();
            }
            HardwareVideoDecoder hardwareVideoDecoder = this;
            synchronized (hardwareVideoDecoder) {
                encodedVideoFrame = this.mPendingDecodeFrame;
            }
            if (encodedVideoFrame == null || !this.mMediaCodecDecoder.feedEncodedFrame(encodedVideoFrame)) {
                return;
            }
            hardwareVideoDecoder = this;
            synchronized (hardwareVideoDecoder) {
                if (this.mPendingDecodeFrame == encodedVideoFrame) {
                    this.mPendingDecodeFrame = null;
                }
                return;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "decode failed.", throwable);
            this.handleDecoderError();
            return;
        }
    }

    private void abandonDecodingFramesInternal() {
        this.releasePendingDecodeFrame();
        if (this.mMediaCodecDecoder != null) {
            this.mMediaCodecDecoder.flush();
        }
        if (this.mAllowDrainDecodedFrames) {
            this.notifyOnAbandonDecodingFramesCompleted();
            return;
        }
        this.mIsNeedNotifyAbandonCompleted = true;
    }

    private void notifyOnAbandonDecodingFramesCompleted() {
        if (this.mListener != null) {
            this.mListener.onAbandonDecodingFramesCompleted();
        }
    }

    private void releasePendingDecodeFrame() {
        this.mPendingDecodeFrame = null;
    }

    private boolean drainDecodedFrame() {
        if (this.mMediaCodecDecoder.drainDecodedFrame()) {
            this.mAllowDrainDecodedFrames = false;
        }
        return this.mAllowDrainDecodedFrames;
    }

    private boolean allowDrainOneFrameMore() {
        return this.mDecodedFrameCount % 30L == 0L;
    }

    private void notifyEndOfStream() {
        if (this.mListener != null) {
            this.mListener.onDecodeCompleted();
        }
    }

    private void handleDecoderError() {
        this.releasePendingDecodeFrame();
        if (this.mListener != null) {
            this.mListener.onDecodeFailed();
        }
    }

    private void runOnWorkThread(Runnable runnable) {
        if (this.mWorkHandler != null) {
            this.mWorkHandler.runOrPost(runnable);
        }
    }

    static /* synthetic */ void lambda$setScene$1(HardwareVideoDecoder this_, VideoDecoderDef.ConsumerScene scene) {
        this_.mScene = scene;
        if (this_.mMediaCodecDecoder != null) {
            this_.mMediaCodecDecoder.enableLimitMaxDecFrameBuffer(this_.mEnableLimitMaxDecFrameBufferingInH264Sps && this_.mScene == VideoDecoderDef.ConsumerScene.RTC);
        }
    }

    static /* synthetic */ void lambda$start$0(HardwareVideoDecoder this_, Object glContext, VideoDecoderListener listener) {
        this_.startInternal(glContext, listener);
    }

    static /* synthetic */ void access$lambda$0(HardwareVideoDecoder hardwareVideoDecoder) {
        hardwareVideoDecoder.drainAndFeedFrame();
    }

    static /* synthetic */ void access$lambda$1(HardwareVideoDecoder hardwareVideoDecoder) {
        hardwareVideoDecoder.drainAndFeedFrame();
    }

    static /* synthetic */ void access$lambda$2(HardwareVideoDecoder hardwareVideoDecoder) {
        hardwareVideoDecoder.stopInternal();
    }

    static /* synthetic */ void access$lambda$3(HardwareVideoDecoder hardwareVideoDecoder) {
        hardwareVideoDecoder.abandonDecodingFramesInternal();
    }

    public static class HardwareVideoDecoderParams {
        public boolean isHDR = false;
        public boolean useHevc = false;
        public boolean useOutputBuffer = false;
        public boolean isLowLatencyEnabled = false;
        public Size resolution = null;
        public MediaFormat mediaFormat = null;
        public boolean useSoftDecoder = false;
        public JSONArray mediaCodecDeviceRelatedParams = null;

        public HardwareVideoDecoderParams(HardwareVideoDecoderParams params) {
            this.isHDR = params.isHDR;
            this.useHevc = params.useHevc;
            this.useOutputBuffer = params.useOutputBuffer;
            this.isLowLatencyEnabled = params.isLowLatencyEnabled;
            this.resolution = params.resolution;
            this.mediaFormat = params.mediaFormat;
            this.mediaCodecDeviceRelatedParams = params.mediaCodecDeviceRelatedParams;
            this.useSoftDecoder = params.useSoftDecoder;
        }

        public HardwareVideoDecoderParams() {
        }
    }
}

