/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.common;

import android.media.MediaFormat;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.AudioEncodeParams;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class UGCTranscodeAudioEncodeParamsDecider {
    private static final String TAG = "UGCTranscodeAudioEncodeParamsDecider";
    private static final int DEFAULT_SAMPLE_RATE = 48000;
    private static final int DEFAULT_CHANNEL_COUNT = 1;
    private static final int DEFAULT_BITRATE = 51200;
    private final long mNativeHandler = UGCTranscodeAudioEncodeParamsDecider.nativeCreate();

    public void finalize() throws Throwable {
        UGCTranscodeAudioEncodeParamsDecider.nativeDestroy(this.mNativeHandler);
    }

    public void setEncodeBitrate(int bitrate) {
        UGCTranscodeAudioEncodeParamsDecider.nativeSetEncodeBitrate(this.mNativeHandler, bitrate);
    }

    public void setInputAudioMediaFormat(List<MediaFormat> audioMediaFormatList) {
        if (audioMediaFormatList == null) {
            return;
        }
        int[] nArray = new int[audioMediaFormatList.size()];
        int[] nArray2 = new int[audioMediaFormatList.size()];
        int[] nArray3 = new int[audioMediaFormatList.size()];
        for (int i2 = 0; i2 < audioMediaFormatList.size(); ++i2) {
            MediaFormat mediaFormat = audioMediaFormatList.get(i2);
            nArray[i2] = this.getNumberFromMediaFormat(mediaFormat, "channel-count", 1);
            nArray2[i2] = this.getNumberFromMediaFormat(mediaFormat, "bitrate", 51200);
            nArray3[i2] = this.getNumberFromMediaFormat(mediaFormat, "sample-rate", 48000);
        }
        UGCTranscodeAudioEncodeParamsDecider.nativeSetSourceAudioInfoList(this.mNativeHandler, nArray, nArray2, nArray3);
    }

    public void setBGMMediaFormat(MediaFormat bgmMediaFormat) {
        if (bgmMediaFormat == null) {
            return;
        }
        int n2 = this.getNumberFromMediaFormat(bgmMediaFormat, "channel-count", 1);
        int n3 = this.getNumberFromMediaFormat(bgmMediaFormat, "bitrate", 51200);
        int n4 = this.getNumberFromMediaFormat(bgmMediaFormat, "sample-rate", 48000);
        UGCTranscodeAudioEncodeParamsDecider.nativeSetBGMAudioInfo(this.mNativeHandler, n2, n3, n4);
    }

    public AudioEncodeParams getDecidedEncodeParams() {
        AudioEncodeParams audioEncodeParams = new AudioEncodeParams();
        audioEncodeParams.setSampleRate(UGCTranscodeAudioEncodeParamsDecider.nativeGetSelectedSampleRate(this.mNativeHandler));
        audioEncodeParams.setChannels(UGCTranscodeAudioEncodeParamsDecider.nativeGetSelectedChannels(this.mNativeHandler));
        audioEncodeParams.setBitsPerChannel(UGCTranscodeAudioEncodeParamsDecider.nativeGetSelectedBitPerChannels(this.mNativeHandler));
        audioEncodeParams.setBitrate(UGCTranscodeAudioEncodeParamsDecider.nativeGetSelectedBitrate(this.mNativeHandler));
        return audioEncodeParams;
    }

    private int getNumberFromMediaFormat(MediaFormat mediaFormat, String key, int defaultValue) {
        int n2 = defaultValue;
        if (mediaFormat == null || !mediaFormat.containsKey(key)) {
            return defaultValue;
        }
        try {
            n2 = mediaFormat.getInteger(key);
        }
        catch (Throwable throwable) {
            LiteavLog.w(TAG, "getNumberFromMediaFormat integer ClassCastException: ".concat(String.valueOf(throwable)));
            try {
                n2 = (int)mediaFormat.getFloat(key);
            }
            catch (Throwable throwable2) {
                LiteavLog.w(TAG, "getNumberFromMediaFormat float ClassCastException: ".concat(String.valueOf(throwable2)));
            }
        }
        return n2;
    }

    private static native long nativeCreate();

    private static native void nativeDestroy(long var0);

    private static native void nativeSetEncodeBitrate(long var0, int var2);

    private static native void nativeSetSourceAudioInfoList(long var0, int[] var2, int[] var3, int[] var4);

    private static native void nativeSetBGMAudioInfo(long var0, int var2, int var3, int var4);

    private static native int nativeGetSelectedChannels(long var0);

    private static native int nativeGetSelectedBitrate(long var0);

    private static native int nativeGetSelectedSampleRate(long var0);

    private static native int nativeGetSelectedBitPerChannels(long var0);
}

