/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters.vague;

import com.tencent.ugc.beauty.gpufilters.BeautyInterFace;
import com.tencent.ugc.beauty.gpufilters.TXCGPUSharpenFilter;
import com.tencent.ugc.beauty.gpufilters.vague.TXCGChannelBeautyFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilterChain;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class BeautyVagueFilter
extends TXCGPUImageFilterChain
implements BeautyInterFace {
    private final TXCGChannelBeautyFilter mGreenBeautyFilter = new TXCGChannelBeautyFilter();
    private final TXCGPUSharpenFilter mSharpnessFilter = new TXCGPUSharpenFilter();
    private float mBeautyLevel = 0.0f;
    private float mWhiteLevel = 0.0f;
    private float mRuddyLevel = 0.0f;
    private float mSharpnessLevel = 0.0f;

    public BeautyVagueFilter() {
        BeautyVagueFilter beautyVagueFilter = this;
        beautyVagueFilter.addFilter(beautyVagueFilter.mGreenBeautyFilter);
        BeautyVagueFilter beautyVagueFilter2 = this;
        beautyVagueFilter2.addFilter(beautyVagueFilter2.mSharpnessFilter);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mGreenBeautyFilter.setBeautyLevel(this.mBeautyLevel);
        this.mGreenBeautyFilter.setWhitenessLevel(this.mWhiteLevel);
        this.mGreenBeautyFilter.setRuddyLevel(this.mRuddyLevel);
        this.mSharpnessFilter.setSharpness(this.mSharpnessLevel / 2.0f);
    }

    @Override
    public void setBeautyLevel(float level) {
        this.mBeautyLevel = level;
        this.mGreenBeautyFilter.setBeautyLevel(this.mBeautyLevel);
    }

    @Override
    public void setWhitenessLevel(float level) {
        this.mWhiteLevel = level;
        this.mGreenBeautyFilter.setWhitenessLevel(this.mWhiteLevel);
    }

    @Override
    public void setRuddyLevel(float level) {
        this.mRuddyLevel = level;
        this.mGreenBeautyFilter.setRuddyLevel(this.mRuddyLevel);
    }

    @Override
    public void setSharpenLevel(float level) {
        this.mSharpnessLevel = level;
        this.mSharpnessFilter.setSharpness(level / 2.0f);
    }

    @Override
    public boolean canBeSkipped() {
        return this.mGreenBeautyFilter.canBeSkipped() && this.mSharpnessFilter.canBeSkipped();
    }
}

