/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.content.Context;
import android.graphics.BitmapFactory;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.beauty.decoder.VideoFrameReader;
import com.tencent.ugc.beauty.gpufilters.TXCGPUColorScreenFilter;
import com.tencent.ugc.beauty.gpufilters.b;
import com.tencent.ugc.beauty.gpufilters.c;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.FloatBuffer;

public class TXCGPUGreenScreenFilter
extends TXCGPUImageFilter {
    private static final String TAG = "TXCGPUGreenScreenFilter";
    private final Context mContext;
    private final PixelFrame mPixelFrame = new PixelFrame();
    private PixelFrameRenderer mPixelFrameRenderer;
    private TXCGPUColorScreenFilter mColorScreenFilter;
    private GLConstants.GLScaleType mScaleType;
    private boolean mMirrorX;
    private String mGreenScreenFile;
    private boolean mLoopVideo = false;
    private VideoFrameReader mVideoFrameReader;
    private GreenScreenFilterEventListener mEventListener = null;
    private VideoFrameReader.VideoFrameReaderListener mVideoFrameReaderListener = new VideoFrameReader.VideoFrameReaderListener(){

        @Override
        public final void onFrameAvailable(PixelFrame pixelFrame) {
            if (TXCGPUGreenScreenFilter.this.mPixelFrame.getMatrix() == null) {
                TXCGPUGreenScreenFilter.this.mPixelFrame.setMatrix(new float[16]);
            }
            TXCGPUGreenScreenFilter.this.mPixelFrame.setPixelBufferType(pixelFrame.getPixelBufferType());
            TXCGPUGreenScreenFilter.this.mPixelFrame.setPixelFormatType(pixelFrame.getPixelFormatType());
            System.arraycopy(pixelFrame.getMatrix(), 0, TXCGPUGreenScreenFilter.this.mPixelFrame.getMatrix(), 0, pixelFrame.getMatrix().length);
            TXCGPUGreenScreenFilter.this.mPixelFrame.setTimestamp(pixelFrame.getTimestamp());
            TXCGPUGreenScreenFilter.this.mPixelFrame.setTextureId(pixelFrame.getTextureId());
            TXCGPUGreenScreenFilter.this.mPixelFrame.setWidth(pixelFrame.getWidth());
            TXCGPUGreenScreenFilter.this.mPixelFrame.setHeight(pixelFrame.getHeight());
        }

        @Override
        public final void onReadFinished() {
            TXCGPUGreenScreenFilter.this.runOnDrawAndWaitDone(c.a(this));
        }

        static /* synthetic */ void a(1 var0) {
            if (var0.TXCGPUGreenScreenFilter.this.mVideoFrameReader != null) {
                var0.TXCGPUGreenScreenFilter.this.mPixelFrame.setTextureId(-1);
                var0.TXCGPUGreenScreenFilter.this.destroyPlayer();
            }
        }
    };

    public TXCGPUGreenScreenFilter(Context context) {
        this.mContext = context;
    }

    public void setGreenScreenFile(String path, boolean isLoop) {
        TXCGPUGreenScreenFilter tXCGPUGreenScreenFilter = this;
        tXCGPUGreenScreenFilter.runOnDraw(b.a(tXCGPUGreenScreenFilter, path, isLoop));
    }

    public void setGreenScreenParam(GLConstants.GLScaleType scaleType, boolean mirrorX) {
        this.mScaleType = scaleType;
        this.mMirrorX = mirrorX;
    }

    public void setEventListener(GreenScreenFilterEventListener listener) {
        this.mEventListener = listener;
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mColorScreenFilter = new TXCGPUColorScreenFilter();
        this.mColorScreenFilter.initialize(texturePool);
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        int n2;
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        if (this.mPixelFrame.getTextureId() == -1) {
            super.onDraw(inTextureId, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
            return;
        }
        GLTexture gLTexture = this.mTexturePool.obtain(this.mOutputSize.width, this.mOutputSize.height);
        if (this.mPixelFrameRenderer == null) {
            this.mPixelFrameRenderer = new PixelFrameRenderer(this.mOutputSize.width, this.mOutputSize.height);
        }
        if (!this.mPixelFrame.hasTransformParams() && this.mPixelFrame.getPixelBufferType() == GLConstants.a.b && this.mPixelFrame.getPixelFormatType() == GLConstants.PixelFormatType.f) {
            n2 = this.mPixelFrame.getTextureId();
        } else {
            this.mPixelFrameRenderer.renderFrame(this.mPixelFrame, this.mScaleType, gLTexture);
            n2 = gLTexture.getId();
        }
        this.mColorScreenFilter.setScreenMirrorX(this.mMirrorX);
        this.mColorScreenFilter.setSecondInputTexture(inTextureId);
        this.mColorScreenFilter.setThirdInputTexture(n2);
        this.mColorScreenFilter.onDraw(inTextureId, outTexture, cubeCoordsBuffer, textureCoordsBuffer);
        gLTexture.release();
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        this.mColorScreenFilter.onOutputSizeChanged(width, height);
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
    }

    @Override
    public void onUninit() {
        this.destroyPlayer();
        if (this.mColorScreenFilter != null) {
            this.mColorScreenFilter.uninitialize();
            this.mColorScreenFilter = null;
        }
        if (this.mPixelFrameRenderer != null) {
            this.mPixelFrameRenderer.uninitialize();
            this.mPixelFrameRenderer = null;
        }
        super.onUninit();
    }

    private void loadGreenScreenFile() {
        if (this.mGreenScreenFile == null || this.mGreenScreenFile.isEmpty()) {
            LiteavLog.e(TAG, "green file is empty!");
            return;
        }
        String string = CommonUtil.getFileExtension(this.mGreenScreenFile);
        boolean bl2 = false;
        if (string == null) {
            bl2 = true;
            this.destroyPlayer();
        } else if ("jpg".equals(string = string.toLowerCase()) || "png".equals(string) || "bmp".equals(string)) {
            this.destroyPlayer();
            this.deleteTextureInPixelFrame();
            TXCGPUGreenScreenFilter tXCGPUGreenScreenFilter = this;
            bl2 = !tXCGPUGreenScreenFilter.loadPictureToTexture(tXCGPUGreenScreenFilter.mGreenScreenFile);
        } else if ("mp4".equals(string)) {
            this.destroyPlayer();
            this.deleteTextureInPixelFrame();
            boolean bl3 = bl2 = !this.initializeVideoPlayer();
        }
        if (bl2 && this.mGreenScreenFile != null && !this.mGreenScreenFile.isEmpty()) {
            if (this.mEventListener != null) {
                this.mEventListener.onLoadFailed();
            }
            LiteavLog.e(TAG, "Load GreenScreenFile: %s fail, and report EVENT_GREENFILE_DECODE_FAILED", this.mGreenScreenFile);
        }
    }

    private void destroyPlayer() {
        if (this.mVideoFrameReader != null) {
            this.mVideoFrameReader.setVideoFrameReadListener(null);
            this.mVideoFrameReader.stop();
            this.mVideoFrameReader = null;
        }
    }

    private void deleteTextureInPixelFrame() {
        if (this.mPixelFrame.getPixelBufferType() == GLConstants.a.b) {
            OpenGlUtils.deleteTexture(this.mPixelFrame.getTextureId());
            this.mPixelFrame.setTextureId(-1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean loadPictureToTexture(String filepath) {
        var2_2 = null;
        if (filepath.startsWith("/")) {
            var2_2 = BitmapFactory.decodeFile((String)filepath);
        } else {
            var3_3 = null;
            try {
                var3_3 = this.mContext.getAssets().open(filepath);
                var2_2 = BitmapFactory.decodeStream((InputStream)var3_3);
                ** if (var3_3 == null) goto lbl-1000
            }
            catch (IOException var4_4) {
                try {
                    LiteavLog.e("TXCGPUGreenScreenFilter", "open file failed.", var4_4);
                    ** if (var3_3 == null) goto lbl-1000
                }
                catch (Throwable var5_5) {
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException v2) {}
                    }
                    throw var5_5;
                }
lbl-1000:
                // 1 sources

                {
                    try {
                        var3_3.close();
                    }
                    catch (IOException v1) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
lbl-1000:
            // 1 sources

            {
                try {
                    var3_3.close();
                }
                catch (IOException v0) {}
            }
lbl-1000:
            // 2 sources

            {
            }
        }
        if (var2_2 == null) {
            return false;
        }
        this.mPixelFrame.setWidth(var2_2.getWidth());
        this.mPixelFrame.setHeight(var2_2.getHeight());
        this.mPixelFrame.setPixelBufferType(GLConstants.a.b);
        this.mPixelFrame.setTextureId(OpenGlUtils.loadTexture(var2_2, -1, true));
        this.mPixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
        LiteavLog.i("TXCGPUGreenScreenFilter", "picture set GreenFile %dx%d", new Object[]{this.mPixelFrame.getWidth(), this.mPixelFrame.getHeight()});
        return true;
    }

    private boolean initializeVideoPlayer() {
        this.mVideoFrameReader = new VideoFrameReader(this.mContext, OpenGlUtils.getCurrentContext(), this.mGreenScreenFile, this.mLoopVideo);
        this.mVideoFrameReader.setVideoFrameReadListener(this.mVideoFrameReaderListener);
        boolean bl2 = this.mVideoFrameReader.start();
        if (bl2) {
            this.mPixelFrame.setWidth(-1);
            this.mPixelFrame.setHeight(-1);
            this.mPixelFrame.setPixelBufferType(GLConstants.a.c);
            this.mPixelFrame.setPixelFormatType(GLConstants.PixelFormatType.f);
            this.mPixelFrame.setTextureId(-1);
        }
        return bl2;
    }

    static /* synthetic */ void lambda$setGreenScreenFile$0(TXCGPUGreenScreenFilter this_, String path, boolean isLoop) {
        this_.mGreenScreenFile = path;
        this_.mLoopVideo = isLoop;
        this_.loadGreenScreenFile();
    }

    public static interface GreenScreenFilterEventListener {
        public void onLoadFailed();
    }
}

