/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.gpufilters;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexturePool;

public class TXCGPUGammaFilter
extends TXCGPUImageFilter {
    public static final String GAMMA_FRAGMENT_SHADER = "varying lowp vec2 textureCoordinate;\n\nuniform sampler2D inputImageTexture;\nuniform lowp float gamma;\n\nvoid main()\n{\n    lowp vec4 textureColor = texture2D(inputImageTexture, textureCoordinate);\n\n    gl_FragColor = vec4(pow(textureColor.rgb, vec3(gamma)), textureColor.w);\n}";
    private int mGammaLocation;
    private float mGamma;

    public TXCGPUGammaFilter() {
        this(1.2f);
    }

    public TXCGPUGammaFilter(float gamma) {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", GAMMA_FRAGMENT_SHADER);
        this.mGamma = gamma;
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mGammaLocation = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"gamma");
        TXCGPUGammaFilter tXCGPUGammaFilter = this;
        tXCGPUGammaFilter.setGamma(tXCGPUGammaFilter.mGamma);
    }

    public void setGamma(float gamma) {
        this.mGamma = gamma;
        TXCGPUGammaFilter tXCGPUGammaFilter = this;
        tXCGPUGammaFilter.setFloatOnDraw(tXCGPUGammaFilter.mGammaLocation, this.mGamma);
    }
}

