/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.decoder.ProcessException;
import com.tencent.ugc.beauty.decoder.SetupException;

public abstract class Stage {
    private static final String TAG = "Stage";
    protected static final int DEFAULT_FRAME_COUNT = 3;
    protected State mState = State.INIT;

    public abstract void setup() throws SetupException;

    public abstract void processFrame() throws ProcessException;

    public abstract void release();

    public boolean isDone() {
        return this.mState == State.DONE;
    }

    protected void setState(State state) {
        this.mState = state;
        if (State.DONE == this.mState) {
            LiteavLog.i(TAG, this + "is done");
        }
    }

    protected boolean isAllDataReady() {
        return this.mState == State.ALL_DATA_READY || this.mState == State.DONE;
    }

    protected static enum State {
        INIT,
        SETUPED,
        ALL_DATA_READY,
        DONE;

    }
}

