/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import android.media.MediaCodec;
import android.media.MediaExtractor;
import android.media.MediaFormat;
import com.tencent.ugc.beauty.decoder.ExtractorAdvancer;
import java.nio.ByteBuffer;

public class RangeExtractorAdvancer
extends ExtractorAdvancer {
    protected long mRangeEndUs;
    private long mFirstFrameTime;
    private int mLoopCount = -1;

    public RangeExtractorAdvancer() {
        this(-1L);
    }

    public RangeExtractorAdvancer(long endUs) {
        this.mRangeEndUs = endUs;
    }

    @Override
    public void updateExtractor(MediaExtractor mediaExtractor) {
        super.updateExtractor(mediaExtractor);
        if (this.mRangeEndUs == -1L) {
            MediaFormat mediaFormat = this.mMediaExtractor.getTrackFormat(this.mMediaExtractor.getSampleTrackIndex());
            this.mRangeEndUs = mediaFormat.getLong("durationUs");
        }
        this.mFirstFrameTime = this.mMediaExtractor.getSampleTime();
    }

    @Override
    public void readSampleData(MediaCodec.BufferInfo bufferInfo, ByteBuffer byteBuf, int offset) {
        if (this.isInRange()) {
            if (this.mMediaExtractor.getSampleTime() == this.mFirstFrameTime) {
                ++this.mLoopCount;
            }
            bufferInfo.size = this.mMediaExtractor.readSampleData(byteBuf, offset);
            bufferInfo.flags = this.mMediaExtractor.getSampleFlags();
            bufferInfo.presentationTimeUs = (long)this.mLoopCount * this.mRangeEndUs + this.mMediaExtractor.getSampleTime();
            bufferInfo.offset = offset;
            return;
        }
        bufferInfo.size = -1;
    }

    @Override
    public boolean advance() {
        return this.isInRange() && this.mMediaExtractor.advance();
    }

    @Override
    public long getSampleTime() {
        return this.mMediaExtractor.getSampleTime();
    }

    protected boolean isInRange() {
        long l2 = this.mMediaExtractor.getSampleTime();
        return 0L <= l2 && (this.mRangeEndUs == -1L || l2 <= this.mRangeEndUs);
    }
}

