/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.beauty.decoder;

import android.graphics.SurfaceTexture;
import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.beauty.decoder.Extractor;
import com.tencent.ugc.beauty.decoder.Frame;
import com.tencent.ugc.beauty.decoder.MediaUtils;
import com.tencent.ugc.beauty.decoder.ProcessException;
import com.tencent.ugc.beauty.decoder.ProvidedStage;
import com.tencent.ugc.beauty.decoder.SetupException;
import com.tencent.ugc.beauty.decoder.Stage;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class Decoder
extends ProvidedStage<Frame> {
    private static final String TAG = "Decoder";
    private final Extractor mExtractor;
    private final Object mNativeWindow;
    private final MediaCodec.BufferInfo mBufferInfo;
    private MediaCodec mMediaCodec;
    private boolean mIsLooping = false;
    private long mSkipFrameBeforeInThisLoop = 0L;

    public Decoder(Extractor extractor) {
        this(extractor, null);
    }

    public Decoder(Extractor extractor, SurfaceTexture surfaceTexture) {
        this.mExtractor = extractor;
        this.mNativeWindow = surfaceTexture;
        this.mBufferInfo = new MediaCodec.BufferInfo();
    }

    public void setLooping(boolean isLooping) {
        this.mIsLooping = isLooping;
    }

    @Override
    public void setup() throws SetupException {
        Surface surface = null;
        try {
            Decoder decoder = this;
            surface = decoder.getOutputSurface(decoder.mNativeWindow);
            LiteavLog.i(TAG, "output surface: ".concat(String.valueOf(surface)));
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get output surface failed.", throwable);
        }
        this.mExtractor.setup();
        MediaFormat mediaFormat = this.mExtractor.getMediaFormat();
        String string = mediaFormat.getString("mime");
        LiteavLog.i(TAG, "Decoder[%d] for %s", this.mExtractor.getTraceIndex(), string);
        try {
            this.mMediaCodec = MediaCodec.createDecoderByType((String)string);
            this.mMediaCodec.configure(mediaFormat, surface, null, 0);
            this.mMediaCodec.start();
        }
        catch (IOException iOException) {
            throw new SetupException("configure MediaCodec failed.", iOException);
        }
        this.setState(Stage.State.SETUPED);
    }

    @Override
    public void processFrame() throws ProcessException {
        try {
            super.processFrame();
            this.feedDataToMediaCodec();
            this.drainDecodedFrame();
            return;
        }
        catch (Throwable throwable) {
            throw new ProcessException("decode failed", throwable);
        }
    }

    @Override
    public void release() {
        LiteavLog.i(TAG, "released decoder");
        this.mExtractor.release();
        if (this.mMediaCodec == null) {
            return;
        }
        try {
            this.mMediaCodec.stop();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec stop failed.".concat(String.valueOf(throwable)));
        }
        try {
            this.mMediaCodec.release();
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec release failed.".concat(String.valueOf(throwable)));
            return;
        }
    }

    @Override
    protected void recycleBuffers(List<Frame> canReuseBuffers) {
        for (Frame frame : canReuseBuffers) {
            if (this.mNativeWindow != null && LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
                this.mMediaCodec.releaseOutputBuffer(frame.bufferIndex, TimeUnit.MICROSECONDS.toNanos(frame.presentationTimeUs));
                continue;
            }
            this.mMediaCodec.releaseOutputBuffer(frame.bufferIndex, this.mNativeWindow != null);
        }
    }

    private Surface getOutputSurface(Object window) throws ExecutionException, InterruptedException {
        if (window == null) {
            return null;
        }
        while (window instanceof Future) {
            window = ((Future)window).get();
        }
        if (window instanceof Surface) {
            return (Surface)window;
        }
        if (window instanceof SurfaceTexture) {
            return new Surface((SurfaceTexture)window);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drainDecodedFrame() {
        Decoder decoder = this;
        synchronized (decoder) {
            if (this.mWaitOutBuffers.size() >= 3) {
                return;
            }
        }
        int n2 = this.mMediaCodec.dequeueOutputBuffer(this.mBufferInfo, 0L);
        if (n2 == -1) {
            return;
        }
        if (n2 == -3) {
            LiteavLog.i(TAG, "decoder output buffers changed");
            return;
        }
        if (n2 == -2) {
            MediaFormat mediaFormat = this.mMediaCodec.getOutputFormat();
            LiteavLog.i(TAG, "decoder output format changed: ".concat(String.valueOf(mediaFormat)));
            return;
        }
        if (n2 < 0) {
            throw new RuntimeException("unexpected result from decoder.dequeueOutputBuffer: ".concat(String.valueOf(n2)));
        }
        ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? this.mMediaCodec.getOutputBuffer(n2) : this.mMediaCodec.getOutputBuffers()[n2];
        Frame frame = new Frame();
        new Frame().buffer = byteBuffer;
        frame.bufferIndex = n2;
        frame.offset = this.mBufferInfo.offset;
        frame.size = this.mBufferInfo.size;
        frame.presentationTimeUs = this.mBufferInfo.presentationTimeUs;
        frame.flags = this.mBufferInfo.flags;
        if (this.mSkipFrameBeforeInThisLoop > frame.presentationTimeUs && !MediaUtils.hasEosFlag(frame.flags)) {
            this.mMediaCodec.releaseOutputBuffer(frame.bufferIndex, false);
        } else {
            Decoder decoder2 = this;
            synchronized (decoder2) {
                this.mWaitOutBuffers.add(frame);
            }
        }
        if (MediaUtils.hasEosFlag(frame.flags)) {
            this.setState(Stage.State.ALL_DATA_READY);
        }
    }

    private void feedDataToMediaCodec() throws SetupException {
        if (this.isAllDataReady()) {
            return;
        }
        int n2 = this.mMediaCodec.dequeueInputBuffer(0L);
        if (n2 < 0) {
            return;
        }
        ByteBuffer byteBuffer = this.mMediaCodec.getInputBuffers()[n2];
        MediaCodec.BufferInfo bufferInfo = this.mExtractor.readSampleData(byteBuffer);
        if (this.mIsLooping && MediaUtils.hasEosFlag(bufferInfo.flags)) {
            this.mExtractor.restart();
            bufferInfo.set(0, 0, 0L, 0);
            this.mSkipFrameBeforeInThisLoop = 0L;
        }
        this.mMediaCodec.queueInputBuffer(n2, bufferInfo.offset, bufferInfo.size, bufferInfo.presentationTimeUs, bufferInfo.flags);
    }
}

