/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCCombineFrameFilter;
import com.tencent.ugc.UGCTransitionProcessor;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import java.util.LinkedList;
import java.util.List;

public class UGCCombineProcessor {
    private final String TAG = "UGCCombineProcessor";
    private final UGCCombineFrameFilter mUGCCombineProcessor;
    private final int mOutputPixelWidth;
    private final int mOutputPixelHeight;
    private final List<PixelFrameRenderer> mScaleRendererList;
    private final List<TXVideoEditConstants.TXAbsoluteRect> mScaleRectList;
    private final GLTexturePool mGLTexturePool;

    public UGCCombineProcessor(int outputPixelWidth, int outputPixelHeight, GLTexturePool glTexturePool) {
        LiteavLog.i("UGCCombineProcessor", "UGCCombineProcessor pixelWidth = " + outputPixelWidth + " pixelHeight = " + outputPixelHeight);
        this.mOutputPixelWidth = outputPixelWidth;
        this.mOutputPixelHeight = outputPixelHeight;
        this.mGLTexturePool = glTexturePool;
        this.mScaleRendererList = new LinkedList<PixelFrameRenderer>();
        this.mScaleRectList = new LinkedList<TXVideoEditConstants.TXAbsoluteRect>();
        this.mUGCCombineProcessor = new UGCCombineFrameFilter(glTexturePool);
    }

    public void release() {
        this.mUGCCombineProcessor.release();
        for (PixelFrameRenderer pixelFrameRenderer : this.mScaleRendererList) {
            if (pixelFrameRenderer == null) continue;
            pixelFrameRenderer.uninitialize();
        }
        this.mScaleRendererList.clear();
        this.mScaleRectList.clear();
    }

    public PixelFrame processFrame(List<PixelFrame> frameList, List<TXVideoEditConstants.TXAbsoluteRect> rectList) {
        PixelFrame pixelFrame;
        if (frameList == null || frameList.size() == 0) {
            LiteavLog.e("UGCCombineProcessor", "frameList is empty");
            return null;
        }
        this.Retain(frameList);
        LinkedList<UGCTransitionProcessor.TXCCombineFrame> linkedList = new LinkedList<UGCTransitionProcessor.TXCCombineFrame>();
        long l2 = 0L;
        for (int i2 = 0; i2 < frameList.size(); ++i2) {
            pixelFrame = frameList.get(i2);
            if (pixelFrame.getTimestamp() > l2) {
                l2 = pixelFrame.getTimestamp();
            }
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = new UGCTransitionProcessor.TXCCombineFrame();
            new UGCTransitionProcessor.TXCCombineFrame().drawRect = i2 < rectList.size() ? rectList.get(i2) : new TXVideoEditConstants.TXAbsoluteRect();
            tXCCombineFrame.drawInputFrame = this.preScale(pixelFrame, tXCCombineFrame.drawRect, i2);
            linkedList.add(tXCCombineFrame);
        }
        this.mUGCCombineProcessor.setCanvasSize(this.mOutputPixelWidth, this.mOutputPixelHeight);
        this.mUGCCombineProcessor.setCropRect(null);
        GLTexture gLTexture = this.mUGCCombineProcessor.combineFrame(linkedList);
        this.releaseFrameList(linkedList);
        if (gLTexture == null) {
            return null;
        }
        pixelFrame = gLTexture.wrap(frameList.get(0).getGLContext());
        gLTexture.release();
        pixelFrame.setTimestamp(l2);
        return pixelFrame;
    }

    private PixelFrame preScale(PixelFrame frameIn, TXVideoEditConstants.TXAbsoluteRect rect, int index) {
        if (this.mScaleRendererList.size() < index + 1) {
            this.mScaleRendererList.add(new PixelFrameRenderer(rect.width, rect.height));
            this.mScaleRectList.add(rect);
        }
        PixelFrameRenderer pixelFrameRenderer = this.mScaleRendererList.get(index);
        TXVideoEditConstants.TXAbsoluteRect tXAbsoluteRect = this.mScaleRectList.get(index);
        if (tXAbsoluteRect.width != rect.width || tXAbsoluteRect.height != rect.height) {
            pixelFrameRenderer.uninitialize();
            pixelFrameRenderer = new PixelFrameRenderer(rect.width, rect.height);
            this.mScaleRendererList.remove(index);
            this.mScaleRendererList.add(index, pixelFrameRenderer);
        }
        GLTexture gLTexture = this.mGLTexturePool.obtain(rect.width, rect.height);
        gLTexture.setColorFormat(frameIn.getColorRange(), frameIn.getColorSpace());
        pixelFrameRenderer.renderFrame(frameIn, GLConstants.GLScaleType.a, gLTexture);
        PixelFrame pixelFrame = gLTexture.wrap(frameIn.getGLContext());
        pixelFrame.setTimestamp(frameIn.getTimestamp());
        gLTexture.release();
        frameIn.release();
        return pixelFrame;
    }

    private void Retain(List<PixelFrame> frameList) {
        for (PixelFrame pixelFrame : frameList) {
            if (pixelFrame == null) continue;
            pixelFrame.retain();
        }
    }

    private void releaseFrameList(List<UGCTransitionProcessor.TXCCombineFrame> combineFrameList) {
        for (UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame : combineFrameList) {
            if (tXCCombineFrame.drawInputFrame == null) continue;
            tXCCombineFrame.drawInputFrame.release();
        }
    }
}

