/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.opengl.GLES20;
import android.util.Log;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCRotateScaleFilter;
import com.tencent.ugc.UGCTransitionProcessor;
import com.tencent.ugc.UGCWatermarkAlphaTextureFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLFrameBuffer;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.RefCounted;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.util.List;

public class UGCCombineFrameFilter {
    private static final String TAG = "UGCCombineFrameFilter";
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private final GLTexturePool mTexturePool;
    private UGCRotateScaleFilter mRotateScaleFilter = null;
    private TXCGPUImageFilter mCropFilter = null;
    private UGCWatermarkAlphaTextureFilter mAlphaBlendFilter;
    private Size mCanvasSize;
    private TXVideoEditConstants.TXAbsoluteRect mCropRect = null;
    private GLTexture mBackgroundTexture = null;
    private GLFrameBuffer mFrameBufferForClear;
    private FloatBuffer mCropRectTextureCoordsBuffer;

    public UGCCombineFrameFilter(GLTexturePool texturePool) {
        this.mTexturePool = texturePool;
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    }

    public void setCanvasSize(int width, int height) {
        if (this.mCanvasSize != null && width == this.mCanvasSize.width && height == this.mCanvasSize.height) {
            return;
        }
        this.mCanvasSize = new Size(width, height);
        this.mCropRectTextureCoordsBuffer = UGCCombineFrameFilter.getCropRectTextureCoords(this.mCanvasSize.width, this.mCanvasSize.height, this.mCropRect);
    }

    public void setCropRect(TXVideoEditConstants.TXAbsoluteRect cropRect) {
        if (this.mCropRect != null && cropRect != null && this.mCropRect.width == cropRect.width && this.mCropRect.height == cropRect.height && this.mCropRect.x == cropRect.x && this.mCropRect.y == cropRect.y) {
            return;
        }
        this.mCropRect = cropRect;
        this.mCropRectTextureCoordsBuffer = UGCCombineFrameFilter.getCropRectTextureCoords(this.mCanvasSize.width, this.mCanvasSize.height, this.mCropRect);
    }

    public GLTexture combineFrame(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        if (txCombineFrames == null || txCombineFrames.size() <= 0) {
            Log.e((String)TAG, (String)"frames is null or no frames!");
            return null;
        }
        this.initFilter();
        this.processRotateScale(txCombineFrames);
        GLTexture gLTexture = this.combineFrameWithAlphaBlendFilter(txCombineFrames);
        return this.cropTexture(gLTexture);
    }

    public void release() {
        this.unInitFilter();
    }

    private void processRotateScale(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        for (int i2 = 0; i2 < txCombineFrames.size(); ++i2) {
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = txCombineFrames.get(i2);
            if (this.mRotateScaleFilter == null || tXCCombineFrame.transformParams == null) {
                return;
            }
            this.mRotateScaleFilter.setRotateAndScale(tXCCombineFrame.transformParams.rotate, tXCCombineFrame.transformParams.scale);
            this.mRotateScaleFilter.setAlpha(tXCCombineFrame.transformParams.alpha);
            GLES20.glViewport((int)0, (int)0, (int)tXCCombineFrame.drawRect.width, (int)tXCCombineFrame.drawRect.height);
            GLTexture gLTexture = this.mTexturePool.obtain(tXCCombineFrame.drawRect.width, tXCCombineFrame.drawRect.height);
            gLTexture.setColorFormat(tXCCombineFrame.drawInputFrame.getColorRange(), tXCCombineFrame.drawInputFrame.getColorSpace());
            this.clearTexture(gLTexture);
            this.mRotateScaleFilter.onDraw(tXCCombineFrame.drawInputFrame.getTextureId(), gLTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            PixelFrame pixelFrame = tXCCombineFrame.drawInputFrame;
            tXCCombineFrame.drawInputFrame = gLTexture.wrap(pixelFrame.getGLContext());
            pixelFrame.release();
            gLTexture.release();
        }
    }

    private GLTexture combineFrameWithAlphaBlendFilter(List<UGCTransitionProcessor.TXCCombineFrame> txCombineFrames) {
        RefCounted refCounted = null;
        int n2 = this.getBackgroundTextureId();
        for (int i2 = 0; i2 < txCombineFrames.size(); ++i2) {
            UGCTransitionProcessor.TXCCombineFrame tXCCombineFrame = txCombineFrames.get(i2);
            this.setAlphaBlendFilterParameter(tXCCombineFrame);
            GLES20.glViewport((int)0, (int)0, (int)this.mCanvasSize.width, (int)this.mCanvasSize.height);
            Size size = this.mAlphaBlendFilter.getOutputSize();
            GLTexture gLTexture = this.mTexturePool.obtain(size.width, size.height);
            gLTexture.setColorFormat(tXCCombineFrame.drawInputFrame.getColorRange(), tXCCombineFrame.drawInputFrame.getColorSpace());
            this.mAlphaBlendFilter.onDraw(n2, gLTexture, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
            if (refCounted != null) {
                refCounted.release();
            }
            refCounted = gLTexture;
            n2 = gLTexture.getId();
        }
        return refCounted;
    }

    private GLTexture cropTexture(GLTexture glTexture) {
        if (glTexture == null || this.mCropFilter == null) {
            return glTexture;
        }
        Size size = this.mCropFilter.getOutputSize();
        GLTexture gLTexture = this.mTexturePool.obtain(size.width, size.height);
        gLTexture.setColorFormat(glTexture.getColorRange(), glTexture.getColorSpace());
        GLES20.glViewport((int)0, (int)0, (int)size.width, (int)size.height);
        this.mCropFilter.onDraw(glTexture.getId(), gLTexture, this.mNormalCubeVerticesBuffer, this.mCropRectTextureCoordsBuffer);
        glTexture.release();
        return gLTexture;
    }

    private void setAlphaBlendFilterParameter(UGCTransitionProcessor.TXCCombineFrame txcCombineFrame) {
        if (txcCombineFrame.transformParams != null) {
            this.mAlphaBlendFilter.setAlpha(txcCombineFrame.transformParams.alpha);
            this.mAlphaBlendFilter.setShowBackImageMoment(txcCombineFrame.transformParams.isBackgroundTransparent);
        } else {
            this.mAlphaBlendFilter.setAlpha(1.0f);
            this.mAlphaBlendFilter.setShowBackImageMoment(false);
        }
        int n2 = txcCombineFrame.drawInputFrame.getTextureId();
        int n3 = txcCombineFrame.drawRect.width;
        int n4 = txcCombineFrame.drawRect.height;
        float f2 = (float)txcCombineFrame.drawRect.x * 1.0f / (float)this.mCanvasSize.width;
        float f3 = (float)txcCombineFrame.drawRect.y * 1.0f / (float)this.mCanvasSize.height;
        float f4 = (float)txcCombineFrame.drawRect.width * 1.0f / (float)this.mCanvasSize.width;
        this.mAlphaBlendFilter.setTextureWatermark(n2, n3, n4, f2, f3, f4);
    }

    private void initFilter() {
        if (this.mRotateScaleFilter == null) {
            this.mRotateScaleFilter = new UGCRotateScaleFilter();
            this.mRotateScaleFilter.initialize(this.mTexturePool);
        }
        if (this.mAlphaBlendFilter == null) {
            this.mAlphaBlendFilter = new UGCWatermarkAlphaTextureFilter();
            this.mAlphaBlendFilter.initialize(this.mTexturePool);
        }
        this.mAlphaBlendFilter.enableWatermark(true);
        this.mAlphaBlendFilter.onOutputSizeChanged(this.mCanvasSize.width, this.mCanvasSize.height);
        if (this.mCropRect != null) {
            if (this.mCropFilter == null) {
                this.mCropFilter = new TXCGPUImageFilter();
                this.mCropFilter.initialize(this.mTexturePool);
            }
            this.mCropFilter.onOutputSizeChanged(this.mCropRect.width, this.mCropRect.height);
            return;
        }
        if (this.mCropFilter != null) {
            this.mCropFilter.uninitialize();
            this.mCropFilter = null;
        }
    }

    private void unInitFilter() {
        if (this.mRotateScaleFilter != null) {
            this.mRotateScaleFilter.uninitialize();
            this.mRotateScaleFilter = null;
        }
        if (this.mAlphaBlendFilter != null) {
            this.mAlphaBlendFilter.uninitialize();
            this.mAlphaBlendFilter = null;
        }
        if (this.mCropFilter != null) {
            this.mCropFilter.uninitialize();
            this.mCropFilter = null;
        }
        if (this.mBackgroundTexture != null) {
            this.mBackgroundTexture.release();
            this.mBackgroundTexture = null;
        }
        if (this.mFrameBufferForClear != null) {
            this.mFrameBufferForClear.uninitialize();
            this.mFrameBufferForClear = null;
        }
    }

    private void clearTexture(GLTexture glTexture) {
        if (this.mFrameBufferForClear == null) {
            this.mFrameBufferForClear = new GLFrameBuffer();
            this.mFrameBufferForClear.initialize();
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
        if (glTexture == null) {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glClear((int)16640);
            return;
        }
        this.mFrameBufferForClear.attachTexture(glTexture.getId());
        this.mFrameBufferForClear.bindToContext();
        GLES20.glClear((int)16640);
        this.mFrameBufferForClear.unbindFromContext();
        this.mFrameBufferForClear.detachTexture();
    }

    private int getBackgroundTextureId() {
        if (this.mBackgroundTexture == null) {
            this.mBackgroundTexture = this.mTexturePool.obtain(this.mCanvasSize.width, this.mCanvasSize.height);
            this.mBackgroundTexture.setColorFormat(GLConstants.ColorRange.b, GLConstants.ColorSpace.b);
            UGCCombineFrameFilter uGCCombineFrameFilter = this;
            uGCCombineFrameFilter.clearTexture(uGCCombineFrameFilter.mBackgroundTexture);
        }
        return this.mBackgroundTexture.getId();
    }

    private static FloatBuffer getCropRectTextureCoords(int width, int height, TXVideoEditConstants.TXAbsoluteRect cropRect) {
        float[] fArray = new float[GLConstants.e.length];
        OpenGlUtils.initTextureCoordsBuffer(fArray, l.a, false, false);
        if (cropRect != null) {
            float f2 = (float)cropRect.x / ((float)width * 1.0f);
            float f3 = (float)(width - cropRect.x - cropRect.width) / ((float)width * 1.0f);
            float f4 = (float)cropRect.y / ((float)height * 1.0f);
            float f5 = (float)(height - cropRect.y - cropRect.height) / ((float)height * 1.0f);
            for (int i2 = 0; i2 < fArray.length / 2; ++i2) {
                if (fArray[2 * i2] < 0.5f) {
                    int n2 = 2 * i2;
                    fArray[n2] = fArray[n2] + f2;
                } else {
                    int n3 = 2 * i2;
                    fArray[n3] = fArray[n3] - f3;
                }
                if (fArray[2 * i2 + 1] < 0.5f) {
                    int n4 = 2 * i2 + 1;
                    fArray[n4] = fArray[n4] + f4;
                    continue;
                }
                int n5 = 2 * i2 + 1;
                fArray[n5] = fArray[n5] - f5;
            }
        }
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(GLConstants.e.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(fArray).position(0);
        return floatBuffer;
    }
}

