/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import android.graphics.Bitmap;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.beauty.TXBeautyManager;
import com.tencent.liteav.beauty.TXBeautyManagerImpl;
import com.tencent.ugc.datereport.UGCDataReport;

public class UGCBeautyManager
implements TXBeautyManager {
    private static final String TAG = "UGCBeautyManager";
    private static final long MIN_REPORT_TIME_INTERVAL = 3000L;
    private long mLastBeautyStyleReportTs;
    private long mLastWhitenessLevelReportTs;
    private long mLastSetRuddyLevelReportTs;
    private long mLastSetFilterReportTs;
    private final TXBeautyManagerImpl mBeautyManagerImpl;
    private boolean mIsUseBeautyFunction = false;

    public UGCBeautyManager(long nativeBeautyManager) {
        this.mBeautyManagerImpl = new TXBeautyManagerImpl(nativeBeautyManager);
    }

    @Override
    public void setBeautyStyle(int beautyStyle) {
        this.mBeautyManagerImpl.setBeautyStyle(beautyStyle);
        if (this.mLastBeautyStyleReportTs <= 0L || System.currentTimeMillis() - this.mLastBeautyStyleReportTs >= 3000L) {
            UGCDataReport.reportDAU(1057, beautyStyle, null);
            this.mLastBeautyStyleReportTs = System.currentTimeMillis();
        }
    }

    @Override
    public void setBeautyLevel(float beautyLevel) {
        this.mIsUseBeautyFunction |= beautyLevel > 0.0f;
        this.mBeautyManagerImpl.setBeautyLevel(beautyLevel);
    }

    @Override
    public void setWhitenessLevel(float whitenessLevel) {
        this.mIsUseBeautyFunction |= whitenessLevel > 0.0f;
        this.mBeautyManagerImpl.setWhitenessLevel(whitenessLevel);
        if (this.mLastWhitenessLevelReportTs <= 0L || System.currentTimeMillis() - this.mLastWhitenessLevelReportTs >= 3000L) {
            UGCDataReport.reportDAU(1058);
            this.mLastWhitenessLevelReportTs = System.currentTimeMillis();
        }
    }

    @Override
    public void enableSharpnessEnhancement(boolean enable) {
        this.mIsUseBeautyFunction |= enable;
        this.mBeautyManagerImpl.enableSharpnessEnhancement(enable);
    }

    @Override
    public void setRuddyLevel(float ruddyLevel) {
        this.mIsUseBeautyFunction |= ruddyLevel > 0.0f;
        this.mBeautyManagerImpl.setRuddyLevel(ruddyLevel);
        if (this.mLastSetRuddyLevelReportTs <= 0L || System.currentTimeMillis() - this.mLastSetRuddyLevelReportTs >= 3000L) {
            UGCDataReport.reportDAU(1059);
            this.mLastSetRuddyLevelReportTs = System.currentTimeMillis();
        }
    }

    @Override
    public void setFilter(Bitmap image) {
        this.mIsUseBeautyFunction |= image != null;
        this.mBeautyManagerImpl.setFilter(image);
        if (this.mLastSetFilterReportTs <= 0L || System.currentTimeMillis() - this.mLastSetFilterReportTs >= 3000L) {
            UGCDataReport.reportDAU(1060);
            this.mLastSetFilterReportTs = System.currentTimeMillis();
        }
    }

    @Override
    public void setFilterStrength(float strength) {
        this.mBeautyManagerImpl.setFilterStrength(strength);
    }

    @Override
    public int setGreenScreenFile(String path) {
        LiteavLog.e(TAG, "do not support setGreenScreenFile interface.");
        return 0;
    }

    @Override
    public int setEyeScaleLevel(float eyeScaleLevel) {
        LiteavLog.e(TAG, "do not support setEyeScaleLevel interface.");
        return 0;
    }

    @Override
    public int setFaceSlimLevel(float faceSlimLevel) {
        LiteavLog.e(TAG, "do not support setFaceSlimLevel interface.");
        return 0;
    }

    @Override
    public int setFaceVLevel(float faceVLevel) {
        LiteavLog.e(TAG, "do not support setFaceVLevel interface.");
        return 0;
    }

    @Override
    public int setChinLevel(float chinLevel) {
        LiteavLog.e(TAG, "do not support setChinLevel interface.");
        return 0;
    }

    @Override
    public int setFaceShortLevel(float faceShortLevel) {
        LiteavLog.e(TAG, "do not support setFaceShortLevel interface.");
        return 0;
    }

    @Override
    public int setFaceNarrowLevel(float faceNarrowLevel) {
        LiteavLog.e(TAG, "do not support setFaceNarrowLevel interface.");
        return 0;
    }

    @Override
    public int setNoseSlimLevel(float noseSlimLevel) {
        LiteavLog.e(TAG, "do not support setNoseSlimLevel interface.");
        return 0;
    }

    @Override
    public int setEyeLightenLevel(float eyeLightenLevel) {
        LiteavLog.e(TAG, "do not support setEyeLightenLevel interface.");
        return 0;
    }

    @Override
    public int setToothWhitenLevel(float toothWhitenLevel) {
        LiteavLog.e(TAG, "do not support setToothWhitenLevel interface.");
        return 0;
    }

    @Override
    public int setWrinkleRemoveLevel(float wrinkleRemoveLevel) {
        LiteavLog.e(TAG, "do not support setWrinkleRemoveLevel interface.");
        return 0;
    }

    @Override
    public int setPounchRemoveLevel(float pounchRemoveLevel) {
        LiteavLog.e(TAG, "do not support setPounchRemoveLevel interface.");
        return 0;
    }

    @Override
    public int setSmileLinesRemoveLevel(float smileLinesRemoveLevel) {
        LiteavLog.e(TAG, "do not support setSmileLinesRemoveLevel interface.");
        return 0;
    }

    @Override
    public int setForeheadLevel(float foreheadLevel) {
        LiteavLog.e(TAG, "do not support setEyeDistanceLevel interface.");
        return 0;
    }

    @Override
    public int setEyeDistanceLevel(float eyeDistanceLevel) {
        LiteavLog.e(TAG, "do not support setEyeDistanceLevel interface.");
        return 0;
    }

    @Override
    public int setEyeAngleLevel(float eyeAngleLevel) {
        LiteavLog.e(TAG, "do not support setEyeAngleLevel interface.");
        return 0;
    }

    @Override
    public int setMouthShapeLevel(float mouthShapeLevel) {
        LiteavLog.e(TAG, "do not support setMouthShapeLevel interface.");
        return 0;
    }

    @Override
    public int setNoseWingLevel(float noseWingLevel) {
        LiteavLog.e(TAG, "do not support setNoseWingLevel interface.");
        return 0;
    }

    @Override
    public int setNosePositionLevel(float nosePositionLevel) {
        LiteavLog.e(TAG, "do not support setNosePositionLevel interface.");
        return 0;
    }

    @Override
    public int setLipsThicknessLevel(float lipsThicknessLevel) {
        LiteavLog.e(TAG, "do not support setLipsThicknessLevel interface.");
        return 0;
    }

    @Override
    public int setFaceBeautyLevel(float faceBeautyLevel) {
        LiteavLog.e(TAG, "do not support setFaceBeautyLevel interface.");
        return 0;
    }

    @Override
    public void setMotionTmpl(String tmplPath) {
        LiteavLog.e(TAG, "do not support setMotionTmpl interface.");
    }

    @Override
    public void setMotionMute(boolean motionMute) {
        LiteavLog.e(TAG, "do not support setMotionMute interface.");
    }

    public boolean getIsUseBeautyFunction() {
        return this.mIsUseBeautyFunction;
    }
}

