/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.Log;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.ugc.AudioEncodeParams;
import com.tencent.ugc.AudioFrame;
import com.tencent.ugc.TXVideoEditConstants;
import com.tencent.ugc.UGCAVSyncer;
import com.tencent.ugc.UGCMediaListSource;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class UGCAudioProcessor {
    private static final String TAG = "UGCAudioProcessor";
    private long mNativeProcessor = 0L;
    private AudioProgressListener mProgressListener = null;
    private AudioEncodedFrameListener mEncodeListener = null;
    private UGCMediaListSource mVideoSource = null;
    private UGCMediaListSource mBGMSource = null;
    private UGCAVSyncer mAVSyncer = null;
    private final Object mBGMLock = new Object();

    public UGCAudioProcessor(UGCAVSyncer avSyncer, UGCMediaListSource source) {
        this.mVideoSource = source;
        this.mAVSyncer = avSyncer;
        this.mNativeProcessor = UGCAudioProcessor.nativeCreateProcessor(this);
    }

    public void setMediaListSource(UGCMediaListSource source) {
        this.mVideoSource = source;
    }

    public void initialize() {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeInitialize(this.mNativeProcessor);
        }
    }

    public void unInitialize() {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeUnInitialize(this.mNativeProcessor);
        }
    }

    public void start(boolean isRecord) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeStart(this.mNativeProcessor, isRecord);
        }
    }

    public void stop() {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeStop(this.mNativeProcessor);
        }
    }

    public void setProgressListener(AudioProgressListener listener) {
        this.mProgressListener = listener;
    }

    public void setAudioEncodedFrameListener(AudioEncodedFrameListener listener) {
        this.mEncodeListener = listener;
    }

    public void setFadeInOutDuration(long fadeInDuration, long fadeOutDuration) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetFadeInOutDuration(this.mNativeProcessor, fadeInDuration, fadeOutDuration);
        }
    }

    public void setSpeedList(List<TXVideoEditConstants.TXSpeed> speedList) {
        if (this.mNativeProcessor == 0L) {
            return;
        }
        int[] nArray = null;
        long[] lArray = null;
        long[] lArray2 = null;
        if (speedList != null && !speedList.isEmpty()) {
            nArray = new int[speedList.size()];
            lArray = new long[speedList.size()];
            lArray2 = new long[speedList.size()];
            for (int i2 = 0; i2 < speedList.size(); ++i2) {
                TXVideoEditConstants.TXSpeed tXSpeed = speedList.get(i2);
                nArray[i2] = tXSpeed.speedLevel;
                lArray[i2] = tXSpeed.startTime;
                lArray2[i2] = tXSpeed.endTime;
            }
        }
        UGCAudioProcessor.nativeSetSpeedList(this.mNativeProcessor, nArray, lArray, lArray2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBGM(String path) {
        long l2;
        if (this.mNativeProcessor == 0L) {
            return;
        }
        if (path == null) {
            this.destroyBGMSource();
            UGCAudioProcessor.nativeEnableBGM(this.mNativeProcessor, false);
            return;
        }
        Object object = this.mBGMLock;
        synchronized (object) {
            this.destroyBGMSource();
            this.mBGMSource = new UGCMediaListSource();
            this.mBGMSource.initialize();
            this.mBGMSource.setVideoSources(Collections.singletonList(path));
            l2 = this.mBGMSource.getDuration();
        }
        UGCAudioProcessor.nativeEnableBGM(this.mNativeProcessor, true);
        if (l2 > 0L) {
            this.setBGMStartTime(0L, l2);
        }
    }

    public void setBGMLoop(boolean looping) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetBGMLoop(this.mNativeProcessor, looping);
        }
    }

    public void setBGMAtVideoTime(long videoStartTime) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetBGMAtVideoTime(this.mNativeProcessor, videoStartTime);
        }
    }

    public void setBGMStartTime(long startTime, long endTime) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetBGMStartTime(this.mNativeProcessor, startTime, endTime);
        }
    }

    public void setBGMVolume(float volume) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetBGMVolume(this.mNativeProcessor, volume);
        }
    }

    public void setVideoVolume(float volume) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetVideoVolume(this.mNativeProcessor, volume);
        }
    }

    public void setVideoVolumes(float[] volumes) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetVideoVolumes(this.mNativeProcessor, volumes);
        }
    }

    public void setEncodeParams(AudioEncodeParams encodeParam) {
        if (this.mNativeProcessor != 0L) {
            UGCAudioProcessor.nativeSetEncodeParams(this.mNativeProcessor, encodeParam.getSampleRate(), encodeParam.getChannels(), encodeParam.getBitsPerChannel(), encodeParam.getBitrate());
        }
    }

    public void destroy() {
        if (this.mNativeProcessor == 0L) {
            return;
        }
        this.destroyBGMSource();
        UGCAudioProcessor.nativeDestroyProcessor(this.mNativeProcessor);
        this.mNativeProcessor = 0L;
    }

    public AudioFrame[] requestAudioDataFromNative() {
        return this.readNextAudioFrame(false);
    }

    public AudioFrame[] requestBGMDataFromNative() {
        return this.readNextAudioFrame(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean requestBGMSeekFromNative(long postion) {
        Object object = this.mBGMLock;
        synchronized (object) {
            if (this.mBGMSource == null || !this.mBGMSource.hasAudioData() || this.mBGMSource.getDuration() < postion) {
                return false;
            }
            this.mBGMSource.seekTo(postion);
        }
        return true;
    }

    public void notifyEncodingStartedFromNative() {
        if (this.mEncodeListener != null) {
            this.mEncodeListener.onAudioEncodingStarted();
        }
    }

    public void notifyEncodedDataFromNative(AudioFrame frame) {
        if (this.mEncodeListener != null) {
            this.mEncodeListener.onAudioFrameEncoded(frame);
        }
    }

    public void notifyEncodingCompletedFromNative() {
        if (this.mEncodeListener != null) {
            this.mEncodeListener.onAudioEncodingCompleted();
        }
        if (this.mAVSyncer != null) {
            this.mAVSyncer.setAudioEos();
        }
    }

    public void notifyProgressFromNative(long progress) {
        if (this.mProgressListener != null) {
            this.mProgressListener.onProgress(progress);
        }
    }

    public void notifyPlayoutCompletedFromNative(boolean hasError) {
        if (this.mProgressListener != null) {
            this.mProgressListener.onComplete(hasError);
        }
        if (this.mAVSyncer != null) {
            this.mAVSyncer.setAudioEos();
        }
    }

    public int syncAudioFromNative(long timestamp) {
        if (this.mAVSyncer != null) {
            return this.mAVSyncer.syncAudio(timestamp).getNativeValue();
        }
        return UGCAVSyncer.SkipMode.NOOP.getNativeValue();
    }

    public AudioFrame createAudioFrameFromNative(int sampleRate, int channels, long timestamp, int codec_format, int dataSize) {
        AudioFrame audioFrame = new AudioFrame();
        audioFrame.setSampleRate(sampleRate);
        audioFrame.setChannelCount(channels);
        ByteBuffer byteBuffer = ByteBuffer.allocateDirect(dataSize);
        audioFrame.setData(byteBuffer);
        audioFrame.setTimestamp(timestamp);
        AudioFrame.AudioCodecFormat audioCodecFormat = codec_format == AudioFrame.AudioCodecFormat.AAC.getValue() ? AudioFrame.AudioCodecFormat.AAC : AudioFrame.AudioCodecFormat.PCM;
        audioFrame.setCodecFormat(audioCodecFormat);
        return audioFrame;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AudioFrame[] readNextAudioFrame(boolean isBGM) {
        Object object = this.mBGMLock;
        synchronized (object) {
            UGCMediaListSource uGCMediaListSource = isBGM ? this.mBGMSource : this.mVideoSource;
            if (uGCMediaListSource == null) {
                Log.w(TAG, "readNextAudioFrame failed for " + (isBGM ? "BGM" : "video"), new Object[0]);
                return null;
            }
            List<AudioFrame> list = uGCMediaListSource.readNextAudioFrame();
            if (list == null || list.isEmpty()) {
                Log.i(TAG, "readNextAudioFrame eos for " + (isBGM ? "BGM" : "video"), new Object[0]);
                return null;
            }
            return list.toArray(new AudioFrame[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyBGMSource() {
        Object object = this.mBGMLock;
        synchronized (object) {
            if (this.mBGMSource != null) {
                this.mBGMSource.uninitialize();
                this.mBGMSource = null;
            }
            return;
        }
    }

    private static native long nativeCreateProcessor(UGCAudioProcessor var0);

    private static native void nativeDestroyProcessor(long var0);

    private static native void nativeInitialize(long var0);

    private static native void nativeUnInitialize(long var0);

    private static native void nativeStart(long var0, boolean var2);

    private static native void nativeStop(long var0);

    private static native void nativeSetFadeInOutDuration(long var0, long var2, long var4);

    private static native void nativeSetSpeedList(long var0, int[] var2, long[] var3, long[] var4);

    private static native void nativeEnableBGM(long var0, boolean var2);

    private static native void nativeSetBGMLoop(long var0, boolean var2);

    private static native void nativeSetBGMAtVideoTime(long var0, long var2);

    private static native void nativeSetBGMStartTime(long var0, long var2, long var4);

    private static native void nativeSetBGMVolume(long var0, float var2);

    private static native void nativeSetVideoVolume(long var0, float var2);

    private static native void nativeSetVideoVolumes(long var0, float[] var2);

    private static native void nativeSetEncodeParams(long var0, int var2, int var3, int var4, int var5);

    public static interface AudioProgressListener {
        public void onProgress(long var1);

        public void onComplete(boolean var1);
    }

    public static interface AudioEncodedFrameListener {
        public void onAudioEncodingStarted();

        public void onAudioFrameEncoded(AudioFrame var1);

        public void onAudioEncodingCompleted();
    }
}

