/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc;

import com.tencent.liteav.base.ThreadUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.ugc.PartInfo;
import com.tencent.ugc.RemuxJoiner;
import com.tencent.ugc.TXUGCPartsManager;
import com.tencent.ugc.c;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@JNINamespace(value="liteav::ugc")
public class TXUGCPartsManagerImpl
implements TXUGCPartsManager {
    private long mNativePartsManager = 0L;

    public TXUGCPartsManagerImpl(long nativePartsManager) {
        this.mNativePartsManager = nativePartsManager;
    }

    @Override
    public void addClipInfo(PartInfo partInfo) {
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeAddPart(this.mNativePartsManager, partInfo.getPath(), partInfo.getDuration());
        }
    }

    @Override
    public void insertPart(String videoPath, int index) {
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeInsertPart(this.mNativePartsManager, videoPath, index);
        }
    }

    @Override
    public int getDuration() {
        if (this.mNativePartsManager != 0L) {
            return TXUGCPartsManagerImpl.nativeGetDuration(this.mNativePartsManager);
        }
        return 0;
    }

    @Override
    public List<String> getPartsPathList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.mNativePartsManager == 0L) {
            return arrayList;
        }
        String[] stringArray = TXUGCPartsManagerImpl.nativeGetPartsPathList(this.mNativePartsManager);
        if (stringArray != null && stringArray.length != 0) {
            arrayList.addAll(Arrays.asList(stringArray));
        }
        return arrayList;
    }

    @Override
    public void deleteLastPart() {
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeDeleteLastPart(this.mNativePartsManager);
        }
    }

    @Override
    public void deletePart(int index) {
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeDeletePart(this.mNativePartsManager, index);
        }
    }

    @Override
    public void deleteAllParts() {
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeDeleteAllParts(this.mNativePartsManager);
        }
    }

    @Override
    public boolean joinAllParts(String videoOutputPath, final TXUGCPartsManager.JoinAllPartsListener joinAllPartsListener) {
        RemuxJoiner remuxJoiner = new RemuxJoiner();
        remuxJoiner.initialize();
        remuxJoiner.setVideoJoinerListener(new RemuxJoiner.RemuxJoinerListener(){

            @Override
            public final void onRemuxJoinerProgress(float progress) {
            }

            @Override
            public final void onRemuxJoinerComplete(int resultCode, String msg) {
                ThreadUtils.getUiThreadHandler().post(c.a(joinAllPartsListener, resultCode));
            }

            static /* synthetic */ void a(TXUGCPartsManager.JoinAllPartsListener joinAllPartsListener2, int n2) {
                if (joinAllPartsListener2 != null) {
                    joinAllPartsListener2.onJoinAllParts(n2);
                }
            }
        });
        return remuxJoiner.setSourcePaths(this.getPartsPathList()) && remuxJoiner.setTargetPath(videoOutputPath) && remuxJoiner.start();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mNativePartsManager != 0L) {
            TXUGCPartsManagerImpl.nativeDestroy(this.mNativePartsManager);
            this.mNativePartsManager = 0L;
        }
    }

    private static native void nativeDestroy(long var0);

    private static native void nativeInsertPart(long var0, String var2, int var3);

    private static native void nativeAddPart(long var0, String var2, long var3);

    private static native void nativeDeletePart(long var0, int var2);

    private static native void nativeDeleteLastPart(long var0);

    private static native void nativeDeleteAllParts(long var0);

    private static native int nativeGetDuration(long var0);

    private static native String[] nativeGetPartsPathList(long var0);
}

