/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.trtc.hardwareearmonitor.honor;

import android.content.Context;
import android.media.AudioManager;
import com.tencent.liteav.base.ContextUtils;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.m;
import com.tencent.trtc.hardwareearmonitor.honor.HonorAudioClient;
import com.tencent.trtc.hardwareearmonitor.honor.HonorEarReturnClient;
import com.tencent.trtc.hardwareearmonitor.honor.IHonorAudioServiceCallback;
import java.util.List;

@JNINamespace(value="liteav::extensions")
public class HardwareEarMonitorHonor
implements IHonorAudioServiceCallback {
    private static final String TAG = "HardwareEarMonitorHonor";
    private long mNativeHardwareEarMonitorHandle = 0L;
    private Context mContext;
    private Object mLock = new Object();
    private HonorAudioClient mHnAudioClient;
    private HonorEarReturnClient mHnEarReturnClient;
    private AudioManager mAudioManager;
    private m mTaskRunner;

    public static HardwareEarMonitorHonor create(long nativeHardwareEarMonitorHandle) {
        return new HardwareEarMonitorHonor(nativeHardwareEarMonitorHandle);
    }

    public static boolean isAudioKitSupport() {
        return HonorAudioClient.isDeviceSupported(ContextUtils.getApplicationContext());
    }

    public boolean isKaraokeServiceSupport() {
        return this.mHnAudioClient.isServiceSupported(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN);
    }

    public int[] getKaraokeSupportedServices() {
        List<Integer> list = this.mHnAudioClient.getSupportedServices();
        if (list == null) {
            return null;
        }
        int[] nArray = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            nArray[i2] = list.get(i2);
        }
        return nArray;
    }

    public void createKaraokeService() {
        this.mHnEarReturnClient = (HonorEarReturnClient)this.mHnAudioClient.createService(HonorAudioClient.ServiceType.HNAUDIO_SERVICE_EARRETURN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.mLock;
        synchronized (object) {
            this.mNativeHardwareEarMonitorHandle = 0L;
        }
        if (this.mHnAudioClient != null) {
            this.mHnAudioClient.destroy();
            this.mHnAudioClient = null;
        }
        if (this.mHnEarReturnClient != null) {
            this.mHnEarReturnClient.destroy();
            this.mHnEarReturnClient = null;
        }
    }

    public int enableKaraoke(boolean enable) {
        if (this.mHnEarReturnClient == null) {
            return 1806;
        }
        return this.mHnEarReturnClient.enableEarReturn(enable);
    }

    public boolean setAudioParams(String params) {
        try {
            this.mAudioManager.setParameters(params);
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public int setReverberation(int value) {
        if (this.mHnEarReturnClient == null) {
            return 1806;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_AUDIO_EFFECT_MODE_BASE, value);
    }

    public int setEqualizer(int value) {
        if (this.mHnEarReturnClient == null) {
            return 1806;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_VOCAL_EQUALIZER_MODE, value);
    }

    public int setVolume(int value) {
        if (this.mHnEarReturnClient == null) {
            return 1806;
        }
        return this.mHnEarReturnClient.setParameter(HonorEarReturnClient.ParameName.CMD_SET_VOCAL_VOLUME_BASE, value);
    }

    public boolean isHardwareEarMonitorSupported() {
        if (this.mHnEarReturnClient == null) {
            return false;
        }
        return this.mHnEarReturnClient.isServiceSupported();
    }

    public int getKaraokeLatency() {
        int n2;
        if (this.mHnEarReturnClient == null) {
            return -1;
        }
        try {
            n2 = this.mHnEarReturnClient.getEarReturnLatency();
        }
        catch (Throwable throwable) {
            n2 = -1;
        }
        return n2;
    }

    @Override
    public void onResult(final int resultCode) {
        this.mTaskRunner.a(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public final void run() {
                Object object = HardwareEarMonitorHonor.this.mLock;
                synchronized (object) {
                    HardwareEarMonitorHonor.nativeHandleResult(HardwareEarMonitorHonor.this.mNativeHardwareEarMonitorHandle, resultCode);
                    return;
                }
            }
        });
    }

    public HardwareEarMonitorHonor(long nativeSystemAudioKit) {
        this.mNativeHardwareEarMonitorHandle = nativeSystemAudioKit;
        this.mAudioManager = (AudioManager)ContextUtils.getApplicationContext().getSystemService("audio");
        this.mContext = ContextUtils.getApplicationContext();
        this.mTaskRunner = new m();
        this.mHnAudioClient = new HonorAudioClient(this.mContext, this);
        this.mHnAudioClient.initialize();
    }

    private static native void nativeHandleResult(long var0, int var2);
}

