/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.utils;

import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class TPThreadPoolExecutor {
    private static final String TAG = "TPCore[TPThreadPoolExecutor]";
    private static final String THREAD_POOL_NAME = "TP-Thread";
    private static final long THREAD_KEEP_ALIVE_TIME = 60L;
    private static final int QUEUE_CAPACITY = 20;

    public static ExecutorService newCustomThreadExecutor(int n2, int n3) {
        return new ThreadPoolExecutor(n2, n3, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(20), new CustomThreadFactory(), new CustomRejectedExecutionHandler());
    }

    static class CustomRejectedExecutionHandler
    implements RejectedExecutionHandler {
        private CustomRejectedExecutionHandler() {
        }

        @Override
        public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
            try {
                threadPoolExecutor.getQueue().put(runnable);
                TPNativeLog.printLog(2, TPThreadPoolExecutor.TAG, "rejectedExecution put task to queue");
                return;
            }
            catch (InterruptedException interruptedException) {
                TPNativeLog.printLog(4, TPThreadPoolExecutor.TAG, "rejectedExecution has exception:" + interruptedException.toString());
                return;
            }
        }
    }

    static class CustomThreadFactory
    implements ThreadFactory {
        private AtomicInteger threadAtomicCount = new AtomicInteger(0);

        private CustomThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName(TPThreadPoolExecutor.THREAD_POOL_NAME + this.threadAtomicCount.incrementAndGet());
            return thread;
        }
    }
}

