/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.drm;

import android.media.MediaDrmException;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.drm.ITPMediaDrm;
import com.tencent.thumbplayer.tcmedia.core.drm.TPDirectMediaDrm;
import com.tencent.thumbplayer.tcmedia.core.drm.TPMediaDrmFatalException;
import com.tencent.thumbplayer.tcmedia.core.drm.reuse.TPReuseMediaDrm;
import java.util.UUID;

public final class TPMediaDrmPool {
    private static final String TAG = "TPMediaDrmManager";
    private static final TPMediaDrmPool sInstance = new TPMediaDrmPool();
    private boolean mIsMediaDrmReuse = false;

    private TPMediaDrmPool() {
    }

    public static TPMediaDrmPool getInstance() {
        return sInstance;
    }

    public final void preload() {
        TPReuseMediaDrm.preloadAsync();
    }

    public final void setMediaDrmReuseEnable(boolean bl2) {
        this.mIsMediaDrmReuse = bl2;
        if (bl2) {
            this.preload();
        }
    }

    public final ITPMediaDrm createTPMediaDrm(UUID uUID) {
        if (this.mIsMediaDrmReuse) {
            try {
                return new TPReuseMediaDrm(uUID);
            }
            catch (MediaDrmException | TPMediaDrmFatalException throwable) {
                TPNativeLog.printLog(4, TAG, "reset error:".concat(String.valueOf(throwable)));
            }
        }
        return new TPDirectMediaDrm(uUID);
    }

    public final ITPMediaDrm createTPDirectMediaDrm(UUID uUID) {
        return new TPDirectMediaDrm(uUID);
    }
}

