/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.content.Context;
import com.tencent.thumbplayer.tcmedia.core.common.TPCodecCapability;
import com.tencent.thumbplayer.tcmedia.core.common.TPCodecUtils;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLibraryException;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLibraryLoader;
import com.tencent.thumbplayer.tcmedia.core.common.TPNativeLog;
import com.tencent.thumbplayer.tcmedia.core.common.TPSystemInfo;
import java.util.HashMap;

public class TPPlayerDecoderCapability {
    private long mNativeContext = 0L;
    private static String TAG = "TPPlayerDecoderCapability";
    private static boolean mIsLibLoaded;

    private static boolean isLibLoaded() {
        return mIsLibLoaded;
    }

    public static synchronized void init(Context context, boolean bl2) {
        TPCodecUtils.init(context, bl2);
    }

    private static native boolean _isVCodecCapabilitySupport(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native boolean _addVCodecBlacklist(int var0, int var1, TPCodecCapability.TPVCodecPropertyRange var2);

    private static native boolean _addVCodecWhitelist(int var0, int var1, TPCodecCapability.TPVCodecPropertyRange var2);

    private static native boolean _isACodecCapabilitySupport(int var0, int var1, int var2, int var3, int var4, int var5, int var6);

    private static native boolean _addACodecBlacklist(int var0, int var1, TPCodecCapability.TPACodecPropertyRange var2);

    private static native boolean _addACodecWhitelist(int var0, int var1, TPCodecCapability.TPACodecPropertyRange var2);

    private static native HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> _getDecoderMaxCapabilityMap(int var0);

    public static HashMap<Integer, TPCodecCapability.TPCodecMaxCapability> getVCodecDecoderMaxCapabilityMap(int n2) {
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._getDecoderMaxCapabilityMap(n2);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _getDecoderMaxCapabilityMap.");
        }
    }

    public static boolean addVCodecBlacklist(int n2, int n3, TPCodecCapability.TPVCodecPropertyRange tPVCodecPropertyRange) {
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("addVCodecBlacklist: Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._addVCodecBlacklist(n2, n3, tPVCodecPropertyRange);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _addVCodecBlacklist.");
        }
    }

    public static boolean addVCodecWhitelist(int n2, int n3, TPCodecCapability.TPVCodecPropertyRange tPVCodecPropertyRange) {
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("addVCodecWhitelist :Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._addVCodecWhitelist(n2, n3, tPVCodecPropertyRange);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _addVCodecWhitelist.");
        }
    }

    public static boolean addACodecBlacklist(int n2, int n3, TPCodecCapability.TPACodecPropertyRange tPACodecPropertyRange) {
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("addACodecBlacklist: Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._addACodecBlacklist(n2, n3, tPACodecPropertyRange);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _addACodecBlacklist.");
        }
    }

    public static boolean addACodecWhitelist(int n2, int n3, TPCodecCapability.TPACodecPropertyRange tPACodecPropertyRange) {
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("addACodecWhitelist: Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._addACodecWhitelist(n2, n3, tPACodecPropertyRange);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _addVCodecWhitelist.");
        }
    }

    public static boolean isVCodecCapabilitySupport(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (102 == n2) {
            String string = "";
            switch (n3) {
                case 26: {
                    string = "video/avc";
                    break;
                }
                case 172: {
                    string = "video/hevc";
                    break;
                }
                case 1029: {
                    string = "video/av01";
                    break;
                }
                case 138: {
                    string = "video/x-vnd.on2.vp8";
                    break;
                }
                case 166: {
                    string = "video/x-vnd.on2.vp9";
                }
            }
            if (TPCodecUtils.isInMediaCodecWhiteList(string)) {
                return true;
            }
            if (TPCodecUtils.isVMediaCodecBlackListModel() || TPCodecUtils.isBlackListType(string)) {
                return false;
            }
        }
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._isVCodecCapabilitySupport(n2, n3, n4, n5, n6, n7, n8);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _isVCodecCapabilitySupport.");
        }
    }

    public static boolean isDolbyDSSupported() {
        return TPCodecUtils.isMediaCodecDolbyDSSupported();
    }

    public static boolean isDDPlusSupported() {
        return TPCodecUtils.isMediaCodecDDPlusSupported();
    }

    public static boolean isHDRsupport(int n2, int n3, int n4) {
        return TPCodecUtils.isHDRsupport(n2, n3, n4);
    }

    public static boolean isACodecCapabilitySupport(int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        if (2 == n2) {
            String string = "";
            switch (n3) {
                case 5002: {
                    string = "audio/aac";
                    break;
                }
                case 5012: {
                    string = "audio/flac";
                    break;
                }
                case 5003: {
                    string = "audio/ac3";
                    break;
                }
                case 5040: {
                    string = "audio/eac3";
                    break;
                }
                case 5004: {
                    string = "audio/dts";
                }
            }
            if (TPCodecUtils.isInMediaCodecWhiteList(string)) {
                return true;
            }
            if (TPCodecUtils.isAMediaCodecBlackListModel() || TPCodecUtils.isBlackListType(string)) {
                return false;
            }
        }
        if (!TPPlayerDecoderCapability.isLibLoaded()) {
            throw new TPNativeLibraryException("Failed to load native library.");
        }
        try {
            return TPPlayerDecoderCapability._isACodecCapabilitySupport(n2, n3, n4, n5, n6, n7, n8);
        }
        catch (Throwable throwable) {
            TPNativeLog.printLog(4, throwable.getMessage());
            throw new TPNativeLibraryException("Failed to call _isACodecCapabilitySupport.");
        }
    }

    public static boolean addDRMLevel1Blacklist(int n2) {
        return TPCodecUtils.addDRMLevel1Blacklist(n2);
    }

    public static boolean addHDRWhiteList(int n2, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        return TPCodecUtils.addHDRWhiteList(n2, TPSystemInfo.getDeviceName(), tPHdrSupportVersionRange);
    }

    public static boolean addHDRBlackList(int n2, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        return TPCodecUtils.addHDRBlackList(n2, TPSystemInfo.getDeviceName(), tPHdrSupportVersionRange);
    }

    public static boolean addHDRVideoDecoderTypeWhiteList(int n2, int n3, TPCodecCapability.TPHdrSupportVersionRange tPHdrSupportVersionRange) {
        return TPCodecUtils.addHDRVideoDecoderTypeWhiteList(n2, n3, tPHdrSupportVersionRange);
    }

    public static void setMediaCodecPreferredSoftwareComponent(boolean bl2) {
        TPCodecUtils.setMediaCodecPreferredSoftwareComponent(bl2);
    }

    static {
        try {
            TPNativeLibraryLoader.loadLibIfNeeded(null);
            mIsLibLoaded = true;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            TPNativeLog.printLog(4, unsupportedOperationException.getMessage());
            mIsLibLoaded = false;
        }
    }
}

