/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.thumbplayer.tcmedia.core.common;

import android.media.MediaCodecInfo;
import android.os.Build;
import android.util.Range;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;

public final class TPMediaDecoderInfo
implements Serializable {
    private static final String TAG = "TPCodecUtils";
    private static final int DEFAULT_MAX_WIDTH = 1280;
    private static final int DEFAULT_MAX_HEIGHT = 720;
    private static final int DEFAULT_MAX_SAMPLERATE = 48000;
    private static final int DEFAULT_MIN_BITRATE = 8000;
    private static final int DEFAULT_MAX_BITRATE = 960000;
    private static final int DEFAULT_MAX_CHANNELNUM = 2;
    private String decName;
    private String decMimeType;
    private boolean adaptiveDec;
    private boolean tunnelingDec;
    private boolean secureDec;
    private boolean softwareVideoDec;
    private boolean softwareAudioDec;
    private int maxWidth;
    private int maxHeight;
    private int maxLumaWidth;
    private int maxLumaHeight;
    private int maxLumaFrameRate;
    private int maxFrameRate;
    private DecoderProfileLevel[] profileLevels;
    private int[] colorFormats;
    private int maxSampleRate;
    private int maxBitRate;
    private int maxChannels;
    private int maxSupportedInstances;
    private static final ArrayList<String> mVideoSoftwareDecoderWhiteList = new ArrayList<String>();
    private static final ArrayList<String> mAudioDecoderWhiteList;

    public TPMediaDecoderInfo(String string, String string2, MediaCodecInfo.CodecCapabilities codecCapabilities) {
        MediaCodecInfo.VideoCapabilities videoCapabilities;
        this.reset();
        this.decName = string2;
        this.decMimeType = string;
        this.softwareVideoDec = this.isVideo() && this.isVideoSoftwareOnly(string2);
        this.softwareAudioDec = this.isAudio() && this.isAudioSoftwareOnly(string2);
        this.adaptiveDec = codecCapabilities != null && this.isAdaptive(codecCapabilities);
        this.tunnelingDec = codecCapabilities != null && this.isTunneling(codecCapabilities);
        boolean bl2 = this.secureDec = codecCapabilities != null && this.isSecure(codecCapabilities);
        if (codecCapabilities != null && codecCapabilities.profileLevels != null && codecCapabilities.profileLevels.length > 0) {
            videoCapabilities = new ArrayList();
            MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = codecCapabilities.profileLevels;
            int n2 = codecCapabilities.profileLevels.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecProfileLevelArray[i2];
                videoCapabilities.add(new DecoderProfileLevel(codecProfileLevel.profile, codecProfileLevel.level));
            }
            MediaCodecInfo.VideoCapabilities videoCapabilities2 = videoCapabilities;
            this.profileLevels = videoCapabilities2.toArray(new DecoderProfileLevel[videoCapabilities2.size()]);
        } else {
            this.profileLevels = new DecoderProfileLevel[0];
        }
        this.colorFormats = codecCapabilities != null && codecCapabilities.colorFormats != null && codecCapabilities.colorFormats.length > 0 ? Arrays.copyOf(codecCapabilities.colorFormats, codecCapabilities.colorFormats.length) : new int[0];
        this.maxSupportedInstances = this.getMaxSupportedInstances(codecCapabilities);
        if (Build.VERSION.SDK_INT >= 21) {
            if (string.contains("video") && codecCapabilities != null) {
                videoCapabilities = codecCapabilities.getVideoCapabilities();
                if (videoCapabilities != null) {
                    this.maxWidth = this.getMaxWidth(videoCapabilities);
                    this.maxHeight = this.getMaxHeight(videoCapabilities);
                    this.maxLumaFrameRate = this.getMaxSupportedFrameRate(videoCapabilities);
                    this.maxFrameRate = (Integer)videoCapabilities.getSupportedFrameRates().getUpper();
                }
                return;
            }
            if (string.contains("audio") && codecCapabilities != null && (videoCapabilities = codecCapabilities.getAudioCapabilities()) != null) {
                this.maxSampleRate = this.getMaxSampleRate((MediaCodecInfo.AudioCapabilities)videoCapabilities);
                this.maxBitRate = this.getMaxBitRate((MediaCodecInfo.AudioCapabilities)videoCapabilities);
                this.maxChannels = this.getMaxChannels((MediaCodecInfo.AudioCapabilities)videoCapabilities);
            }
        }
    }

    private void reset() {
        this.decName = "";
        this.decMimeType = "";
        this.softwareVideoDec = false;
        this.softwareVideoDec = false;
        this.adaptiveDec = false;
        this.tunnelingDec = false;
        this.secureDec = false;
        this.profileLevels = null;
        this.colorFormats = null;
        this.maxSupportedInstances = 0;
        this.maxLumaFrameRate = 30;
        this.maxFrameRate = 30;
        this.maxWidth = 1280;
        this.maxHeight = 720;
        this.maxLumaWidth = 1280;
        this.maxLumaHeight = 720;
        this.maxSampleRate = 48000;
        this.maxBitRate = 960000;
        this.maxChannels = 2;
    }

    private boolean isAdaptive(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        return Build.VERSION.SDK_INT >= 19 && codecCapabilities.isFeatureSupported("adaptive-playback");
    }

    private boolean isTunneling(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        return Build.VERSION.SDK_INT >= 21 && codecCapabilities.isFeatureSupported("tunneled-playback");
    }

    private boolean isSecure(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        return Build.VERSION.SDK_INT >= 21 && codecCapabilities.isFeatureSupported("secure-playback");
    }

    private boolean isVideoSoftwareOnly(String string) {
        String string2;
        boolean bl2 = false;
        String string3 = string2 = string == null ? "" : string.toLowerCase();
        if (string3.startsWith("omx.google.") || string2.startsWith("omx.ffmpeg.") || string2.startsWith("omx.sec.") && string2.contains(".sw.") || string2.equals("omx.qcom.video.decoder.hevcswvdec") || string2.startsWith("omx.qti.video.decoder") && string2.contains("sw") || string2.startsWith("c2.android.") || string2.startsWith("c2.google.")) {
            bl2 = true;
        }
        return bl2;
    }

    private boolean isAudioSoftwareOnly(String string) {
        boolean bl2 = false;
        String string2 = string == null ? "" : string.toLowerCase();
        if (string2.startsWith("omx.google.") || string2.startsWith("c2.android.") || string2.startsWith("c2.google.")) {
            bl2 = true;
        }
        return bl2;
    }

    private int getMaxSupportedInstances(MediaCodecInfo.CodecCapabilities codecCapabilities) {
        if (codecCapabilities == null || Build.VERSION.SDK_INT < 23) {
            return 1;
        }
        return codecCapabilities.getMaxSupportedInstances();
    }

    private int getMaxWidth(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        return (Integer)(videoCapabilities != null ? videoCapabilities.getSupportedWidths() : new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(1280))).getUpper();
    }

    private int getMaxHeight(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        return (Integer)(videoCapabilities != null ? videoCapabilities.getSupportedHeights() : new Range((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(720))).getUpper();
    }

    private final int getMaxSupportedFrameRate(MediaCodecInfo.VideoCapabilities videoCapabilities) {
        if (videoCapabilities == null) {
            return 30;
        }
        this.maxLumaWidth = (Integer)videoCapabilities.getSupportedWidthsFor(this.maxHeight).getUpper();
        this.maxLumaHeight = (Integer)videoCapabilities.getSupportedHeightsFor(this.maxWidth).getUpper();
        return ((Double)videoCapabilities.getSupportedFrameRatesFor(this.maxWidth, this.maxLumaHeight).getUpper()).intValue();
    }

    private int getMaxSampleRate(MediaCodecInfo.AudioCapabilities audioCapabilities) {
        Range[] rangeArray = audioCapabilities != null ? audioCapabilities.getSupportedSampleRateRanges() : null;
        if (rangeArray != null && rangeArray.length > 0) {
            return (Integer)rangeArray[rangeArray.length - 1].getUpper();
        }
        return 48000;
    }

    private int getMaxBitRate(MediaCodecInfo.AudioCapabilities audioCapabilities) {
        return (Integer)(audioCapabilities != null ? audioCapabilities.getBitrateRange() : new Range((Comparable)Integer.valueOf(8000), (Comparable)Integer.valueOf(960000))).getUpper();
    }

    private int getMaxChannels(MediaCodecInfo.AudioCapabilities audioCapabilities) {
        if (audioCapabilities != null) {
            return audioCapabilities.getMaxInputChannelCount();
        }
        return 2;
    }

    public final boolean isVideo() {
        if (this.decMimeType == null) {
            return false;
        }
        return this.decMimeType.startsWith("video/");
    }

    public final boolean isAudio() {
        if (this.decMimeType == null) {
            return false;
        }
        return this.decMimeType.startsWith("audio/");
    }

    public final boolean isSecureDecoder() {
        return this.secureDec;
    }

    public final boolean isVideoSofwareDecoder() {
        return this.softwareVideoDec;
    }

    public final boolean isAudioSofwareDecoder() {
        return this.softwareAudioDec;
    }

    public final boolean isValidDecoder() {
        if (this.isVideo()) {
            return !this.softwareVideoDec || mVideoSoftwareDecoderWhiteList.contains(this.decName);
        }
        if (this.isAudio()) {
            return this.softwareAudioDec || mAudioDecoderWhiteList.contains(this.decName);
        }
        return false;
    }

    public final String getDecoderName() {
        return this.decName;
    }

    public final String getDecoderMimeType() {
        return this.decMimeType;
    }

    public final int getDecoderMaxWidth() {
        return this.maxWidth;
    }

    public final int getDecoderMaxHeight() {
        return this.maxHeight;
    }

    public final int getDecoderLumaWidth() {
        return this.maxLumaWidth;
    }

    public final int getDecoderLumaHeight() {
        return this.maxLumaHeight;
    }

    public final int getDecoderMaxFrameRateForMaxLuma() {
        return this.maxLumaFrameRate;
    }

    public final int getDecoderMaxFrameRate() {
        return this.maxFrameRate;
    }

    public final DecoderProfileLevel[] getProfileLevels() {
        return this.profileLevels;
    }

    public final DecoderProfileLevel getMaxProfileLevel() {
        int n2 = 0;
        DecoderProfileLevel decoderProfileLevel = new DecoderProfileLevel(0, 0);
        DecoderProfileLevel[] decoderProfileLevelArray = this.profileLevels;
        int n3 = this.profileLevels.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            DecoderProfileLevel decoderProfileLevel2 = decoderProfileLevelArray[i2];
            if (decoderProfileLevel2.level < n2) continue;
            n2 = decoderProfileLevel2.level;
            decoderProfileLevel = decoderProfileLevel2;
        }
        return decoderProfileLevel;
    }

    public final int getMaxSupportedInstances() {
        return this.maxSupportedInstances;
    }

    public final int[] getColorFormats() {
        return this.colorFormats;
    }

    public final int getMaxAudioSampleRate() {
        return this.maxSampleRate;
    }

    public final int getMaxAudioBitRate() {
        return this.maxBitRate;
    }

    public final int getMaxAudioChannels() {
        return this.maxChannels;
    }

    static {
        mVideoSoftwareDecoderWhiteList.add("c2.android.vp9.decoder");
        mVideoSoftwareDecoderWhiteList.add("OMX.google.vp9.decoder");
        mVideoSoftwareDecoderWhiteList.add("c2.android.vp8.decoder");
        mVideoSoftwareDecoderWhiteList.add("OMX.google.vp8.decoder");
        mVideoSoftwareDecoderWhiteList.add("c2.android.av1.decoder");
        mAudioDecoderWhiteList = new ArrayList();
    }

    final class DecoderProfileLevel
    implements Serializable {
        public int profile;
        public int level;

        public DecoderProfileLevel(int n2, int n3) {
            this.profile = n2;
            this.level = n3;
        }
    }
}

