/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2.capture;

import android.media.projection.MediaProjection;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videoproducer2.capture.NativeScreenCaptureListener;
import com.tencent.liteav.videoproducer2.capture.j;

@JNINamespace(value="liteav::video")
public class NativeScreenCapture {
    private static final String TAG = "NativeScreenCapture";
    private NativeScreenCaptureListener mListener;
    private j mScreenCaptureBridge;
    private Surface mSurface;
    private MediaProjection mMediaProjection;
    static boolean sIsCheck = false;
    static boolean sIsCaptureClassExist = false;

    public NativeScreenCapture(Surface surface, MediaProjection mediaProjection, NativeScreenCaptureListener listener) {
        this.mSurface = surface;
        this.mMediaProjection = mediaProjection;
        this.mListener = listener;
    }

    public void startVirtualDisplaySync(int width, int height) {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge == null) {
            this.mScreenCaptureBridge = new j(this.mSurface, width, height, this.mMediaProjection, this.mListener);
        }
        this.mScreenCaptureBridge.a();
    }

    public void updateVirtualDisplaySync(int width, int height, boolean forceRestart) {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge == null) {
            LiteavLog.e(TAG, "Must start first!");
            return;
        }
        j j2 = this.mScreenCaptureBridge;
        this.mScreenCaptureBridge.a = width;
        j2.b = height;
        LiteavLog.i("ScreenCaptureBridge", "updateVirtualDisplaySync:[wxh:" + width + "x" + height + "|restart:" + forceRestart + "]");
        if (j2.c == null || forceRestart) {
            j2.b();
            j2.a();
            return;
        }
        j2.c.resize(width, height);
    }

    public void stopVirtualDisplaySync() {
        if (!NativeScreenCapture.checkIfScreenCaptureClassExist()) {
            this.mListener.onClassNotFound();
            return;
        }
        if (this.mScreenCaptureBridge != null) {
            this.mScreenCaptureBridge.b();
            this.mScreenCaptureBridge = null;
        }
    }

    private static boolean checkIfScreenCaptureClassExist() {
        if (sIsCheck) {
            return sIsCaptureClassExist;
        }
        boolean bl2 = false;
        try {
            Class.forName("com.tencent.rtmp.video.ScreenCaptureService");
            Class.forName("com.tencent.rtmp.video.TXScreenCapture");
            bl2 = true;
            LiteavLog.i(TAG, "Detect screen capture class!");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LiteavLog.e(TAG, "Detect screen capture class failed!");
        }
        sIsCaptureClassExist = bl2;
        sIsCheck = true;
        return bl2;
    }
}

