/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaFormat;
import android.os.Bundle;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.c;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.a;
import com.tencent.liteav.videoproducer2.MediaCodecExceptionJni;
import com.tencent.liteav.videoproducer2.MediaCodecFrameJni;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;

@JNINamespace(value="liteav::video")
public class VideoMediaCodecJni {
    private static final String TAG = "VideoMediaCodecJni";
    public static final int DRAIN_ERROR = -1;
    public static final int DRAIN_SUCCESS = 0;
    public static final int DRAIN_KEY_FRAME_WITH_CODEC_CONFIG = 1;
    public static final int DRAIN_CODEC_CONFIG_ONLY = 2;
    public static final int DRAIN_TRY_AGAIN_ONCE = 3;
    public static final int DRAIN_TRY_AGAIN_LATER = 4;
    public static final int FEED_ERROR = -1;
    public static final int FEED_SUCCESS = 0;
    public static final int FEED_TRY_AGAIN_LATER = 1;

    public static MediaCodec createMediaCodec(MediaCodecExceptionJni exception, String mimeType) {
        MediaCodec mediaCodec = null;
        try {
            mediaCodec = MediaCodec.createEncoderByType((String)mimeType);
            LiteavLog.i(TAG, "Use mediacodec name:%s", mediaCodec.getName());
            if (VideoMediaCodecJni.isSoftOnlyEncoder(mediaCodec.getCodecInfo())) {
                throw new Exception("Shouldn't use software encoder");
            }
            return mediaCodec;
        }
        catch (Exception exception2) {
            VideoMediaCodecJni.handleException(exception, exception2);
            LiteavLog.e(TAG, "create MediaCodec failed.".concat(String.valueOf(exception2)));
        }
        catch (Throwable throwable) {
            VideoMediaCodecJni.handleThrowable(exception, throwable);
            LiteavLog.e(TAG, "create MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        VideoMediaCodecJni.destroyMediaCodec(mediaCodec);
        return null;
    }

    private static boolean isSoftOnlyEncoder(MediaCodecInfo info) {
        if (LiteavSystemInfo.getSystemOSVersionInt() > 29) {
            return info.isSoftwareOnly();
        }
        return info.getName().contains("android") || info.getName().contains("google");
    }

    public static MediaFormat configureMediaCodec(MediaCodecExceptionJni exception, MediaCodec mediaCodec, VideoEncodeParams encodeParams, boolean useProfileAndLevel, int maxBFrames, boolean useBaseFormat) {
        MediaFormat mediaFormat;
        String string = "video/avc";
        if (encodeParams.codecType == CodecType.c) {
            string = "video/hevc";
        }
        a a2 = new a(mediaCodec, string, encodeParams, null);
        new a(mediaCodec, string, encodeParams, null).a = encodeParams.bitrateMode == VideoEncoderDef.BitrateMode.b;
        a2.b = useProfileAndLevel;
        if (useBaseFormat) {
            MediaFormat mediaFormat2;
            a a3 = a2;
            MediaFormat mediaFormat3 = a3.b();
            if (mediaFormat3 == null) {
                mediaFormat2 = null;
            } else {
                a3.a(mediaFormat3);
                mediaFormat2 = mediaFormat3;
            }
            mediaFormat = mediaFormat2;
        } else {
            mediaFormat = a2.a();
        }
        if (mediaFormat == null) {
            return null;
        }
        try {
            VideoMediaCodecJni.setMaxBFramesToMediaFormat(mediaFormat, maxBFrames);
            mediaCodec.configure(mediaFormat, null, null, 1);
            LiteavLog.i(TAG, "Configure MediaCodec success, MediaFormat: ".concat(String.valueOf(mediaFormat)));
            return mediaFormat;
        }
        catch (Exception exception2) {
            VideoMediaCodecJni.handleException(exception, exception2);
            LiteavLog.e(TAG, "MediaCodec configure failed.".concat(String.valueOf(exception2)));
            return null;
        }
        catch (Throwable throwable) {
            VideoMediaCodecJni.handleThrowable(exception, throwable);
            LiteavLog.e(TAG, "MediaCodec configure failed.".concat(String.valueOf(throwable)));
            return null;
        }
    }

    private static void setMaxBFramesToMediaFormat(MediaFormat mediaFormat, int maxBFrames) {
        if (maxBFrames <= 0 || LiteavSystemInfo.getSystemOSVersionInt() < 29) {
            return;
        }
        mediaFormat.setInteger("max-bframes", maxBFrames);
    }

    public static Surface createInputSurface(MediaCodec mediaCodec) {
        try {
            if (mediaCodec != null) {
                return mediaCodec.createInputSurface();
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "MediaCodec create input surface failed.".concat(String.valueOf(throwable)));
        }
        return null;
    }

    public static boolean startMediaCodec(MediaCodecExceptionJni exception, MediaCodec mediaCodec) {
        try {
            if (mediaCodec != null) {
                mediaCodec.start();
                return true;
            }
        }
        catch (Exception exception2) {
            VideoMediaCodecJni.handleException(exception, exception2);
            LiteavLog.e(TAG, "MediaCodec start failed.".concat(String.valueOf(exception2)));
        }
        catch (Throwable throwable) {
            VideoMediaCodecJni.handleThrowable(exception, throwable);
            LiteavLog.e(TAG, "MediaCodec start failed.".concat(String.valueOf(throwable)));
        }
        return false;
    }

    public static int getIntFromMediaFormat(MediaFormat mediaFormat, String key, int defValue) {
        try {
            if (mediaFormat != null) {
                return mediaFormat.getInteger(key);
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Get %s from MediaFormat failed.".concat(String.valueOf(throwable)));
        }
        return defValue;
    }

    public static boolean updateBitrate(MediaCodec mediaCodec, int bitrate) {
        if (mediaCodec == null || LiteavSystemInfo.getSystemOSVersionInt() < 19) {
            return false;
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("video-bitrate", bitrate);
            mediaCodec.setParameters(bundle);
            return true;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "update bitrate to MediaCodec failed.".concat(String.valueOf(throwable)));
            return false;
        }
    }

    public static int feedYuvBufferToMediaCodec(MediaCodecExceptionJni exception, MediaCodec mediaCodec, ByteBuffer buffer, long pts, int timeoutMs) {
        try {
            int n2 = mediaCodec.dequeueInputBuffer(TimeUnit.MILLISECONDS.toMicros(timeoutMs));
            if (n2 < 0) {
                return 1;
            }
            ByteBuffer byteBuffer = mediaCodec.getInputBuffers()[n2];
            byteBuffer.clear();
            byteBuffer.put(buffer);
            mediaCodec.queueInputBuffer(n2, 0, buffer.capacity(), TimeUnit.MILLISECONDS.toMicros(pts), 0);
            return 0;
        }
        catch (Exception exception2) {
            VideoMediaCodecJni.handleException(exception, exception2);
            LiteavLog.e(TAG, "Feed yuv buffer to MediaCodec failed.".concat(String.valueOf(exception2)));
        }
        catch (Throwable throwable) {
            VideoMediaCodecJni.handleThrowable(exception, throwable);
            LiteavLog.e(TAG, "Feed yuv buffer to MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        return -1;
    }

    public static int drainOutputBuffer(MediaCodecExceptionJni exception, MediaCodec mediaCodec, MediaCodecFrameJni frameJni, int timeoutMs) {
        int n2;
        MediaCodec.BufferInfo bufferInfo;
        block13: {
            bufferInfo = new MediaCodec.BufferInfo();
            n2 = mediaCodec.dequeueOutputBuffer(bufferInfo, TimeUnit.MILLISECONDS.toMicros(timeoutMs));
            if (n2 == -1) {
                return 4;
            }
            if (n2 == -2) {
                try {
                    MediaFormat mediaFormat = mediaCodec.getOutputFormat();
                    LiteavLog.i(TAG, "encoder output buffers changed %s", mediaFormat);
                }
                catch (Throwable throwable) {
                    return 3;
                }
                return 3;
            }
            if (n2 == -3) {
                return 3;
            }
            if (n2 >= 0) break block13;
            return -1;
        }
        try {
            if (bufferInfo.size == 0 && (bufferInfo.flags & 4) == 0) {
                LiteavLog.e(TAG, "size is zero, but it isn't end of stream");
                return -1;
            }
            ByteBuffer byteBuffer = LiteavSystemInfo.getSystemOSVersionInt() >= 21 ? mediaCodec.getOutputBuffer(n2) : mediaCodec.getOutputBuffers()[n2];
            if (byteBuffer == null) {
                return -1;
            }
            byteBuffer.position(bufferInfo.offset);
            byteBuffer.limit(bufferInfo.offset + bufferInfo.size);
            frameJni.data = ByteBuffer.allocateDirect(bufferInfo.size);
            frameJni.data.put(byteBuffer);
            boolean bl2 = (bufferInfo.flags & 1) > 0;
            boolean bl3 = (bufferInfo.flags & 2) > 0;
            frameJni.nalType = bl2 ? c.b : c.c;
            frameJni.pts = TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs);
            mediaCodec.releaseOutputBuffer(n2, false);
            if (bl3 && bl2) {
                return 1;
            }
            if (bl3) {
                return 2;
            }
            return 0;
        }
        catch (Exception exception2) {
            VideoMediaCodecJni.handleException(exception, exception2);
            LiteavLog.e(TAG, "Drain output from MediaCodec failed.", exception2);
        }
        catch (Throwable throwable) {
            VideoMediaCodecJni.handleThrowable(exception, throwable);
            LiteavLog.e(TAG, "Drain output from MediaCodec failed.", throwable);
        }
        return -1;
    }

    public static void requestKeyFrame(MediaCodec mediaCodec) {
        if (LiteavSystemInfo.getSystemOSVersionInt() <= 19 || mediaCodec == null) {
            return;
        }
        try {
            Bundle bundle = new Bundle();
            bundle.putInt("request-sync", 0);
            mediaCodec.setParameters(bundle);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "requestSyncFrame failed.", throwable);
            return;
        }
    }

    public static void releaseSurface(Surface surface) {
        try {
            if (surface != null) {
                surface.release();
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Release surface failed.".concat(String.valueOf(throwable)));
            return;
        }
    }

    public static void stopMediaCodec(MediaCodec mediaCodec) {
        try {
            if (mediaCodec != null) {
                mediaCodec.stop();
            }
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Stop MediaCodec failed.".concat(String.valueOf(throwable)));
            return;
        }
    }

    public static void destroyMediaCodec(MediaCodec mediaCodec) {
        if (mediaCodec == null) {
            return;
        }
        try {
            mediaCodec.stop();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Stop MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        try {
            mediaCodec.release();
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "Destroy MediaCodec failed.".concat(String.valueOf(throwable)));
        }
        LiteavLog.i(TAG, "Destroy MediaCodec success: ".concat(String.valueOf(mediaCodec)));
    }

    private static void handleException(MediaCodecExceptionJni jni, Exception exception) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            jni.hasException = true;
            jni.systemErrorCode = -1;
            jni.isErrorRecoverable = false;
            return;
        }
        if (exception instanceof MediaCodec.CodecException) {
            jni.hasException = true;
            jni.systemErrorCode = ((MediaCodec.CodecException)exception).getErrorCode();
            jni.isErrorRecoverable = ((MediaCodec.CodecException)exception).isRecoverable() || ((MediaCodec.CodecException)exception).isTransient();
            return;
        }
        jni.hasException = true;
        jni.systemErrorCode = -1;
        jni.isErrorRecoverable = false;
    }

    public static void handleThrowable(MediaCodecExceptionJni jni, Throwable e2) {
        jni.hasException = true;
        jni.systemErrorCode = -2;
        jni.isErrorRecoverable = false;
    }
}

