/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer2;

import android.os.Bundle;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import android.util.Pair;
import android.view.Surface;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.base.util.w;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.EncodedVideoFrame;
import com.tencent.liteav.videobase.egl.EGLCore;
import com.tencent.liteav.videobase.egl.d;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.frame.i;
import com.tencent.liteav.videobase.utils.OpenGlUtils;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videoproducer.encoder.VideoEncodeParams;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.liteav.videoproducer.encoder.e;
import com.tencent.liteav.videoproducer.producer.ServerVideoProducerConfig;
import com.tencent.liteav.videoproducer2.HWEncoderServerConfig;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@JNINamespace(value="liteav::video")
public class HardwareVideoEncoder2 {
    private String mTAG;
    private final Size mSurfaceSize = new Size(0, 0);
    private final AtomicBoolean mNeedRestart = new AtomicBoolean(false);
    private final VideoEncodeParams mParams;
    private final Bundle mSessionStates = new Bundle();
    private final b mThrottlers = new b();
    private HWEncoderServerConfig mServerConfig;
    private long mNativeHandler;
    private Surface mInputSurface;
    private EGLCore mEGLCore;
    private i mPixelFrameRenderer;
    private com.tencent.liteav.videoproducer.encoder.b mSurfaceInputVideoEncoder;
    private long mPreFrameTimeStamp = 0L;
    private String mTraceId;
    private final e.a mVideoEncoderListener = new e.a(){

        @Override
        public final void onBitrateModeUpdated(VideoEncoderDef.BitrateMode mode) {
            HardwareVideoEncoder2.this.nativeOnBitrateModeUpdated(HardwareVideoEncoder2.this.mNativeHandler, mode.mValue);
        }

        @Override
        public final void a() {
            HardwareVideoEncoder2.this.mNeedRestart.set(true);
        }

        @Override
        public final void onEncodedFail(e.a code) {
            HardwareVideoEncoder2.this.notifyEncodeFail();
        }

        @Override
        public final synchronized void onEncodedNAL(EncodedVideoFrame nal, boolean isEos) {
            if (HardwareVideoEncoder2.this.mNativeHandler != 0L && !isEos) {
                EncodedVideoFrame encodedVideoFrame = nal;
                HardwareVideoEncoder2.this.nativeOnEncodedNAL(HardwareVideoEncoder2.this.mNativeHandler, encodedVideoFrame, encodedVideoFrame.data, nal.nalType.mValue, nal.profileType.mValue, nal.codecType.mValue, nal.rotation, nal.dts, nal.pts, nal.gopIndex, nal.gopFrameIndex, nal.frameIndex, nal.refFrameIndex, nal.width, nal.height, nal.svcInfo != null, nal.svcInfo == null ? 0 : nal.svcInfo);
                return;
            }
            LiteavLog.d(HardwareVideoEncoder2.this.mTAG, "onEncodedNAL mNativeHandler=%d,isEos=%b", HardwareVideoEncoder2.this.mNativeHandler, isEos);
        }
    };

    public HardwareVideoEncoder2(long nativeHandler, String traceId, VideoEncodeParams params) {
        this.mTraceId = traceId;
        this.mTAG = traceId + "HardwareVideoEncoder2_" + this.hashCode();
        this.mNativeHandler = nativeHandler;
        this.mParams = params;
    }

    public void setHWEncoderServerConfig(HWEncoderServerConfig serverConfig) {
        this.mServerConfig = serverConfig;
        if (this.mSurfaceInputVideoEncoder != null) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            this.mSurfaceInputVideoEncoder.a(hardwareVideoEncoder2.getServerVideoProducerConfig(hardwareVideoEncoder2.mServerConfig));
        }
    }

    public void requestKeyFrame() {
        if (this.mSurfaceInputVideoEncoder != null) {
            this.mSurfaceInputVideoEncoder.d();
        }
    }

    private ServerVideoProducerConfig getServerVideoProducerConfig(HWEncoderServerConfig hwEncoderServerConfig) {
        ServerVideoProducerConfig serverVideoProducerConfig = new ServerVideoProducerConfig();
        serverVideoProducerConfig.setHardwareEncodeType(hwEncoderServerConfig.getHardwareEncodeType());
        serverVideoProducerConfig.setHardwareEncoderHighProfileEnable(hwEncoderServerConfig.getHardwareEncoderHighProfileEnable());
        serverVideoProducerConfig.setHardwareEncoderHighProfileSupport(hwEncoderServerConfig.getHardwareEncoderHighProfileSupport());
        Boolean bl2 = hwEncoderServerConfig.isHardwareEncoderBitrateModeCBRSupported();
        if (bl2 != null) {
            serverVideoProducerConfig.setHardwareEncoderBitrateModeCBRSupported(bl2);
        }
        return serverVideoProducerConfig;
    }

    private boolean start() {
        if (this.mSurfaceInputVideoEncoder != null) {
            return this.mInputSurface != null;
        }
        LiteavLog.i(this.mTAG, "Start hw video encoder. %s", this.mParams);
        this.mSurfaceInputVideoEncoder = new com.tencent.liteav.videoproducer.encoder.b(this.mSessionStates, new com.tencent.liteav.videobase.videobase.d(), this.mTraceId);
        Object object = Looper.myLooper();
        com.tencent.liteav.videoproducer.encoder.b b2 = this.mSurfaceInputVideoEncoder;
        this.mSurfaceInputVideoEncoder.c = new CustomHandler((Looper)object){

            public final void handleMessage(Message msg) {
                super.handleMessage(msg);
                if (msg.what == 10) {
                    b.this.c();
                }
            }
        };
        HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
        this.mSurfaceInputVideoEncoder.a(hardwareVideoEncoder2.getServerVideoProducerConfig(hardwareVideoEncoder2.mServerConfig));
        e.a a2 = this.mVideoEncoderListener;
        object = this.mParams;
        b2 = this.mSurfaceInputVideoEncoder;
        LiteavLog.d(b2.a, "start");
        b2.e = a2;
        Surface surface = b2.a((VideoEncodeParams)object);
        LiteavLog.i(b2.a, "startCodecInternal success");
        Size size = new Size(720, 1280);
        if (b2.f != null) {
            size.set(b2.f.width, b2.f.height);
        }
        Pair pair = new Pair((Object)surface, (Object)size);
        this.mInputSurface = (Surface)pair.first;
        this.mSurfaceSize.set((Size)pair.second);
        if (this.mInputSurface == null) {
            this.notifyStartEncodedFail();
            return false;
        }
        return true;
    }

    private boolean restart() {
        LiteavLog.d(this.mTAG, "reStart");
        this.stop();
        return this.start();
    }

    public static PixelFrame createPixelFrameByTexture(int width, int height, int bufferType, int formatType, long pts, int rotation, boolean isMirrorHorizontal, boolean isMirrorVertical, int textureId, Object glContext) {
        if (bufferType != GLConstants.a.b.mValue) {
        }
        GLConstants.PixelFormatType.f.getValue();
        PixelFrame pixelFrame = new PixelFrame(width, height, 0, bufferType, formatType);
        pixelFrame.setMirrorHorizontal(isMirrorHorizontal);
        pixelFrame.setMirrorVertical(isMirrorVertical);
        pixelFrame.setTextureId(textureId);
        pixelFrame.setGLContext(glContext);
        pixelFrame.setRotation(l.a(rotation));
        pixelFrame.setTimestamp(pts);
        return pixelFrame;
    }

    public static Object getCurrentContext() {
        return OpenGlUtils.getCurrentContext();
    }

    public static boolean isInUIThread() {
        return Looper.getMainLooper() == Looper.myLooper();
    }

    public void encodeFrame(PixelFrame frame) {
        if (frame == null) {
            return;
        }
        if (this.mNeedRestart.getAndSet(false) && !this.restart()) {
            return;
        }
        if (this.mSurfaceInputVideoEncoder == null && !this.start()) {
            return;
        }
        frame.getGLContext();
        if (this.mEGLCore == null && !this.initOpenGLComponents(frame.getGLContext(), this.mInputSurface)) {
            return;
        }
        this.mSurfaceInputVideoEncoder.c();
        this.drawFrameToInputSurface(frame);
    }

    private void drawFrameToInputSurface(PixelFrame frame) {
        if (this.mEGLCore == null) {
            return;
        }
        try {
            this.mEGLCore.makeCurrent();
            PixelFrame pixelFrame = new PixelFrame(frame);
            if (pixelFrame.getRotation() == l.b || pixelFrame.getRotation() == l.d) {
                PixelFrame pixelFrame2 = pixelFrame;
                pixelFrame2.setMirrorHorizontal(!pixelFrame2.isMirrorHorizontal());
            } else {
                PixelFrame pixelFrame3 = pixelFrame;
                pixelFrame3.setMirrorVertical(!pixelFrame3.isMirrorVertical());
            }
            OpenGlUtils.glViewport(0, 0, this.mSurfaceSize.width, this.mSurfaceSize.height);
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a(pixelFrame, GLConstants.GLScaleType.a, null);
            }
            long l2 = pixelFrame.getTimestamp();
            com.tencent.liteav.videoproducer.encoder.b b2 = this.mSurfaceInputVideoEncoder;
            if (b2.i.isEmpty()) {
                b2.j.set(SystemClock.elapsedRealtime());
            }
            b2.i.addLast(l2);
            b2.c.sendEmptyMessageDelayed(10, 10L);
            if (pixelFrame.getTimestamp() < this.mPreFrameTimeStamp) {
                LiteavLog.e(this.mTAG, "timestamp is not increase. pre: " + this.mPreFrameTimeStamp + ", cur: " + pixelFrame.getTimestamp());
            }
            this.mPreFrameTimeStamp = pixelFrame.getTimestamp();
            this.mEGLCore.setPresentationTime(TimeUnit.MILLISECONDS.toNanos(pixelFrame.getTimestamp()));
            this.mEGLCore.swapBuffers();
            return;
        }
        catch (d d2) {
            String string = "VideoEncode: swapBuffer error, EGLCode:" + d2.mErrorCode + " message:" + d2.getMessage();
            LiteavLog.e(this.mThrottlers.a("EncodeFrameError"), this.mTAG, "makeCurrent failed. error = ".concat(String.valueOf(string)), d2);
            this.notifyEncodeFail();
            return;
        }
    }

    private boolean initOpenGLComponents(Object sharedContext, Surface surface) {
        if (surface == null) {
            LiteavLog.w(this.mThrottlers.a("NoSurface"), this.mTAG, "init opengl: surface is null.", new Object[0]);
            return false;
        }
        LiteavLog.d(this.mThrottlers.a("initGL"), this.mTAG, "initOpenGLComponents", new Object[0]);
        this.mEGLCore = new EGLCore();
        try {
            this.mEGLCore.initialize(sharedContext, surface, this.mSurfaceSize.width, this.mSurfaceSize.height);
        }
        catch (d d2) {
            String string = "VideoEncode: create EGLCore failed, EGLCode:" + d2.mErrorCode + " message:" + d2.getMessage();
            LiteavLog.e(this.mThrottlers.a("initGLError"), this.mTAG, "create EGLCore failed. error = ".concat(String.valueOf(string)), d2);
            this.notifyStartEncodedFail();
            this.mEGLCore = null;
            return false;
        }
        this.mPixelFrameRenderer = new i(this.mSurfaceSize.width, this.mSurfaceSize.height);
        return true;
    }

    public void signalEndOfStream() {
        if (this.mSurfaceInputVideoEncoder != null) {
            com.tencent.liteav.videoproducer.encoder.b b2 = this.mSurfaceInputVideoEncoder;
            LiteavLog.i(b2.a, "signalEndOfStream");
            if (b2.d != null) {
                try {
                    b2.d.signalEndOfInputStream();
                }
                catch (Throwable throwable) {
                    LiteavLog.e(b2.a, "signalEndOfStream failed.", throwable);
                }
            }
            if (b2.h == null) {
                com.tencent.liteav.videoproducer.encoder.b b3 = b2;
                b2.h = new w(Looper.myLooper(), new com.tencent.liteav.videoproducer.encoder.d(b3));
                b2.h.a(30);
            }
        }
    }

    public synchronized void release() {
        LiteavLog.d(this.mTAG, "release");
        this.mNativeHandler = 0L;
        this.stop();
    }

    private void stop() {
        this.uninitOpenGLComponents();
        if (this.mInputSurface != null) {
            this.mInputSurface.release();
            this.mInputSurface = null;
        }
        if (this.mSurfaceInputVideoEncoder != null) {
            com.tencent.liteav.videoproducer.encoder.b b2 = this.mSurfaceInputVideoEncoder;
            LiteavLog.i(b2.a, "stop");
            b2.b();
            b2.a();
            this.mSurfaceInputVideoEncoder.a();
            this.mSurfaceInputVideoEncoder = null;
        }
    }

    public void uninitOpenGLComponents() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.d(this.mThrottlers.a("uninitGL"), this.mTAG, "uninitOpenGLComponents", new Object[0]);
        try {
            this.mEGLCore.makeCurrent();
            if (this.mPixelFrameRenderer != null) {
                this.mPixelFrameRenderer.a();
                this.mPixelFrameRenderer = null;
            }
        }
        catch (d d2) {
            LiteavLog.e(this.mThrottlers.a("unintGLError"), this.mTAG, "makeCurrent failed.", d2);
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    public void setBitrate(int bitrate) {
        LiteavLog.i(this.mTAG, "SetBitrate ".concat(String.valueOf(bitrate)));
        this.mParams.bitrate = bitrate;
        if (this.mSurfaceInputVideoEncoder == null) {
            return;
        }
        com.tencent.liteav.videoproducer.encoder.b b2 = this.mSurfaceInputVideoEncoder;
        if (b2.f == null) {
            LiteavLog.w(b2.a, "encoder not started yet. set bitrate to " + bitrate + " kbps will not take effect.");
            return;
        }
        if (b2.f.bitrate != bitrate) {
            LiteavLog.i(b2.a, "set bitrate to " + bitrate + " kbps");
            boolean bl2 = false;
            if (bitrate < b2.f.bitrate) {
                if (b2.b.getBoolean("need_restart_when_down_bitrate", false)) {
                    bl2 = true;
                } else {
                    b2.a(bitrate);
                }
            }
            b2.f.bitrate = bitrate;
            if (LiteavSystemInfo.getSystemOSVersionInt() >= 19 && b2.d != null) {
                if (bl2) {
                    b2.c.removeCallbacks(b2.k);
                    long l2 = SystemClock.elapsedRealtime() - b2.g;
                    if (l2 >= TimeUnit.SECONDS.toMillis(2L)) {
                        b2.k.run();
                        return;
                    }
                    b2.c.postDelayed(b2.k, 2000L - l2);
                    return;
                }
                com.tencent.liteav.videoproducer.encoder.b b3 = b2;
                b3.a(b3.d, bitrate);
            }
        }
    }

    public synchronized void notifyEncodeFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    public synchronized void notifyStartEncodedFail() {
        if (this.mNativeHandler != 0L) {
            HardwareVideoEncoder2 hardwareVideoEncoder2 = this;
            hardwareVideoEncoder2.nativeOnStartEncodedFail(hardwareVideoEncoder2.mNativeHandler);
        }
    }

    private native void nativeOnEncodedNAL(long var1, EncodedVideoFrame var3, ByteBuffer var4, int var5, int var6, int var7, int var8, long var9, long var11, long var13, long var15, long var17, long var19, int var21, int var22, boolean var23, int var24);

    private native void nativeOnEncodedFail(long var1);

    private native void nativeOnStartEncodedFail(long var1);

    private native void nativeOnBitrateModeUpdated(long var1, int var3);
}

