/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.encoder;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import java.lang.reflect.Field;
import org.json.JSONArray;
import org.json.JSONException;

@JNINamespace(value="liteav::video")
public final class VideoEncodeParams
implements Cloneable {
    public int width = 0;
    public int height = 0;
    public int fps = 20;
    public int gop = 3;
    public int bitrate = 0;
    public boolean annexb = true;
    public VideoEncoderDef.EncoderProfile encoderProfile = null;
    public VideoEncoderDef.BitrateMode bitrateMode = VideoEncoderDef.BitrateMode.b;
    public long baseFrameIndex = 0L;
    public long baseGopIndex = 0L;
    public boolean fullIFrame = false;
    public boolean enableBFrame = false;
    public VideoEncoderDef.ReferenceStrategy referenceStrategy = VideoEncoderDef.ReferenceStrategy.a;
    public CodecType codecType = CodecType.b;
    public GLConstants.ColorSpace colorSpace = GLConstants.ColorSpace.a;
    public GLConstants.ColorRange colorRange = GLConstants.ColorRange.a;
    public boolean isTranscodingMode = false;
    public VideoEncoderDef.EncoderComplexity encoderComplexity = null;
    public VideoEncoderDef.EncodeScene encodeScene = VideoEncoderDef.EncodeScene.a;
    public boolean enableAutoQP = false;
    public JSONArray mediaCodecDeviceRelatedParams = null;

    public VideoEncodeParams() {
    }

    public VideoEncodeParams(VideoEncodeParams copyFrom) {
        if (copyFrom == null) {
            return;
        }
        this.width = copyFrom.width;
        this.height = copyFrom.height;
        this.fps = copyFrom.fps;
        this.gop = copyFrom.gop;
        this.bitrate = copyFrom.bitrate;
        this.annexb = copyFrom.annexb;
        this.encoderProfile = copyFrom.encoderProfile;
        this.bitrateMode = copyFrom.bitrateMode;
        this.baseFrameIndex = copyFrom.baseFrameIndex;
        this.baseGopIndex = copyFrom.baseGopIndex;
        this.fullIFrame = copyFrom.fullIFrame;
        this.enableBFrame = copyFrom.enableBFrame;
        this.codecType = copyFrom.codecType;
        this.referenceStrategy = copyFrom.referenceStrategy;
        this.isTranscodingMode = copyFrom.isTranscodingMode;
        this.encoderComplexity = copyFrom.encoderComplexity;
        this.encodeScene = copyFrom.encodeScene;
        this.enableAutoQP = copyFrom.enableAutoQP;
        this.colorSpace = copyFrom.colorSpace;
        this.colorRange = copyFrom.colorRange;
        if (copyFrom.mediaCodecDeviceRelatedParams != null) {
            try {
                this.mediaCodecDeviceRelatedParams = new JSONArray(copyFrom.mediaCodecDeviceRelatedParams.toString());
                return;
            }
            catch (JSONException jSONException) {}
        }
    }

    public final void setColorSpaceInt(int colorSpace) {
        this.colorSpace = GLConstants.ColorSpace.a(colorSpace);
    }

    public final void setColorRangeInt(int colorRange) {
        this.colorRange = GLConstants.ColorRange.a(colorRange);
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFps() {
        return this.fps;
    }

    public final int getGop() {
        return this.gop;
    }

    public final int getBitrate() {
        return this.bitrate;
    }

    public final int getEncoderProfile() {
        return this.encoderProfile.mValue;
    }

    public final int getBitrateMode() {
        return this.bitrateMode.mValue;
    }

    public final long getBaseFrameIndex() {
        return this.baseFrameIndex;
    }

    public final long getBaseGopIndex() {
        return this.baseGopIndex;
    }

    public final int getCodecType() {
        return this.codecType.mValue;
    }

    public final VideoEncoderDef.ReferenceStrategy getReferenceStrategy() {
        return this.referenceStrategy;
    }

    public final boolean isEnablesBframe() {
        return this.enableBFrame;
    }

    public final boolean isEnablesRps() {
        return this.referenceStrategy == VideoEncoderDef.ReferenceStrategy.b;
    }

    public final boolean isEnablesSvc() {
        return this.referenceStrategy == VideoEncoderDef.ReferenceStrategy.c;
    }

    public final boolean isEnablesUnlimitedGop() {
        return this.referenceStrategy == VideoEncoderDef.ReferenceStrategy.d;
    }

    public final boolean isFullIFrame() {
        return this.fullIFrame;
    }

    public final boolean isAnnexb() {
        return this.annexb;
    }

    public final boolean isTranscodingMode() {
        return this.isTranscodingMode;
    }

    public final void setBFrameEnabled(boolean enableBFrame) {
        this.enableBFrame = enableBFrame;
    }

    public final void setReferenceStrategy(VideoEncoderDef.ReferenceStrategy strategy) {
        this.referenceStrategy = strategy;
    }

    public final void setTranscodingModeEnabled(boolean enableTranscodingMode) {
        this.isTranscodingMode = enableTranscodingMode;
    }

    public final void setEncoderComplexity(VideoEncoderDef.EncoderComplexity encoderComplexity) {
        this.encoderComplexity = encoderComplexity;
    }

    public final int getEncoderComplexity() {
        if (this.encoderComplexity == null) {
            return VideoEncoderDef.EncoderComplexity.e.mValue;
        }
        return this.encoderComplexity.mValue;
    }

    public final void setEncodeScene(VideoEncoderDef.EncodeScene encoderScene) {
        this.encodeScene = encoderScene;
    }

    public final int getEncodeScene() {
        if (this.encodeScene == null) {
            return VideoEncoderDef.EncodeScene.a.mValue;
        }
        return this.encodeScene.mValue;
    }

    public final void setAutoQPEnabeled(boolean enableAutoQP) {
        this.enableAutoQP = enableAutoQP;
    }

    public final boolean isEnableAutoQP() {
        return this.enableAutoQP;
    }

    public final void setFullIFrame(boolean fullIFrame) {
        this.fullIFrame = fullIFrame;
    }

    public final void setAnnexb(boolean annexb) {
        this.annexb = annexb;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final void setFps(int fps) {
        this.fps = fps;
    }

    public final void setGop(int gop) {
        this.gop = gop;
    }

    public final void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public final void setEncoderProfile(VideoEncoderDef.EncoderProfile encoderProfile) {
        this.encoderProfile = encoderProfile;
    }

    public final void setBitrateMode(VideoEncoderDef.BitrateMode bitrateMode) {
        this.bitrateMode = bitrateMode;
    }

    public final void setBaseFrameIndex(long baseFrameIndex) {
        this.baseFrameIndex = baseFrameIndex;
    }

    public final void setBaseGopIndex(long baseGopIndex) {
        this.baseGopIndex = baseGopIndex;
    }

    public final void setCodecType(CodecType codecType) {
        this.codecType = codecType;
    }

    public static VideoEncoderDef.BitrateMode createEncoderBitrateMode(int type) {
        return VideoEncoderDef.BitrateMode.a(type);
    }

    public static CodecType createEncoderVideoCodec(int type) {
        return CodecType.a(type);
    }

    public static VideoEncoderDef.EncoderProfile createEncoderProfileType(int type) {
        return VideoEncoderDef.EncoderProfile.a(type);
    }

    public static VideoEncoderDef.ReferenceStrategy createReferenceStrategy(int strategy) {
        return VideoEncoderDef.ReferenceStrategy.a(strategy);
    }

    public static VideoEncoderDef.EncodeScene createEncodeScene(int scene) {
        return VideoEncoderDef.EncodeScene.a(scene);
    }

    public static VideoEncoderDef.EncoderComplexity createEncoderComplexity(int complexity) {
        return VideoEncoderDef.EncoderComplexity.a(complexity);
    }

    private int checkFieldDiffCounts(Object left, Object right) {
        Field[] fieldArray = VideoEncodeParams.class.getDeclaredFields();
        int n2 = 0;
        Field[] fieldArray2 = fieldArray;
        int n3 = fieldArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Field field = fieldArray2[i2];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                if (CommonUtil.equals(field.get(left), field.get(right))) continue;
                ++n2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return n2;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof VideoEncodeParams) {
            VideoEncodeParams videoEncodeParams = this;
            return videoEncodeParams.checkFieldDiffCounts(videoEncodeParams, obj) == 0;
        }
        return false;
    }

    public final String toString() {
        return "width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + ", gop=" + this.gop + ", bitrate=" + this.bitrate + ", annexb=" + this.annexb + ", encoderProfile=" + (Object)((Object)this.encoderProfile) + ", bitrateMode=" + (Object)((Object)this.bitrateMode) + ", baseFrameIndex=" + this.baseFrameIndex + ", baseGopIndex=" + this.baseGopIndex + ", fullIFrame=" + this.fullIFrame + ", enableBFrame=" + this.enableBFrame + ", referenceStrategy=" + (Object)((Object)this.referenceStrategy) + ", codecType=" + (Object)((Object)this.codecType) + ", isTransCodingMode=" + this.isTranscodingMode + ", mediaCodecDeviceRelatedParams=" + this.mediaCodecDeviceRelatedParams + ", encoderComplexity=" + (Object)((Object)this.encoderComplexity) + ", encodeScene=" + (Object)((Object)this.encodeScene) + ", enableAutoQP=" + this.enableAutoQP + ", colorSpace=" + (Object)((Object)this.colorSpace) + ", colorRange=" + (Object)((Object)this.colorRange);
    }
}

