/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videoproducer.capture;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.frame.PixelFrame;
import com.tencent.liteav.videobase.videobase.c;
import com.tencent.liteav.videobase.videobase.e;
import com.tencent.liteav.videobase.videobase.f;
import com.tencent.liteav.videoproducer.capture.CaptureSourceInterface;

@JNINamespace(value="liteav::video")
class NativeVideoCaptureListener
implements c,
CaptureSourceInterface.CaptureSourceListener {
    private static final String TAG = "NativeVideoCaptureListener";
    private long mNativeHandler;

    public NativeVideoCaptureListener(long nativeHandler) {
        this.mNativeHandler = nativeHandler;
    }

    public synchronized void resetNativeHandle() {
        this.mNativeHandler = 0L;
    }

    public synchronized void onStartFinish(boolean success) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnStartFinish(this.mNativeHandler, success);
        }
    }

    public synchronized void onFrameAvailable(CaptureSourceInterface captureSource, PixelFrame pixelFrame) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnFrameAvailable(this.mNativeHandler, pixelFrame);
        }
    }

    public synchronized void onCaptureError() {
    }

    public synchronized void onScreenDisplayOrientationChanged(l rotation) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnScreenDisplayOrientationChanged(this.mNativeHandler, l.a(rotation));
        }
    }

    public synchronized void onCameraTouchEnable(boolean enableTouch) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnAutoFocusEnabled(this.mNativeHandler, !enableTouch);
        }
    }

    public synchronized void onCameraZoomEnable(boolean enableZoom) {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnZoomEnabled(this.mNativeHandler, enableZoom);
        }
    }

    public synchronized void onCaptureFirstFrame() {
        if (this.mNativeHandler != 0L) {
            NativeVideoCaptureListener.nativeOnCaptureFirstFrame(this.mNativeHandler);
        }
    }

    @Override
    public synchronized void notifyEvent(e.b code, Object param, String msg) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        if (code == e.b.k) {
            NativeVideoCaptureListener.nativeOnCaptureFirstFrame(this.mNativeHandler);
            return;
        }
        if (code == e.b.o) {
            NativeVideoCaptureListener.nativeOnCapturePaused(this.mNativeHandler);
            return;
        }
        if (code == e.b.p) {
            NativeVideoCaptureListener.nativeOnCaptureResumed(this.mNativeHandler);
            return;
        }
        if (code == e.b.n) {
            NativeVideoCaptureListener.nativeOnCaptureStopped(this.mNativeHandler);
        }
    }

    public void notifyEvent(e.b code, int index, String msg) {
    }

    @Override
    public synchronized void notifyWarning(e.c code, String msg) {
    }

    public synchronized void notifyError(e.a code, String msg) {
        if (this.mNativeHandler == 0L) {
            return;
        }
        int n2 = e.a(code);
        if (n2 != 0) {
            NativeVideoCaptureListener.nativeOnCaptureError(this.mNativeHandler, n2, msg);
            return;
        }
        LiteavLog.i(TAG, "notifyError error code:" + (Object)((Object)code) + ", do not need transfer to LiteAvCode:" + n2);
    }

    @Override
    public synchronized void updateStatus(f key, Object value) {
    }

    @Override
    public synchronized void updateStatus(f key, int index, Object value) {
    }

    private static native void nativeOnCapturePaused(long var0);

    private static native void nativeOnCaptureResumed(long var0);

    private static native void nativeOnCaptureStopped(long var0);

    private static native void nativeOnCaptureFirstFrame(long var0);

    private static native void nativeOnStartFinish(long var0, boolean var2);

    private static native void nativeOnFrameAvailable(long var0, PixelFrame var2);

    private static native void nativeOnCaptureError(long var0, int var2, String var3);

    private static native void nativeOnScreenDisplayOrientationChanged(long var0, int var2);

    private static native void nativeOnAutoFocusEnabled(long var0, boolean var2);

    private static native void nativeOnZoomEnabled(long var0, boolean var2);
}

