/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.liteav.videobase.common;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.util.Range;
import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;

@JNINamespace(value="liteav::video")
public class MediaCodecAbility {
    private static final String TAG = "MediaCodecAbility";

    public static boolean isEncoderSupportHevc() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return false;
        }
        try {
            for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(1).getCodecInfos()) {
                if (!mediaCodecInfo.isEncoder()) continue;
                String[] stringArray = mediaCodecInfo.getSupportedTypes();
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!stringArray[i2].contains("video/hevc")) continue;
                    LiteavLog.i(TAG, "get hevc encoder");
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            LiteavLog.w(TAG, "failed to get hevc encoder:".concat(String.valueOf(throwable)));
        }
        LiteavLog.w(TAG, "not got hevc encoder");
        return false;
    }

    public static boolean isDecoderSupportHevc() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return false;
        }
        boolean bl2 = false;
        try {
            block2: for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
                String[] stringArray = mediaCodecInfo.getSupportedTypes();
                if (mediaCodecInfo.isEncoder()) continue;
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!stringArray2[i2].contains("video/hevc")) continue;
                    bl2 = true;
                    LiteavLog.i(TAG, "got hevc decoder:%s", mediaCodecInfo.getName());
                    continue block2;
                }
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get hevc decode error:".concat(String.valueOf(throwable)));
        }
        return bl2;
    }

    public static boolean isMediaCodecDecodeSupportSWHevc() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return false;
        }
        try {
            for (MediaCodecInfo mediaCodecInfo : new MediaCodecList(0).getCodecInfos()) {
                String[] stringArray = mediaCodecInfo.getSupportedTypes();
                if (mediaCodecInfo.isEncoder()) continue;
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    if (!stringArray2[i2].contains("video/hevc") || !MediaCodecAbility.isSoftOnlyDecoder(mediaCodecInfo)) continue;
                    LiteavLog.i(TAG, "got soft only hevc decoder:%s", mediaCodecInfo.getName());
                    return true;
                }
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get hevc decode error:".concat(String.valueOf(throwable)));
        }
        return false;
    }

    public static int getMediaCodecDecoderSupportLowResolution() {
        int n2 = 0;
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return 0;
        }
        try {
            MediaCodecInfo.CodecCapabilities codecCapabilities = MediaCodec.createDecoderByType((String)"video/avc").getCodecInfo().getCapabilitiesForType("video/avc");
            if (codecCapabilities == null) {
                return 0;
            }
            MediaCodecInfo.VideoCapabilities videoCapabilities = codecCapabilities.getVideoCapabilities();
            if (videoCapabilities == null) {
                return 0;
            }
            Range range = videoCapabilities.getSupportedWidths();
            Range range2 = videoCapabilities.getSupportedHeights();
            if (range == null || range2 == null) {
                return 0;
            }
            n2 = Math.max((Integer)range.getLower(), (Integer)range2.getLower());
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get low resolution error:".concat(String.valueOf(throwable)));
        }
        return n2;
    }

    public static boolean isSoftOnlyDecoder(MediaCodecInfo info) {
        if (LiteavSystemInfo.getSystemOSVersionInt() > 29) {
            return info.isSoftwareOnly();
        }
        return info.getName().contains("android") || info.getName().contains("google");
    }
}

