/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.watermark;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videoprocessor.watermark.data.TailWaterMark;

public class TailWaterMarkChain {
    private static final String TAG = "TailWaterMarkChain";
    private TailWaterMark mTailWaterMark;

    public void setTailWaterMark(TailWaterMark tailWaterMark) {
        LiteavLog.i(TAG, "setTailWaterMark:".concat(String.valueOf(tailWaterMark)));
        this.mTailWaterMark = tailWaterMark;
    }

    public float getBlurLevel() {
        if (this.mTailWaterMark == null) {
            return 0.0f;
        }
        return this.mTailWaterMark.mBlurLevel;
    }

    public float getAlpha() {
        if (this.mTailWaterMark == null) {
            return 0.0f;
        }
        return this.mTailWaterMark.mMarkAlphaLevel;
    }

    public TailWaterMark getTailWaterMark(PixelFrame frame) {
        if (frame == null || this.mTailWaterMark == null) {
            return null;
        }
        if (frame.getTimestamp() < this.mTailWaterMark.getStartTime()) {
            return null;
        }
        float f2 = (float)(frame.getTimestamp() - this.mTailWaterMark.getStartTime()) / ((float)this.mTailWaterMark.getDuration() * 1.0f);
        f2 = Math.max(0.0f, f2);
        this.mTailWaterMark.mBlurLevel = f2 = Math.min(1.0f, f2);
        this.mTailWaterMark.mMarkAlphaLevel = f2;
        return this.mTailWaterMark;
    }

    public void clear() {
        if (this.mTailWaterMark != null) {
            this.mTailWaterMark.release();
        }
        this.mTailWaterMark = null;
    }
}

