/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;

public class TXCGPUMirrorFilter
extends TXCGPUEffectFilterBase {
    private static final int DURATION_MIRROR_LV1 = 1000;
    private static final int DURATION_MIRROR_LV2 = 2000;
    private static final String FRAGMENT_SHADER = "varying highp vec2 textureCoordinate; \nuniform sampler2D inputImageTexture; \nuniform lowp float mode; \n \nvoid main() \n{ \n    highp vec2 position = textureCoordinate; \n     \n    if (mode <= 0.5) \n    { \n        if (position.x > 0.5) \n        { \n            position.x = 1.0 - position.x; \n        } \n    } \n    else \n    { \n        if (position.x > 0.5) \n        { \n            position.x = position.x - 0.5; \n        } \n        else \n        { \n            position.x = 0.5 - position.x; \n        } \n    } \n     \n    gl_FragColor = texture2D(inputImageTexture, position); \n} \n";
    private MirrorParam mMirrorParam;
    private int mModePos = -1;

    public TXCGPUMirrorFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", FRAGMENT_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mModePos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"mode");
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mMirrorParam == null) {
            this.mMirrorParam = new MirrorParam();
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 1000L) {
            this.mMirrorParam.mode = 0.0f;
        } else if (l2 < 2000L) {
            this.mMirrorParam.mode = 1.0f;
        } else {
            this.mEffectStartTime = -1L;
        }
        TXCGPUMirrorFilter tXCGPUMirrorFilter = this;
        tXCGPUMirrorFilter.setFloatOnDraw(tXCGPUMirrorFilter.mModePos, this.mMirrorParam.mode);
    }

    public static class MirrorParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float mode = 0.0f;
    }
}

