/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videoprocessor.videoeffect.filter;

import android.opengl.GLES20;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videoprocessor.videoeffect.TXCGPUEffectFilterBase;
import java.nio.FloatBuffer;

public class TXCGPUGhostFilter
extends TXCGPUEffectFilterBase {
    private static final int DURATION_GHOST_LV1 = 100;
    private static final int DURATION_GHOST_LV2 = 200;
    private static final int DURATION_GHOST_LV3 = 300;
    private static final int DURATION_GHOST_LV4 = 400;
    private static final int DURATION_GHOST_LV5 = 500;
    private static final int DURATION_GHOST_LV6 = 600;
    private static final int DURATION_GHOST_LV7 = 700;
    private static final int DURATION_GHOST_LV8 = 800;
    private static final int DURATION_GHOST_LV9 = 850;
    private static final String BLUR_VERTEX_SHADER = "attribute vec4 position;  \nattribute vec4 inputTextureCoordinate;\nuniform vec2 step;  \nvarying vec2 textureCoordinate;  \nvarying vec2 oneBackCoord;  \nvarying vec2 twoBackCoord;  \nvarying vec2 threeBackCoord;  \nvarying vec2 fourBackCoord;  \nvarying vec2 oneForwardCoord;  \nvarying vec2 twoForwardCoord;  \nvarying vec2 threeForwardCoord;  \nvarying vec2 fourForwardCoord;  \nvoid main() {  \n\tgl_Position = position;  \n\tvec2 coord = inputTextureCoordinate.xy;  \n\ttextureCoordinate = coord;  \n\toneBackCoord = coord.xy - step;  \n\ttwoBackCoord = coord.xy - 2.0 * step;  \n\tthreeBackCoord = coord.xy - 3.0 * step;  \n\tfourBackCoord = coord.xy - 4.0 * step;  \n\toneForwardCoord = coord.xy + step;  \n\ttwoForwardCoord = coord.xy + 2.0 * step;  \n\tthreeForwardCoord = coord.xy + 3.0 * step;  \n\tfourForwardCoord = coord.xy + 4.0 * step;  \n}  \n";
    private static final String BLUR_FRAGMENT_SHADER = "precision mediump float;  \nuniform sampler2D inputImageTexture;  \nvarying vec2 textureCoordinate;  \nvarying vec2 oneBackCoord;  \nvarying vec2 twoBackCoord;  \nvarying vec2 threeBackCoord;  \nvarying vec2 fourBackCoord;  \nvarying vec2 oneForwardCoord;  \nvarying vec2 twoForwardCoord;  \nvarying vec2 threeForwardCoord;  \nvarying vec2 fourForwardCoord;  \nvoid main() {   \n\tlowp vec4 fragmentColor = texture2D(inputImageTexture, textureCoordinate) * 0.18;  \n\tfragmentColor += texture2D(inputImageTexture, oneBackCoord) * 0.15;  \n\tfragmentColor += texture2D(inputImageTexture, twoBackCoord) * 0.12;  \n\tfragmentColor += texture2D(inputImageTexture, threeBackCoord) * 0.09;  \n\tfragmentColor += texture2D(inputImageTexture, fourBackCoord) * 0.05;  \n\tfragmentColor += texture2D(inputImageTexture, oneForwardCoord) * 0.15;  \n\tfragmentColor += texture2D(inputImageTexture, twoForwardCoord) * 0.12;  \n\tfragmentColor += texture2D(inputImageTexture, threeForwardCoord) * 0.09;  \n\tfragmentColor += texture2D(inputImageTexture, fourForwardCoord) * 0.05;  \n\tgl_FragColor = fragmentColor;  \n}  \n";
    private static final String SHIFT_FRAGMENT_SHADER = "precision lowp float;  \nvarying vec2 textureCoordinate;  \n\tuniform sampler2D inputImageTexture;  \n\tuniform float shift;  \n\tuniform float alpha;  \n\tvoid main() { vec4 colorShift = texture2D(inputImageTexture, textureCoordinate + vec2(shift, 0.0));\n\tvec4 color = texture2D(inputImageTexture, textureCoordinate + vec2(shift * 0.1, 0.0));  \n\tgl_FragColor = vec4(mix(colorShift.rgb, color.rgb, alpha), color.a);  \n}  \n";
    private final TXCGPUImageFilter mShiftFilter = new TXCGPUImageFilter("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", "precision lowp float;  \nvarying vec2 textureCoordinate;  \n\tuniform sampler2D inputImageTexture;  \n\tuniform float shift;  \n\tuniform float alpha;  \n\tvoid main() { vec4 colorShift = texture2D(inputImageTexture, textureCoordinate + vec2(shift, 0.0));\n\tvec4 color = texture2D(inputImageTexture, textureCoordinate + vec2(shift * 0.1, 0.0));  \n\tgl_FragColor = vec4(mix(colorShift.rgb, color.rgb, alpha), color.a);  \n}  \n");
    private GhostParam mGhostParam;
    private int mShiftPos = -1;
    private int mAlphaPos = -1;
    private int mBlurPos = -1;
    private float mBlur = 0.0f;

    public TXCGPUGhostFilter() {
        super(BLUR_VERTEX_SHADER, BLUR_FRAGMENT_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mBlurPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"step");
        this.mShiftFilter.initialize(texturePool);
        this.mShiftPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"shift");
        this.mAlphaPos = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"alpha");
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        if (this.mShiftFilter != null) {
            this.mShiftFilter.onOutputSizeChanged(width, height);
        }
        if ((double)Math.abs(width) > 1.0E-5 && (double)Math.abs(this.mBlur) > 1.0E-5) {
            TXCGPUGhostFilter tXCGPUGhostFilter = this;
            tXCGPUGhostFilter.setFloatVec2OnDraw(tXCGPUGhostFilter.mBlurPos, new float[]{this.mBlur / (float)this.getOutputSize().width, 0.0f});
        }
    }

    @Override
    public void onUninit() {
        super.onUninit();
        this.mShiftFilter.uninitialize();
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        GLTexture gLTexture = this.mTexturePool.obtain(this.getOutputSize().width, this.getOutputSize().height);
        super.onDraw(inTextureId, gLTexture, cubeCoordsBuffer, textureCoordsBuffer);
        this.mShiftFilter.onDraw(gLTexture.getId(), outTexture, cubeCoordsBuffer, textureCoordsBuffer);
        gLTexture.release();
    }

    @Override
    public void setNextFrameTimestamp(long pts) {
        long l2;
        super.setNextFrameTimestamp(pts);
        if (this.mGhostParam == null) {
            this.mGhostParam = new GhostParam();
            this.mGhostParam.blur = 0.0f;
            this.mGhostParam.shift = 0.0f;
            this.mGhostParam.alpha = 0.0f;
        }
        if ((l2 = Math.abs(pts - this.mEffectStartTime)) < 100L) {
            this.mGhostParam.blur = 10.0f;
            this.mGhostParam.shift = 0.01f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 200L) {
            this.mGhostParam.blur = 20.0f;
            this.mGhostParam.shift = -0.02f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 300L) {
            this.mGhostParam.blur = 30.0f;
            this.mGhostParam.shift = 0.02f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 400L) {
            this.mGhostParam.blur = 20.0f;
            this.mGhostParam.shift = -0.03f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 500L) {
            this.mGhostParam.blur = 10.0f;
            this.mGhostParam.shift = 0.01f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 600L) {
            this.mGhostParam.blur = 20.0f;
            this.mGhostParam.shift = -0.02f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 700L) {
            this.mGhostParam.blur = 30.0f;
            this.mGhostParam.shift = -0.03f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 800L) {
            this.mGhostParam.blur = 20.0f;
            this.mGhostParam.shift = 0.02f;
            this.mGhostParam.alpha = 0.0f;
        } else if (l2 < 850L) {
            this.mGhostParam.blur = 0.0f;
            this.mGhostParam.shift = 0.0f;
            this.mGhostParam.alpha = 0.0f;
        } else {
            this.mEffectStartTime = -1L;
        }
        TXCGPUGhostFilter tXCGPUGhostFilter = this;
        tXCGPUGhostFilter.updateParams(tXCGPUGhostFilter.mGhostParam);
    }

    public void updateParams(GhostParam ghostParam) {
        this.mBlur = ghostParam.blur;
        if (this.getOutputSize().width != 0) {
            TXCGPUGhostFilter tXCGPUGhostFilter = this;
            tXCGPUGhostFilter.setFloatVec2OnDraw(tXCGPUGhostFilter.mBlurPos, new float[]{ghostParam.blur / (float)this.getOutputSize().width, 0.0f});
        }
        this.mShiftFilter.setFloatOnDraw(this.mAlphaPos, ghostParam.alpha);
        this.mShiftFilter.setFloatOnDraw(this.mShiftPos, ghostParam.shift);
    }

    public static class GhostParam
    extends TXCGPUEffectFilterBase.VideoEffectParams {
        public float shift = 0.0f;
        public float blur = 0.0f;
        public float alpha = 0.0f;
    }
}

