/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.PixelFrameQueue;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;

public class RingFrameQueue
implements PixelFrameQueue {
    private static final String TAG = "RingFrameQueue";
    private final Deque<PixelFrame> mPixelFrameList = new LinkedList<PixelFrame>();
    private int mCapability;

    public RingFrameQueue(int capability) {
        this.mCapability = capability;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PixelFrame poll() {
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            return this.mPixelFrameList.pollFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PixelFrame peek() {
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            return this.mPixelFrameList.peek();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void push(PixelFrame frame) {
        frame.retain();
        PixelFrame pixelFrame = null;
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            if (this.mPixelFrameList.size() >= this.mCapability) {
                pixelFrame = this.mPixelFrameList.removeFirst();
            }
            this.mPixelFrameList.addLast(frame);
        }
        if (pixelFrame != null) {
            pixelFrame.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void evictAll() {
        ArrayList<PixelFrame> arrayList;
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            arrayList = new ArrayList<PixelFrame>(this.mPixelFrameList);
            this.mPixelFrameList.clear();
        }
        LiteavLog.i(TAG, "evictAll pixelFrame.");
        PixelFrame.releasePixelFrames(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(PixelFrame removeFrame) {
        if (removeFrame == null) {
            return false;
        }
        boolean bl2 = false;
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            if (this.mPixelFrameList.size() > 0) {
                bl2 = this.mPixelFrameList.removeFirstOccurrence(removeFrame);
            }
        }
        if (bl2) {
            removeFrame.release();
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        RingFrameQueue ringFrameQueue = this;
        synchronized (ringFrameQueue) {
            return this.mPixelFrameList.size();
        }
    }
}

