/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.content.Intent;
import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.utils.LocalBroadcastManager;
import java.nio.ByteBuffer;

public class MemoryAllocator {
    public static final String OUT_OF_MEMORY_ACTION = "com.tencent.liteav.video.action.OUT_OF_MEMORY";
    private static final String TAG = "MemoryAllocator";
    private static final a THROTTLER = new a(1000L);

    public static byte[] allocateByteArray(int size) {
        byte[] byArray = null;
        try {
            byArray = new byte[size];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemoryAllocator.notifyOutOfMemory(outOfMemoryError.getMessage());
        }
        return byArray;
    }

    public static ByteBuffer allocateDirectBuffer(int size) {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = ByteBuffer.allocateDirect(size);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            MemoryAllocator.notifyOutOfMemory(outOfMemoryError.getMessage());
        }
        return byteBuffer;
    }

    private static synchronized void notifyOutOfMemory(String errorMsg) {
        if (THROTTLER.a()) {
            LiteavLog.e(TAG, "allocate buffer failed with oom error, msg:".concat(String.valueOf(errorMsg)));
            LocalBroadcastManager.getInstance().sendBroadcast(new Intent(OUT_OF_MEMORY_ACTION));
        }
    }
}

