/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HardwareDecoderMediaFormatBuilder {
    private static final String TAG = "HardwareDecoderMediaFormatBuilder";
    private ChipBrand mChipBrand = ChipBrand.kUnKnown;
    private MediaFormat mMediaFormat;
    private JSONArray mMediaCodecDeviceRelatedParams;
    private int mWidth;
    private int mHeight;
    private String mMimeType;
    private boolean mIsLowLatencyDecodeEnabled;

    public HardwareDecoderMediaFormatBuilder() {
        ChipBrand chipBrand = this.getChipBrandBySupportedCodecs();
        if (chipBrand == ChipBrand.kUnKnown) {
            chipBrand = this.getChipBrandBySystemInfo();
        }
        this.mChipBrand = chipBrand;
        LiteavLog.i(TAG, "hardware name:" + LiteavSystemInfo.getHardware().toLowerCase() + " chip brand:" + (Object)((Object)this.mChipBrand));
    }

    public HardwareDecoderMediaFormatBuilder setMediaFormat(MediaFormat mediaFormat) {
        this.mMediaFormat = mediaFormat;
        return this;
    }

    public HardwareDecoderMediaFormatBuilder setMediaCodecDeviceRelatedParams(JSONArray mediaCodecDeviceRelatedParams) {
        this.mMediaCodecDeviceRelatedParams = mediaCodecDeviceRelatedParams;
        return this;
    }

    public HardwareDecoderMediaFormatBuilder setWidth(int width) {
        this.mWidth = width;
        return this;
    }

    public HardwareDecoderMediaFormatBuilder setHeight(int height) {
        this.mHeight = height;
        return this;
    }

    public HardwareDecoderMediaFormatBuilder setMimeType(String mimeType) {
        this.mMimeType = mimeType;
        return this;
    }

    public HardwareDecoderMediaFormatBuilder setIsLowLatencyDecodeEnabled(boolean isLowLatency) {
        this.mIsLowLatencyDecodeEnabled = isLowLatency;
        return this;
    }

    public MediaFormat build() {
        MediaFormat mediaFormat = this.getMediaFormatForConfigure();
        if (this.mIsLowLatencyDecodeEnabled) {
            this.configLowLatency(mediaFormat);
        }
        HardwareDecoderMediaFormatBuilder.fillDeviceRelatedDecodeParams(mediaFormat, this.mMediaCodecDeviceRelatedParams);
        return mediaFormat;
    }

    private MediaFormat getMediaFormatForConfigure() {
        if (this.mMediaFormat == null) {
            return MediaFormat.createVideoFormat((String)this.mMimeType, (int)this.mWidth, (int)this.mHeight);
        }
        return this.mMediaFormat;
    }

    private ChipBrand getChipBrandBySupportedCodecs() {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return ChipBrand.kUnKnown;
        }
        try {
            MediaCodecInfo[] mediaCodecInfoArray = new MediaCodecList(0).getCodecInfos();
            int n2 = mediaCodecInfoArray.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                String string = mediaCodecInfoArray[i2].getName().toLowerCase();
                if (string.contains("hisi")) {
                    return ChipBrand.kHisi;
                }
                if (string.contains("amlogic")) {
                    return ChipBrand.kAmlogic;
                }
                if (!string.contains("qcom") && !string.contains("qti")) continue;
                return ChipBrand.kQcom;
            }
        }
        catch (Throwable throwable) {
            LiteavLog.e(TAG, "get mediacode info error:" + throwable.getMessage());
        }
        return ChipBrand.kUnKnown;
    }

    private ChipBrand getChipBrandBySystemInfo() {
        String string = LiteavSystemInfo.getHardware().toLowerCase();
        if (string.contains("qcom")) {
            return ChipBrand.kQcom;
        }
        if (string.contains("kirin")) {
            return ChipBrand.kHisi;
        }
        if (string.contains("exynos")) {
            return ChipBrand.kExynos;
        }
        return ChipBrand.kUnKnown;
    }

    private void configLowLatency(MediaFormat format) {
        int n2 = LiteavSystemInfo.getSystemOSVersionInt();
        if (n2 >= 30 && this.mChipBrand != ChipBrand.kHisi) {
            format.setInteger("low-latency", 1);
        }
        if (n2 > 23 || !LiteavSystemInfo.getManufacturer().toLowerCase().contains("xiaomi")) {
            format.setInteger("vdec-lowlatency", 1);
        }
        if (n2 >= 26) {
            this.configVendorLowLatencyAfterApi26(format);
        }
    }

    private void configVendorLowLatencyAfterApi26(MediaFormat format) {
        switch (this.mChipBrand) {
            case kQcom: {
                format.setInteger("vendor.qti-ext-dec-low-latency.enable", 1);
                format.setInteger("vendor.qti-ext-dec-picture-order.enable", 1);
                return;
            }
            case kHisi: {
                format.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-req", 1);
                format.setInteger("vendor.hisi-ext-low-latency-video-dec.video-scene-for-low-latency-rdy", -1);
                return;
            }
            case kExynos: {
                format.setInteger("vendor.rtc-ext-dec-low-latency.enable", 1);
                return;
            }
            case kAmlogic: {
                format.setInteger("vendor.low-latency.enable", 1);
            }
        }
    }

    private static void fillDeviceRelatedDecodeParams(MediaFormat mediaFormat, JSONArray deviceRelatedParams) {
        if (deviceRelatedParams == null) {
            return;
        }
        try {
            for (int i2 = 0; i2 < deviceRelatedParams.length(); ++i2) {
                JSONObject jSONObject = deviceRelatedParams.getJSONObject(i2);
                mediaFormat.setInteger(jSONObject.optString("key"), jSONObject.optInt("value"));
            }
            return;
        }
        catch (JSONException jSONException) {
            LiteavLog.e(TAG, "set MediaCodec device related params failed.", jSONException);
            return;
        }
    }

    public static enum ChipBrand {
        kUnKnown,
        kQcom,
        kHisi,
        kExynos,
        kAmlogic;

    }
}

