/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.utils;

import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.PixelFrameQueue;
import java.util.ArrayList;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;

public class BlockingFrameQueue
implements PixelFrameQueue {
    private static final String TAG = "BlockingFrameQueue";
    private final BlockingDeque<PixelFrame> mPixelFrameList;

    public BlockingFrameQueue(int capability) {
        this.mPixelFrameList = new LinkedBlockingDeque<PixelFrame>(capability);
    }

    @Override
    public PixelFrame poll() {
        return this.mPixelFrameList.poll();
    }

    @Override
    public PixelFrame peek() {
        return this.mPixelFrameList.peek();
    }

    @Override
    public void push(PixelFrame frame) {
        frame.retain();
        try {
            this.mPixelFrameList.put(frame);
            return;
        }
        catch (InterruptedException interruptedException) {
            LiteavLog.e(TAG, "push frame failed with exception", interruptedException);
            return;
        }
    }

    @Override
    public void evictAll() {
        ArrayList<PixelFrame> arrayList = new ArrayList<PixelFrame>();
        this.mPixelFrameList.drainTo(arrayList);
        PixelFrame.releasePixelFrames(arrayList);
    }

    @Override
    public boolean remove(PixelFrame removeFrame) {
        if (this.mPixelFrameList.removeFirstOccurrence(removeFrame)) {
            removeFrame.release();
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.mPixelFrameList.size();
    }
}

