/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.filter.TXCGPUImageOESInputFilter;
import com.tencent.ugc.videobase.filter.TXCGPUImageRGBAInputFilter;
import com.tencent.ugc.videobase.frame.GLFrameBuffer;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.yuv.TXCGPUImageI420InputFilter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageNV12InputFilter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageNV21InputFilter;
import com.tencent.ugc.videobase.yuv.TXCGPUImageYUVInputFilter;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;

public class PixelFrameRenderer {
    private static final String TAG = "PixelFrameRenderer";
    private static final float[] OES_TEXTURE_COORDS_NO_ROTATION = new float[]{0.0f, 1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final float[] OES_TEXTURE_COORDS_ROTATE_RIGHT = new float[]{0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    private static final float[] OES_TEXTURE_COORDS_ROTATE_LEFT = new float[]{1.0f, 1.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
    private static final float[] OES_TEXTURE_COORDS_ROTATED_180 = new float[]{1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, 1.0f};
    private int mOutFrameWidth;
    private int mOutFrameHeight;
    private final FloatBuffer mCubeVerticesBuffer;
    private final FloatBuffer mInputTextureCoordsBuffer;
    private final TXCGPUImageFilter[] mRawDataInputFilter = new TXCGPUImageFilter[GLConstants.PixelFormatType.values().length];
    private GLConstants.GLScaleType mScaleType;
    private PixelFrame mFrameParams = null;
    private TXCGPUImageOESInputFilter mOesInputFilter = null;
    private TXCGPUImageFilter mNormalFilter = null;
    private GLFrameBuffer mFrameBufferForClear;

    public PixelFrameRenderer(int outputWidth, int outputHeight) {
        this.mOutFrameWidth = outputWidth;
        this.mOutFrameHeight = outputHeight;
        this.mCubeVerticesBuffer = ByteBuffer.allocateDirect(GLConstants.d.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer().put(GLConstants.d);
        this.mInputTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
    }

    public void renderFrame(PixelFrame pixelFrame, GLConstants.GLScaleType scaleType, GLTexture texture) {
        if (pixelFrame == null || !pixelFrame.isFrameDataValid()) {
            LiteavLog.w(TAG, "renderFrame: pixelFrame is not valid");
            return;
        }
        if (texture != null) {
            texture.setColorFormat(pixelFrame.getColorRange(), pixelFrame.getColorSpace());
        }
        if (this.mFrameParams == null || this.isIncompatible(pixelFrame, scaleType)) {
            this.mScaleType = scaleType;
            this.mFrameParams = new PixelFrame(pixelFrame);
            this.destroyGLComponents();
            this.recalcCubeAndTextureCoordinates();
        }
        if (scaleType == GLConstants.GLScaleType.b) {
            this.clearTexture(texture);
        }
        if (this.mFrameParams.getPixelBufferType() == GLConstants.a.a) {
            if (this.mFrameParams.getPixelFormatType() != GLConstants.PixelFormatType.f) {
                PixelFrameRenderer pixelFrameRenderer = this;
                pixelFrameRenderer.renderYuvData(pixelFrameRenderer.mFrameParams.getPixelFormatType(), texture, pixelFrame.getBuffer(), pixelFrame.getColorRange(), pixelFrame.getColorSpace());
                return;
            }
            this.renderRgbaData(texture, pixelFrame.getBuffer());
            return;
        }
        if (this.mFrameParams.getPixelBufferType() == GLConstants.a.d) {
            if (this.mFrameParams.getPixelFormatType() != GLConstants.PixelFormatType.f) {
                PixelFrameRenderer pixelFrameRenderer = this;
                pixelFrameRenderer.renderYuvData(pixelFrameRenderer.mFrameParams.getPixelFormatType(), texture, ByteBuffer.wrap(pixelFrame.getData()), pixelFrame.getColorRange(), pixelFrame.getColorSpace());
                return;
            }
            this.renderRgbaData(texture, ByteBuffer.wrap(pixelFrame.getData()));
            return;
        }
        if (this.mFrameParams.getPixelBufferType() == GLConstants.a.c) {
            this.renderTextureOesInput(texture, pixelFrame.getTextureId(), pixelFrame.getMatrix());
            return;
        }
        if (this.mFrameParams.getPixelBufferType() == GLConstants.a.b) {
            this.renderTexture2DInput(texture, pixelFrame.getTextureId());
        }
    }

    public void setOutputSize(int width, int height) {
        if (this.mOutFrameWidth != width || this.mOutFrameHeight != height) {
            this.mOutFrameWidth = width;
            this.mOutFrameHeight = height;
            this.recalcCubeAndTextureCoordinates();
        }
    }

    public Size getOutputSize() {
        return new Size(this.mOutFrameWidth, this.mOutFrameHeight);
    }

    public void uninitialize() {
        this.mFrameParams = null;
        this.destroyGLComponents();
    }

    private boolean isIncompatible(PixelFrame pixelFrame, GLConstants.GLScaleType scaleType) {
        return scaleType != this.mScaleType || pixelFrame.getWidth() != this.mFrameParams.getWidth() || pixelFrame.getHeight() != this.mFrameParams.getHeight() || pixelFrame.getPixelBufferType() != this.mFrameParams.getPixelBufferType() || pixelFrame.getPixelFormatType() != this.mFrameParams.getPixelFormatType() || pixelFrame.isMirrorHorizontal() != this.mFrameParams.isMirrorHorizontal() || pixelFrame.isMirrorVertical() != this.mFrameParams.isMirrorVertical() || pixelFrame.getRotation() != this.mFrameParams.getRotation();
    }

    private void recalcCubeAndTextureCoordinates() {
        if (this.mFrameParams == null) {
            return;
        }
        boolean bl2 = this.mFrameParams.getRotation() == l.b || this.mFrameParams.getRotation() == l.d;
        int n2 = this.mFrameParams.getWidth();
        int n3 = this.mFrameParams.getHeight();
        float f2 = Math.max(1.0f * (float)this.mOutFrameWidth / (float)n2, 1.0f * (float)this.mOutFrameHeight / (float)n3);
        float f3 = 1.0f * (float)Math.round((float)n2 * f2) / (float)this.mOutFrameWidth;
        float f4 = 1.0f * (float)Math.round((float)n3 * f2) / (float)this.mOutFrameHeight;
        float[] fArray = GLConstants.d;
        float[] fArray2 = new float[8];
        if (this.mFrameParams.getPixelBufferType() == GLConstants.a.c) {
            PixelFrameRenderer.initOESTextureCoordsBuffer(fArray2, this.mFrameParams.getRotation(), this.mFrameParams.isMirrorHorizontal(), this.mFrameParams.isMirrorVertical());
        } else {
            OpenGlUtils.initTextureCoordsBuffer(fArray2, this.mFrameParams.getRotation(), this.mFrameParams.isMirrorHorizontal(), this.mFrameParams.isMirrorVertical());
        }
        if (this.mScaleType == GLConstants.GLScaleType.a) {
            float f5 = bl2 ? (1.0f - 1.0f / f4) / 2.0f : (1.0f - 1.0f / f3) / 2.0f;
            float f6 = bl2 ? (1.0f - 1.0f / f3) / 2.0f : (1.0f - 1.0f / f4) / 2.0f;
            fArray2[0] = this.addDistance(fArray2[0], f5);
            fArray2[1] = this.addDistance(fArray2[1], f6);
            fArray2[2] = this.addDistance(fArray2[2], f5);
            fArray2[3] = this.addDistance(fArray2[3], f6);
            fArray2[4] = this.addDistance(fArray2[4], f5);
            fArray2[5] = this.addDistance(fArray2[5], f6);
            fArray2[6] = this.addDistance(fArray2[6], f5);
            fArray2[7] = this.addDistance(fArray2[7], f6);
        } else if (this.mScaleType == GLConstants.GLScaleType.b) {
            fArray = new float[]{fArray[0] / f4, fArray[1] / f3, fArray[2] / f4, fArray[3] / f3, fArray[4] / f4, fArray[5] / f3, fArray[6] / f4, fArray[7] / f3};
        }
        this.mCubeVerticesBuffer.clear();
        this.mCubeVerticesBuffer.put(fArray).position(0);
        this.mInputTextureCoordsBuffer.clear();
        this.mInputTextureCoordsBuffer.put(fArray2).position(0);
    }

    private float addDistance(float coordinate, float distance) {
        if (coordinate == 0.0f) {
            return distance;
        }
        return 1.0f - distance;
    }

    private void initNormalFilter() {
        if (this.mNormalFilter != null) {
            return;
        }
        this.mNormalFilter = new TXCGPUImageFilter();
        this.mNormalFilter.initialize(null);
    }

    private void renderRgbaData(GLTexture outTexture, Buffer data) {
        int n2 = GLConstants.PixelFormatType.f.ordinal();
        if (this.mRawDataInputFilter[n2] == null) {
            this.mRawDataInputFilter[n2] = new TXCGPUImageRGBAInputFilter();
            this.mRawDataInputFilter[n2].initialize(null);
        }
        TXCGPUImageRGBAInputFilter tXCGPUImageRGBAInputFilter = (TXCGPUImageRGBAInputFilter)this.mRawDataInputFilter[n2];
        tXCGPUImageRGBAInputFilter.onOutputSizeChanged(this.mOutFrameWidth, this.mOutFrameHeight);
        OpenGlUtils.glViewport(0, 0, this.mOutFrameWidth, this.mOutFrameHeight);
        if (this.mFrameParams.getRotation() == l.b || this.mFrameParams.getRotation() == l.d) {
            tXCGPUImageRGBAInputFilter.loadRgbaData(data, this.mFrameParams.getHeight(), this.mFrameParams.getWidth());
        } else {
            tXCGPUImageRGBAInputFilter.loadRgbaData(data, this.mFrameParams.getWidth(), this.mFrameParams.getHeight());
        }
        tXCGPUImageRGBAInputFilter.onDraw(-1, outTexture, this.mCubeVerticesBuffer, this.mInputTextureCoordsBuffer);
    }

    private void renderYuvData(GLConstants.PixelFormatType pixelFormatType, GLTexture outTexture, ByteBuffer buffer, GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
        int n2 = pixelFormatType.ordinal();
        if (this.mRawDataInputFilter[n2] == null) {
            this.mRawDataInputFilter[n2] = pixelFormatType == GLConstants.PixelFormatType.a ? new TXCGPUImageI420InputFilter() : (pixelFormatType == GLConstants.PixelFormatType.c ? new TXCGPUImageNV21InputFilter() : new TXCGPUImageNV12InputFilter());
            this.mRawDataInputFilter[n2].setColorFormat(colorRange, colorSpace);
            this.mRawDataInputFilter[n2].initialize(null);
        }
        TXCGPUImageYUVInputFilter tXCGPUImageYUVInputFilter = (TXCGPUImageYUVInputFilter)this.mRawDataInputFilter[n2];
        tXCGPUImageYUVInputFilter.onOutputSizeChanged(this.mOutFrameWidth, this.mOutFrameHeight);
        OpenGlUtils.glViewport(0, 0, this.mOutFrameWidth, this.mOutFrameHeight);
        if (this.mFrameParams.getRotation() == l.b || this.mFrameParams.getRotation() == l.d) {
            tXCGPUImageYUVInputFilter.loadYuvDataToTexture(buffer, this.mFrameParams.getHeight(), this.mFrameParams.getWidth());
        } else {
            tXCGPUImageYUVInputFilter.loadYuvDataToTexture(buffer, this.mFrameParams.getWidth(), this.mFrameParams.getHeight());
        }
        tXCGPUImageYUVInputFilter.onDraw(-1, outTexture, this.mCubeVerticesBuffer, this.mInputTextureCoordsBuffer);
    }

    private void renderTextureOesInput(GLTexture outTexture, int textureId, float[] matrix) {
        if (this.mOesInputFilter == null) {
            this.mOesInputFilter = new TXCGPUImageOESInputFilter();
            this.mOesInputFilter.initialize(null);
        }
        OpenGlUtils.glViewport(0, 0, this.mOutFrameWidth, this.mOutFrameHeight);
        this.mOesInputFilter.setTextureTransform(matrix);
        this.mOesInputFilter.onOutputSizeChanged(this.mOutFrameWidth, this.mOutFrameHeight);
        this.mOesInputFilter.onDraw(textureId, outTexture, this.mCubeVerticesBuffer, this.mInputTextureCoordsBuffer);
    }

    private void renderTexture2DInput(GLTexture outTexture, int textureId) {
        this.initNormalFilter();
        OpenGlUtils.glViewport(0, 0, this.mOutFrameWidth, this.mOutFrameHeight);
        this.mNormalFilter.onOutputSizeChanged(this.mOutFrameWidth, this.mOutFrameHeight);
        this.mNormalFilter.onDraw(textureId, outTexture, this.mCubeVerticesBuffer, this.mInputTextureCoordsBuffer);
    }

    private void clearTexture(GLTexture glTexture) {
        if (this.mFrameBufferForClear == null) {
            this.mFrameBufferForClear = new GLFrameBuffer();
            this.mFrameBufferForClear.initialize();
        }
        GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        if (glTexture == null) {
            GLES20.glBindFramebuffer((int)36160, (int)0);
            GLES20.glClear((int)16640);
            return;
        }
        this.mFrameBufferForClear.attachTexture(glTexture.getId());
        this.mFrameBufferForClear.bindToContext();
        GLES20.glClear((int)16640);
        this.mFrameBufferForClear.unbindFromContext();
        this.mFrameBufferForClear.detachTexture();
    }

    private void destroyGLComponents() {
        if (this.mOesInputFilter != null) {
            this.mOesInputFilter.uninitialize();
            this.mOesInputFilter = null;
        }
        if (this.mNormalFilter != null) {
            this.mNormalFilter.uninitialize();
            this.mNormalFilter = null;
        }
        if (this.mFrameBufferForClear != null) {
            this.mFrameBufferForClear.uninitialize();
            this.mFrameBufferForClear = null;
        }
        for (int i2 = 0; i2 < this.mRawDataInputFilter.length; ++i2) {
            if (this.mRawDataInputFilter[i2] == null) continue;
            this.mRawDataInputFilter[i2].uninitialize();
            this.mRawDataInputFilter[i2] = null;
        }
        LiteavLog.i(TAG, "uninitialize GL components");
    }

    private static void initOESTextureCoordsBuffer(float[] textureCoords, l rotation, boolean flipHorizontal, boolean flipVertical) {
        float[] fArray = OES_TEXTURE_COORDS_NO_ROTATION;
        if (rotation != null) {
            switch (rotation) {
                case b: {
                    fArray = OES_TEXTURE_COORDS_ROTATE_RIGHT;
                    break;
                }
                case c: {
                    fArray = OES_TEXTURE_COORDS_ROTATED_180;
                    break;
                }
                case d: {
                    fArray = OES_TEXTURE_COORDS_ROTATE_LEFT;
                    break;
                }
                default: {
                    fArray = OES_TEXTURE_COORDS_NO_ROTATION;
                }
            }
        }
        System.arraycopy(fArray, 0, textureCoords, 0, fArray.length);
        if (flipHorizontal) {
            textureCoords[0] = PixelFrameRenderer.flip(textureCoords[0]);
            textureCoords[2] = PixelFrameRenderer.flip(textureCoords[2]);
            textureCoords[4] = PixelFrameRenderer.flip(textureCoords[4]);
            textureCoords[6] = PixelFrameRenderer.flip(textureCoords[6]);
        }
        if (flipVertical) {
            textureCoords[1] = PixelFrameRenderer.flip(textureCoords[1]);
            textureCoords[3] = PixelFrameRenderer.flip(textureCoords[3]);
            textureCoords[5] = PixelFrameRenderer.flip(textureCoords[5]);
            textureCoords[7] = PixelFrameRenderer.flip(textureCoords[7]);
        }
    }

    private static float flip(float i2) {
        if (i2 == 0.0f) {
            return 1.0f;
        }
        return 0.0f;
    }
}

