/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.frame;

import android.opengl.EGL14;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.frame.FrameMetaData;
import com.tencent.ugc.videobase.frame.FramePool;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.IRecycler;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.b;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.util.concurrent.atomic.AtomicInteger;

public class GLTexturePool
extends FramePool<GLTexture> {
    private static final AtomicInteger sTextureCount = new AtomicInteger();

    public GLTexture obtain(int width, int height) {
        GLTexture gLTexture = (GLTexture)super.obtain(new a(width, height));
        gLTexture.reset();
        return gLTexture;
    }

    @Override
    public void evictAll() {
        super.evictAll();
    }

    @Override
    public void destroy() {
        super.destroy();
    }

    @Override
    protected GLTexture createInstance(IRecycler<GLTexture> recycler, FramePool.Key key) {
        a a2 = (a)key;
        PooledGLTexture pooledGLTexture = new PooledGLTexture(recycler, a2.a, a2.b);
        pooledGLTexture.initialize();
        return pooledGLTexture;
    }

    @Override
    protected void destroyInstance(GLTexture texture) {
        ((PooledGLTexture)texture).uninitialize();
    }

    @Override
    protected FramePool.Key keyForObject(GLTexture obj) {
        return new a(obj.getWidth(), obj.getHeight());
    }

    public static class TextureFrame
    extends PixelFrame {
        private final GLTexture mTexture;
        private static final IRecycler<TextureFrame> RECYCLER = b.a();

        private TextureFrame(GLTexture texture, Object eglContext) {
            super(RECYCLER);
            texture.retain();
            this.mWidth = texture.getWidth();
            this.mHeight = texture.getHeight();
            this.mTexture = texture;
            this.mTextureId = this.mTexture.getId();
            this.mGLContext = eglContext;
            this.mPixelBufferType = GLConstants.a.b;
            this.mPixelFormatType = GLConstants.PixelFormatType.f;
            this.mMetaData = this.mTexture.getMetaData();
            this.mColorRange = this.mTexture.getColorRange();
            this.mColorSpace = this.mTexture.getColorSpace();
        }

        public GLTexture getGLTexture() {
            return this.mTexture;
        }

        @Override
        public void setTextureId(int textureId) {
            throw new UnsupportedOperationException("Object is allocated by pool, can't change its Buffer");
        }

        static /* synthetic */ void lambda$static$0(TextureFrame obj) {
            obj.mTexture.release();
        }
    }

    static final class a
    implements FramePool.Key {
        private final int a;
        private final int b;

        public a(int n2, int n3) {
            this.a = n2;
            this.b = n3;
        }

        @Override
        public final int hashCode() {
            return this.a * 37213 + this.b;
        }

        @Override
        public final boolean equals(Object obj) {
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            a a2 = (a)obj;
            return this.a == a2.a && this.b == a2.b;
        }
    }

    public static class PooledGLTexture
    extends GLTexture {
        private static final String TAG = "GLTexture";
        private int mTextureId = -1;
        private final int mWidth;
        private final int mHeight;
        private GLConstants.ColorRange mColorRange;
        private GLConstants.ColorSpace mColorSpace;
        private FrameMetaData mMetaData;

        private PooledGLTexture(IRecycler<GLTexture> recycler, int width, int height) {
            super(recycler);
            this.mWidth = width;
            this.mHeight = height;
        }

        private void initialize() {
            this.mTextureId = OpenGlUtils.createTexture(this.mWidth, this.mHeight, 6408, 6408);
            sTextureCount.incrementAndGet();
        }

        private void uninitialize() {
            i.a(EGL14.eglGetCurrentContext(), EGL14.EGL_NO_CONTEXT);
            OpenGlUtils.deleteTexture(this.mTextureId);
            this.mTextureId = -1;
            sTextureCount.getAndDecrement();
        }

        @Override
        public int getId() {
            return this.mTextureId;
        }

        @Override
        public int getWidth() {
            return this.mWidth;
        }

        @Override
        public int getHeight() {
            return this.mHeight;
        }

        @Override
        public void setMetaData(FrameMetaData metaData) {
            this.mMetaData = metaData;
        }

        @Override
        public FrameMetaData getMetaData() {
            return this.mMetaData;
        }

        @Override
        public void setColorFormat(GLConstants.ColorRange colorRange, GLConstants.ColorSpace colorSpace) {
            this.mColorRange = colorRange;
            this.mColorSpace = colorSpace;
        }

        @Override
        public GLConstants.ColorRange getColorRange() {
            return this.mColorRange;
        }

        @Override
        public GLConstants.ColorSpace getColorSpace() {
            return this.mColorSpace;
        }

        @Override
        public void release() {
            super.release();
        }

        @Override
        public PixelFrame wrap(Object eglContext) {
            TextureFrame textureFrame = new TextureFrame(this, eglContext);
            textureFrame.setColorFormat(this.mColorRange, this.mColorSpace);
            textureFrame.retain();
            return textureFrame;
        }

        @Override
        public void reset() {
            this.mMetaData = null;
        }
    }
}

