/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.filter;

import android.graphics.PointF;
import android.opengl.GLES20;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.filter.a;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.PerspectiveTransformMatrixCalculator;
import java.util.List;

public class TXCGPUImagePerspectiveCorrectionFilter
extends TXCGPUImageFilter {
    public static final String DISTORTION_CORRECTION_FILTER_FRAGMENT_SHADER = "precision highp float;\nvarying highp vec2 textureCoordinate;\nuniform sampler2D inputImageTexture;\nuniform mat3 matrix;\n\nvoid main()\n{\n  float cv_y = 1.0 - textureCoordinate.y;\n  float denominator = matrix[0][2] * textureCoordinate.x + matrix[1][2] * cv_y + matrix[2][2];\n  vec2 dst_coords;\n  dst_coords.x = matrix[0][0] * textureCoordinate.x + matrix[1][0] * cv_y + matrix[2][0];\n  dst_coords.y = matrix[0][1] * textureCoordinate.x + matrix[1][1] * cv_y + matrix[2][1];\n  dst_coords.x = dst_coords.x / denominator;\n  dst_coords.y = 1.0 - (dst_coords.y / denominator);\n  gl_FragColor = texture2D(inputImageTexture, dst_coords);\n}\n";
    private static final String TAG = "TXCGPUImageDistortionCorrectionFilter";
    private int mUniformTransformMatrix;
    private float[] mTransformMatrix3x3;

    public TXCGPUImagePerspectiveCorrectionFilter() {
        super("attribute vec4 position;\nattribute vec4 inputTextureCoordinate;\nuniform mat4 textureTransform;\nvarying highp vec2 textureCoordinate;\nvoid main()\n{\n    gl_Position = position;\n    textureCoordinate = (textureTransform * inputTextureCoordinate).xy;\n}", DISTORTION_CORRECTION_FILTER_FRAGMENT_SHADER);
    }

    @Override
    public void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        this.mUniformTransformMatrix = GLES20.glGetUniformLocation((int)this.getProgramId(), (String)"matrix");
    }

    @Override
    public void beforeDrawArrays(int textureId) {
        super.beforeDrawArrays(textureId);
        float[] fArray = this.mTransformMatrix3x3 == null ? GLConstants.a : this.mTransformMatrix3x3;
        GLES20.glUniformMatrix3fv((int)this.mUniformTransformMatrix, (int)1, (boolean)false, (float[])fArray, (int)0);
    }

    public void setPerspectiveCorrectionPoints(List<PointF> srcPoints, List<PointF> dstPoints) {
        if (srcPoints == null || srcPoints.size() != 4 || dstPoints == null || dstPoints.size() != 4) {
            return;
        }
        this.setTransformPoints(srcPoints, dstPoints);
    }

    private void setTransformPoints(List<PointF> srcPoints, List<PointF> dstPoints) {
        TXCGPUImagePerspectiveCorrectionFilter tXCGPUImagePerspectiveCorrectionFilter = this;
        tXCGPUImagePerspectiveCorrectionFilter.runOnDraw(a.a(tXCGPUImagePerspectiveCorrectionFilter, dstPoints, srcPoints));
    }

    static /* synthetic */ void lambda$setTransformPoints$0(TXCGPUImagePerspectiveCorrectionFilter this_, List dstPoints, List srcPoints) {
        float[] fArray = PerspectiveTransformMatrixCalculator.getPerspectiveTransformMatrix(dstPoints, srcPoints);
        float[] fArray2 = new float[9];
        for (int i2 = 0; i2 < 3; ++i2) {
            for (int i3 = 0; i3 < 3; ++i3) {
                fArray2[i3 * 3 + i2] = fArray[i2 * 3 + i3];
            }
        }
        this_.mTransformMatrix3x3 = fArray2;
    }
}

