/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.egl;

import android.opengl.EGL14;
import android.opengl.EGLConfig;
import android.opengl.EGLContext;
import android.opengl.EGLDisplay;
import android.opengl.EGLExt;
import android.opengl.EGLSurface;
import android.opengl.GLES20;
import android.view.Surface;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.egl.EGLHelper;

public class EGL14Helper
implements EGLHelper<EGLContext> {
    private final String mTAG;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private final int mWidth;
    private final int mHeight;
    private EGLConfig mEGLConfig = null;
    private EGLDisplay mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL14.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL14.EGL_NO_SURFACE;
    private static final int[] ATTRIBUTE_LIST_FOR_SURFACE = new int[]{12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12610, 1, 12344};
    private static final int[] ATTRIBUTE_LIST_FOR_OFFSCREEN_SURFACE = new int[]{12339, 1, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12610, 1, 12344};

    public static EGL14Helper createEGLSurface(EGLConfig config, EGLContext sharedContext, Surface surface, int width, int height) throws EGLException {
        EGL14Helper eGL14Helper = new EGL14Helper(width, height);
        try {
            eGL14Helper.initialize(config, sharedContext, surface);
        }
        catch (EGLException eGLException) {
            eGL14Helper.destroy();
            throw eGLException;
        }
        return eGL14Helper;
    }

    private EGL14Helper(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTAG = "EGL14Helper@" + this.hashCode();
    }

    @Override
    public void updateSurface(Object nativeWindow) throws EGLException {
        this.destroySurface();
        int[] nArray = new int[]{12344};
        this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)nativeWindow, (int[])nArray, (int)0);
        EGL14Helper.throwEGLExceptionIfFailed();
    }

    @Override
    public void makeCurrent() throws EGLException {
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) {
            EGL14Helper.throwEGLExceptionIfFailed();
        }
    }

    @Override
    public void destroySurface() {
        if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
            this.unmakeCurrent();
            EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
            this.mEGLSurface = EGL14.EGL_NO_SURFACE;
        }
    }

    @Override
    public void destroy() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
            if (this.mEGLSurface != EGL14.EGL_NO_SURFACE) {
                EGL14.eglDestroySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface);
                this.mEGLSurface = EGL14.EGL_NO_SURFACE;
            }
            if (this.mEGLContext != EGL14.EGL_NO_CONTEXT) {
                LiteavLog.i(this.mTAG, "destroy eglContext " + this.mEGLContext);
                EGL14.eglDestroyContext((EGLDisplay)this.mEGLDisplay, (EGLContext)this.mEGLContext);
                this.mEGLContext = EGL14.EGL_NO_CONTEXT;
            }
            EGL14.eglReleaseThread();
            EGL14.eglTerminate((EGLDisplay)this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL14.EGL_NO_DISPLAY;
    }

    @Override
    public void swapBuffers() throws EGLException {
        GLES20.glFinish();
        if (!EGL14.eglSwapBuffers((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface)) {
            EGL14Helper.throwEGLExceptionIfFailed();
        }
    }

    private void initialize(EGLConfig config, EGLContext sharedContext, Surface surface) throws EGLException {
        int[] nArray;
        this.mEGLDisplay = EGL14.eglGetDisplay((int)0);
        if (this.mEGLDisplay == EGL14.EGL_NO_DISPLAY) {
            LiteavLog.e(this.mTAG, "unable to get EGL14 display");
            throw new EGLException(0);
        }
        int[] nArray2 = new int[2];
        if (!EGL14.eglInitialize((EGLDisplay)this.mEGLDisplay, (int[])nArray2, (int)0, (int[])nArray2, (int)1)) {
            this.mEGLDisplay = null;
            LiteavLog.e(this.mTAG, "unable to initialize EGL14");
            throw new EGLException(0);
        }
        if (config != null) {
            this.mEGLConfig = config;
        } else {
            int[] nArray3;
            EGLConfig[] eGLConfigArray = new EGLConfig[1];
            nArray = new int[1];
            int[] nArray4 = nArray3 = surface == null ? ATTRIBUTE_LIST_FOR_OFFSCREEN_SURFACE : ATTRIBUTE_LIST_FOR_SURFACE;
            if (!EGL14.eglChooseConfig((EGLDisplay)this.mEGLDisplay, (int[])nArray3, (int)0, (EGLConfig[])eGLConfigArray, (int)0, (int)1, (int[])nArray, (int)0)) {
                throw new EGLException(0);
            }
            this.mEGLConfig = eGLConfigArray[0];
        }
        int n2 = 2;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            try {
                this.mEGLContext = EGL14Helper.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 2, sharedContext);
            }
            catch (EGLException eGLException) {
                n2 = 3;
                LiteavLog.i(this.mTAG, "failed to create EGLContext of OpenGL ES 2.0, try 3.0");
                this.mEGLContext = EGL14Helper.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 3, sharedContext);
            }
        } else {
            this.mEGLContext = EGL14Helper.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 2, sharedContext);
        }
        LiteavLog.i(this.mTAG, "create eglContext " + this.mEGLContext + " sharedContext: " + sharedContext + " version:" + n2);
        if (surface == null) {
            nArray = new int[]{12375, this.mWidth, 12374, this.mHeight, 12344};
            this.mEGLSurface = EGL14.eglCreatePbufferSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (int[])nArray, (int)0);
        } else {
            nArray = new int[]{12344};
            try {
                this.mEGLSurface = EGL14.eglCreateWindowSurface((EGLDisplay)this.mEGLDisplay, (EGLConfig)this.mEGLConfig, (Object)surface, (int[])nArray, (int)0);
            }
            catch (Throwable throwable) {
                int n3 = EGL14.eglGetError();
                throw new EGLException(n3, "", throwable);
            }
        }
        EGL14Helper.throwEGLExceptionIfFailed();
        if (!EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (EGLSurface)this.mEGLSurface, (EGLContext)this.mEGLContext)) {
            EGL14Helper.throwEGLExceptionIfFailed();
        }
    }

    private static EGLContext createEGLContext(EGLDisplay display, EGLConfig config, int clientVersion, EGLContext sharedContext) throws EGLException {
        int[] nArray = new int[]{12440, clientVersion, 12344};
        if (sharedContext == null) {
            sharedContext = EGL14.EGL_NO_CONTEXT;
        }
        EGLContext eGLContext = EGL14.eglCreateContext((EGLDisplay)display, (EGLConfig)config, (EGLContext)sharedContext, (int[])nArray, (int)0);
        EGL14Helper.throwEGLExceptionIfFailed();
        return eGLContext;
    }

    @Override
    public void unmakeCurrent() {
        if (this.mEGLDisplay != EGL14.EGL_NO_DISPLAY) {
            EGLSurface eGLSurface = EGL14.EGL_NO_SURFACE;
            EGL14.eglMakeCurrent((EGLDisplay)this.mEGLDisplay, (EGLSurface)eGLSurface, (EGLSurface)eGLSurface, (EGLContext)EGL14.EGL_NO_CONTEXT);
        }
    }

    public void setPresentationTime(long nsecs) {
        EGLExt.eglPresentationTimeANDROID((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (long)nsecs);
    }

    @Override
    public EGLContext getContext() {
        return this.mEGLContext;
    }

    @Override
    public Size getSurfaceSize() {
        int[] nArray = new int[2];
        boolean bl2 = EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (int)12375, (int[])nArray, (int)0);
        boolean bl3 = EGL14.eglQuerySurface((EGLDisplay)this.mEGLDisplay, (EGLSurface)this.mEGLSurface, (int)12374, (int[])nArray, (int)1);
        if (bl2 && bl3) {
            return new Size(nArray[0], nArray[1]);
        }
        return new Size(0, 0);
    }

    private static void throwEGLExceptionIfFailed() throws EGLException {
        int n2 = EGL14.eglGetError();
        if (n2 != 12288) {
            throw new EGLException(n2);
        }
    }
}

