/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.egl;

import android.opengl.GLES20;
import android.view.Surface;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.egl.EGLHelper;
import javax.microedition.khronos.egl.EGL10;
import javax.microedition.khronos.egl.EGLConfig;
import javax.microedition.khronos.egl.EGLContext;
import javax.microedition.khronos.egl.EGLDisplay;
import javax.microedition.khronos.egl.EGLSurface;

public class EGL10Helper
implements EGLHelper<EGLContext> {
    private final String mTag;
    private final int mWidth;
    private final int mHeight;
    private EGLDisplay mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    private EGLContext mEGLContext = EGL10.EGL_NO_CONTEXT;
    private EGLSurface mEGLSurface = EGL10.EGL_NO_SURFACE;
    private EGL10 mEGL;
    private EGLConfig mEGLConfig;
    private static final int EGL_RECORDABLE_ANDROID = 12610;
    private static final int EGL_CONTEXT_CLIENT_VERSION = 12440;
    private static final int EGL_OPENGL_ES2_BIT = 4;
    private static final int[] ATTRIBUTES_FOR_OFFSCREEN_SURFACE = new int[]{12339, 1, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12344};
    private static final int[] ATTRIBUTES_FOR_SURFACE = new int[]{12339, 4, 12324, 8, 12323, 8, 12322, 8, 12321, 8, 12325, 0, 12326, 0, 12352, 4, 12610, 1, 12344};

    public static EGL10Helper createEGLSurface(EGLConfig config, EGLContext sharedContext, Surface surface, int width, int height) throws EGLException {
        EGL10Helper eGL10Helper = new EGL10Helper(width, height);
        try {
            eGL10Helper.initialize(config, sharedContext, surface);
        }
        catch (EGLException eGLException) {
            eGL10Helper.destroy();
            throw eGLException;
        }
        return eGL10Helper;
    }

    private EGL10Helper(int width, int height) {
        this.mWidth = width;
        this.mHeight = height;
        this.mTag = "EGL10Helper@" + this.hashCode();
    }

    @Override
    public void updateSurface(Object nativeWindow) throws EGLException {
        this.destroySurface();
        this.mEGLSurface = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, nativeWindow, null);
        this.throwEGLExceptionIfFailed();
    }

    @Override
    public void swapBuffers() throws EGLException {
        GLES20.glFinish();
        if (!this.mEGL.eglSwapBuffers(this.mEGLDisplay, this.mEGLSurface)) {
            this.throwEGLExceptionIfFailed();
        }
    }

    @Override
    public void makeCurrent() throws EGLException {
        if (!this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) {
            this.throwEGLExceptionIfFailed();
        }
    }

    @Override
    public void destroySurface() throws EGLException {
        if (this.mEGLSurface != EGL10.EGL_NO_SURFACE) {
            this.unmakeCurrent();
            if (!this.mEGL.eglDestroySurface(this.mEGLDisplay, this.mEGLSurface)) {
                this.throwEGLExceptionIfFailed();
            }
            this.mEGLSurface = EGL10.EGL_NO_SURFACE;
        }
    }

    @Override
    public void destroy() throws EGLException {
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            this.unmakeCurrent();
            this.destroySurface();
            if (this.mEGLContext != EGL10.EGL_NO_CONTEXT) {
                LiteavLog.i(this.mTag, "destroy eglContext " + this.mEGLContext);
                this.mEGL.eglDestroyContext(this.mEGLDisplay, this.mEGLContext);
                this.mEGLContext = EGL10.EGL_NO_CONTEXT;
            }
            this.mEGL.eglTerminate(this.mEGLDisplay);
        }
        this.mEGLDisplay = EGL10.EGL_NO_DISPLAY;
    }

    @Override
    public void unmakeCurrent() {
        if (this.mEGLDisplay != EGL10.EGL_NO_DISPLAY) {
            EGLSurface eGLSurface = EGL10.EGL_NO_SURFACE;
            this.mEGL.eglMakeCurrent(this.mEGLDisplay, eGLSurface, eGLSurface, EGL10.EGL_NO_CONTEXT);
        }
    }

    private void initialize(EGLConfig config, EGLContext sharedContext, Surface surface) throws EGLException {
        Object[] objectArray;
        this.mEGL = (EGL10)EGLContext.getEGL();
        this.mEGLDisplay = this.mEGL.eglGetDisplay(EGL10.EGL_DEFAULT_DISPLAY);
        this.mEGL.eglInitialize(this.mEGLDisplay, new int[2]);
        if (config == null) {
            int[] nArray = new int[1];
            objectArray = new EGLConfig[1];
            int[] nArray2 = surface == null ? ATTRIBUTES_FOR_OFFSCREEN_SURFACE : ATTRIBUTES_FOR_SURFACE;
            this.mEGL.eglChooseConfig(this.mEGLDisplay, nArray2, objectArray, 1, nArray);
            this.mEGLConfig = objectArray[0];
        } else {
            this.mEGLConfig = config;
        }
        int n2 = 2;
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 18) {
            try {
                this.mEGLContext = this.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 2, sharedContext);
            }
            catch (EGLException eGLException) {
                n2 = 3;
                LiteavLog.i(this.mTag, "failed to create EGLContext of OpenGL ES 2.0, try 3.0");
                this.mEGLContext = this.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 3, sharedContext);
            }
        } else {
            this.mEGLContext = this.createEGLContext(this.mEGLDisplay, this.mEGLConfig, 2, sharedContext);
        }
        LiteavLog.i(this.mTag, "create eglContext " + this.mEGLContext + " sharedContext: " + sharedContext + " version:" + n2);
        if (surface == null) {
            objectArray = new int[]{12375, this.mWidth, 12374, this.mHeight, 12344};
            this.mEGLSurface = this.mEGL.eglCreatePbufferSurface(this.mEGLDisplay, this.mEGLConfig, (int[])objectArray);
        } else {
            try {
                this.mEGLSurface = this.mEGL.eglCreateWindowSurface(this.mEGLDisplay, this.mEGLConfig, (Object)surface, null);
            }
            catch (Throwable throwable) {
                int n3 = this.mEGL.eglGetError();
                throw new EGLException(n3, "", throwable);
            }
        }
        if (this.mEGLSurface == EGL10.EGL_NO_SURFACE) {
            this.throwEGLExceptionIfFailed();
        }
        if (!this.mEGL.eglMakeCurrent(this.mEGLDisplay, this.mEGLSurface, this.mEGLSurface, this.mEGLContext)) {
            this.throwEGLExceptionIfFailed();
        }
    }

    private EGLContext createEGLContext(EGLDisplay display, EGLConfig config, int clientVersion, EGLContext sharedContext) throws EGLException {
        int[] nArray = new int[]{12440, clientVersion, 12344};
        if (sharedContext == null) {
            sharedContext = EGL10.EGL_NO_CONTEXT;
        }
        EGLContext eGLContext = this.mEGL.eglCreateContext(display, config, sharedContext, nArray);
        this.throwEGLExceptionIfFailed();
        return eGLContext;
    }

    @Override
    public EGLContext getContext() {
        return this.mEGLContext;
    }

    @Override
    public Size getSurfaceSize() {
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        boolean bl2 = this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12375, nArray);
        boolean bl3 = this.mEGL.eglQuerySurface(this.mEGLDisplay, this.mEGLSurface, 12374, nArray2);
        if (bl2 && bl3) {
            return new Size(nArray[0], nArray2[0]);
        }
        return new Size(0, 0);
    }

    private void throwEGLExceptionIfFailed() throws EGLException {
        int n2 = this.mEGL.eglGetError();
        if (n2 != 12288) {
            throw new EGLException(n2);
        }
    }
}

