/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.videobase.chain;

import android.opengl.GLES20;
import com.tencent.liteav.base.util.l;
import com.tencent.ugc.videobase.chain.TXCGPUImageFilter;
import com.tencent.ugc.videobase.chain.TXCGPUImageMultipleInputFilter;
import com.tencent.ugc.videobase.frame.GLTexture;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class TXCGPUImageTopoSortFilter
extends TXCGPUImageFilter {
    private static final String INPUT_TEXTURE_NAME_FOR_ON_DRAW = "input-texture-name-for-on-draw";
    private final FloatBuffer mNormalCubeVerticesBuffer;
    private final FloatBuffer mNormalTextureCoordsBuffer;
    private final List<Node> mNodes = new ArrayList<Node>();
    private final Map<Node, Integer> mIndicesMap = new HashMap<Node, Integer>();
    private final Node mInitNode;
    private Node mFinalNode;
    private int[] mUsedCountOneDraw;
    private int mInputTextureId;
    private GLTexture mOutputTexture;
    private FloatBuffer mInputCubeCoordsBuffer;
    private FloatBuffer mInputTextureCoordsBuffer;

    public TXCGPUImageTopoSortFilter() {
        this.mNormalCubeVerticesBuffer = OpenGlUtils.createNormalCubeVerticesBuffer();
        this.mNormalTextureCoordsBuffer = OpenGlUtils.createTextureCoordsBuffer(l.a, false, false);
        this.mInitNode = new Node(null);
        this.mNodes.add(this.mInitNode);
    }

    protected Node getInitNode() {
        return this.mInitNode;
    }

    protected Node createNodeFromFilter(TXCGPUImageFilter filter) {
        Node node = new Node(filter);
        this.mNodes.add(node);
        return node;
    }

    @Override
    protected void onInit(GLTexturePool texturePool) {
        super.onInit(texturePool);
        for (Node node : this.mNodes) {
            if (node.filter == null) continue;
            node.filter.initialize(texturePool);
        }
        for (int i2 = 0; i2 < this.mNodes.size(); ++i2) {
            this.mIndicesMap.put(this.mNodes.get(i2), i2);
        }
        this.mFinalNode = this.findFinalNode();
        if (this.mFinalNode == null) {
            throw new RuntimeException("Directed acyclic graph can't find a final node.");
        }
        this.mUsedCountOneDraw = new int[this.mNodes.size()];
    }

    @Override
    public void onOutputSizeChanged(int width, int height) {
        super.onOutputSizeChanged(width, height);
        for (Node node : this.mNodes) {
            if (node.filter == null) continue;
            node.filter.onOutputSizeChanged(width, height);
        }
    }

    @Override
    protected void onUninit() {
        super.onUninit();
        for (Node node : this.mNodes) {
            if (node.filter == null) continue;
            node.filter.uninitialize();
        }
    }

    @Override
    public void onDraw(int inTextureId, GLTexture outTexture, FloatBuffer cubeCoordsBuffer, FloatBuffer textureCoordsBuffer) {
        if (!this.isInitialized()) {
            return;
        }
        this.runPendingOnDrawTasks();
        this.mInputTextureId = inTextureId;
        this.mOutputTexture = outTexture;
        this.mInputCubeCoordsBuffer = cubeCoordsBuffer;
        this.mInputTextureCoordsBuffer = textureCoordsBuffer;
        Arrays.fill(this.mUsedCountOneDraw, 0);
        TXCGPUImageTopoSortFilter tXCGPUImageTopoSortFilter = this;
        tXCGPUImageTopoSortFilter.doReverseDraw(tXCGPUImageTopoSortFilter.mFinalNode);
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().glTexture;
        }
    }

    private void doReverseDraw(Node node) {
        int n2;
        Object object;
        for (Object object2 : node.inputNodeMap.values()) {
            if (object2 == this.mInitNode || ((Node)object2).glTexture != null) continue;
            this.doReverseDraw((Node)object2);
        }
        if (node.filter instanceof TXCGPUImageMultipleInputFilter) {
            object = (TXCGPUImageMultipleInputFilter)node.filter;
            for (Map.Entry entry : node.inputNodeMap.entrySet()) {
                if (INPUT_TEXTURE_NAME_FOR_ON_DRAW.equals(entry.getKey())) continue;
                if (entry.getValue() == this.mInitNode) {
                    ((TXCGPUImageMultipleInputFilter)object).setInputTexture((String)entry.getKey(), this.mInputTextureId);
                    continue;
                }
                ((TXCGPUImageMultipleInputFilter)object).setInputTexture((String)entry.getKey(), ((Node)entry.getValue()).glTexture.getId());
            }
        }
        object = this.mOutputTexture;
        int n22 = this.mOutputSize.width;
        int n3 = this.mOutputSize.height;
        if (node != this.mFinalNode) {
            n22 = ((Node)node).filter.getOutputSize().width;
            n2 = ((Node)node).filter.getOutputSize().height;
            node.glTexture = this.mTexturePool.obtain(n22, n2);
            object = node.glTexture;
        }
        Node node2 = (Node)node.inputNodeMap.get(INPUT_TEXTURE_NAME_FOR_ON_DRAW);
        GLES20.glViewport((int)0, (int)0, (int)n22, (int)n2);
        if (node2 == this.mInitNode) {
            node.filter.onDraw(this.mInputTextureId, (GLTexture)object, this.mInputCubeCoordsBuffer, this.mInputTextureCoordsBuffer);
        } else {
            node.filter.onDraw(node2.glTexture.getId(), (GLTexture)object, this.mNormalCubeVerticesBuffer, this.mNormalTextureCoordsBuffer);
        }
        for (Node node3 : node.inputNodeMap.values()) {
            int n4;
            int n5 = n4 = this.mIndicesMap.get(node3).intValue();
            this.mUsedCountOneDraw[n5] = this.mUsedCountOneDraw[n5] + 1;
            if (node3.glTexture == null || this.mUsedCountOneDraw[n4] != node3.countAsInput) continue;
            node3.glTexture.release();
            node3.glTexture = null;
        }
    }

    private Node findFinalNode() {
        int n2 = this.mNodes.size();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < n2; ++i2) {
            arrayList.add(i2);
        }
        int n3 = n2;
        boolean[][] blArray = new boolean[n3][n3];
        for (int i3 = 0; i3 < this.mNodes.size(); ++i3) {
            Arrays.fill(blArray[i3], false);
        }
        for (Node object2 : this.mNodes) {
            int arrayList2 = this.mIndicesMap.get(object2);
            for (Node i5 : object2.inputNodeMap.values()) {
                blArray[this.mIndicesMap.get((Object)i5).intValue()][arrayList2] = true;
            }
        }
        Object object3 = new int[n2];
        int[] nArray = new int[n2];
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>();
        while (arrayList.size() > 1) {
            int n4;
            Arrays.fill((int[])object3, 0);
            Arrays.fill(nArray, 0);
            arrayList2.clear();
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int n5 = 0; n5 < n2; ++n5) {
                    if (!blArray[i2][n5]) continue;
                    int n6 = i2;
                    nArray[n6] = nArray[n6] + 1;
                    Object object = object3;
                    int n7 = n5;
                    object[n7] = object[n7] + true;
                }
            }
            Iterator<Object> i4 = arrayList.iterator();
            while (i4.hasNext()) {
                n4 = (Integer)i4.next();
                if (object3[n4] != false || nArray[n4] == 0) continue;
                arrayList2.add(n4);
            }
            if (arrayList2.isEmpty()) break;
            arrayList.removeAll(arrayList2);
            i4 = arrayList2.iterator();
            while (i4.hasNext()) {
                n4 = (Integer)i4.next();
                Arrays.fill(blArray[n4], false);
            }
        }
        if (arrayList.size() == 1) {
            return this.mNodes.get((Integer)arrayList.get(0));
        }
        return null;
    }

    public static class Node {
        private final TXCGPUImageFilter filter;
        private final Map<String, Node> inputNodeMap = new HashMap<String, Node>();
        private GLTexture glTexture = null;
        private int countAsInput = 0;

        private Node(TXCGPUImageFilter filter) {
            this.filter = filter;
        }

        public void setInputForOnDraw(Node inputNode) {
            ++inputNode.countAsInput;
            this.inputNodeMap.put(TXCGPUImageTopoSortFilter.INPUT_TEXTURE_NAME_FOR_ON_DRAW, inputNode);
        }

        public void addExtraInput(String inputTextureName, Node inputNode) {
            ++inputNode.countAsInput;
            this.inputNodeMap.put(inputTextureName, inputNode);
        }
    }
}

