/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.opengl.GLES20;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.view.Surface;
import android.view.TextureView;
import com.tencent.liteav.base.b.a;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.i;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.base.util.m;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.videobase.DisplayTarget;
import com.tencent.ugc.renderer.PostProcessor;
import com.tencent.ugc.renderer.RenderViewHelperInterface;
import com.tencent.ugc.renderer.TextureViewRenderHelper;
import com.tencent.ugc.renderer.VideoRenderInterface;
import com.tencent.ugc.renderer.VideoRenderListener;
import com.tencent.ugc.renderer.aa;
import com.tencent.ugc.renderer.ab;
import com.tencent.ugc.renderer.ac;
import com.tencent.ugc.renderer.n;
import com.tencent.ugc.renderer.o;
import com.tencent.ugc.renderer.p;
import com.tencent.ugc.renderer.q;
import com.tencent.ugc.renderer.r;
import com.tencent.ugc.renderer.s;
import com.tencent.ugc.renderer.t;
import com.tencent.ugc.renderer.u;
import com.tencent.ugc.renderer.v;
import com.tencent.ugc.renderer.w;
import com.tencent.ugc.renderer.x;
import com.tencent.ugc.renderer.y;
import com.tencent.ugc.renderer.z;
import com.tencent.ugc.videobase.base.TakeSnapshotListener;
import com.tencent.ugc.videobase.egl.EGLCore;
import com.tencent.ugc.videobase.egl.EGLException;
import com.tencent.ugc.videobase.frame.FrameMetaData;
import com.tencent.ugc.videobase.frame.GLFrameBuffer;
import com.tencent.ugc.videobase.frame.GLTexturePool;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.frame.PixelFrameRenderer;
import com.tencent.ugc.videobase.utils.BitmapUtils;
import com.tencent.ugc.videobase.utils.MemoryAllocator;
import com.tencent.ugc.videobase.utils.OpenGlUtils;
import com.tencent.ugc.videobase.utils.RingFrameQueue;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.List;

public class VideoRenderer
extends VideoRenderInterface
implements RenderViewHelperInterface.RenderViewListener {
    private static final int RENDER_QUEUE_MAX_SIZE = 1;
    private static final int DESTROY_TIMEOUT_MS = 2000;
    private final String mTAG = "VideoRenderer_" + this.hashCode();
    private final Handler mUIHandler = new Handler(Looper.getMainLooper());
    private final CustomHandler mRenderHandler;
    private final m mSequenceTaskRunner;
    private final m mSnapshotTaskRunner = new m(5);
    private final b mThrottlers = new b();
    private final Size mLastSurfaceSize = new Size();
    private Surface mSurface = null;
    private boolean mIsNeedReleaseSurface = false;
    private Object mSharedContext;
    private EGLCore mEGLCore = null;
    private final GLFrameBuffer mGLFrameBuffer = new GLFrameBuffer();
    private PixelFrameRenderer mPixelFrameRender;
    private final RingFrameQueue mRenderFrameQueue = new RingFrameQueue(1);
    private GLTexturePool mGLTexturePool;
    private GLConstants.GLScaleType mScaleType = GLConstants.GLScaleType.a;
    private l mRenderRotation = l.a;
    private boolean mIsHorizontalMirror = false;
    private boolean mIsVerticalMirror = false;
    private DisplayTarget mDisplayTarget;
    private RenderViewHelperInterface mRenderViewHelper;
    private final Size mCaptureRealFrameSize = new Size();
    private volatile boolean mIsStarted = false;
    private boolean mIsReceivedFirstFrame = false;
    private boolean mIsHDR = false;
    private final Size mVideoSizeWithRenderParams = new Size();
    private TakeSnapshotListener mSnapshotListener;
    private VideoRenderListener mVideoRenderListener;
    private boolean mIsRenderViewChanged = false;
    private Bitmap mPendingRedrawBitmap;
    private final a mCheckViewStatusThrottler = new a(5000L);
    private PostProcessor mPostProcessor;
    private List<PointF> mPerspectiveCorrectionSrcPoints;
    private List<PointF> mPerspectiveCorrectionDstPoints;

    public VideoRenderer(Looper looper) {
        this.mRenderHandler = new CustomHandler(looper);
        this.mSequenceTaskRunner = null;
    }

    public VideoRenderer(m taskRunner) {
        this.mRenderHandler = null;
        this.mSequenceTaskRunner = taskRunner;
    }

    @Override
    public void start(VideoRenderListener listener) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(n.a(videoRenderer, listener));
    }

    @Override
    public void stop(boolean clearLastImage) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(v.a(videoRenderer, clearLastImage));
    }

    @Override
    public void setDisplayView(DisplayTarget displayTarget, boolean clearLastImage) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(w.a(videoRenderer, displayTarget, clearLastImage));
    }

    @Override
    public void takeSnapshot(TakeSnapshotListener listener) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(x.a(videoRenderer, listener));
    }

    @Override
    public void setPerspectiveCorrectionPoints(List<PointF> srcPoints, List<PointF> dstPoints) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(y.a(videoRenderer, srcPoints, dstPoints));
    }

    @Override
    public void setScaleType(GLConstants.GLScaleType scaleType) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(z.a(videoRenderer, scaleType));
    }

    @Override
    public void setRenderRotation(l rotation) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(aa.a(videoRenderer, rotation));
    }

    @Override
    public void setHorizontalMirror(boolean mirror) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(ab.a(videoRenderer, mirror));
    }

    @Override
    public void setVerticalMirror(boolean mirror) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(ac.a(videoRenderer, mirror));
    }

    @Override
    public void renderFrame(PixelFrame pixelFrame) {
        if (!this.mIsStarted) {
            return;
        }
        if (pixelFrame == null) {
            LiteavLog.w(this.mTAG, "renderFrame pixelFrame is null!");
            return;
        }
        if (!this.mIsReceivedFirstFrame) {
            this.mIsReceivedFirstFrame = true;
            LiteavLog.d(this.mTAG, "VideoRender receive first frame!");
        }
        if (pixelFrame.getGLContext() != null) {
            GLES20.glFinish();
        }
        this.mRenderFrameQueue.push(pixelFrame);
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(o.a(videoRenderer));
    }

    public void setHDRRender(boolean isHDR) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(p.a(videoRenderer, isHDR));
    }

    private void runOnRenderThread(Runnable task) {
        if (this.mSequenceTaskRunner != null) {
            this.mSequenceTaskRunner.a(task);
            return;
        }
        if (Looper.myLooper() == this.mRenderHandler.getLooper()) {
            task.run();
            return;
        }
        this.mRenderHandler.post(task);
    }

    private void runOnRenderThreadAndWaitDone(Runnable task, long timeout) {
        if (this.mSequenceTaskRunner != null) {
            this.mSequenceTaskRunner.a(task, timeout);
            return;
        }
        if (Looper.myLooper() == this.mRenderHandler.getLooper()) {
            task.run();
            return;
        }
        this.mRenderHandler.runAndWaitDone(task, timeout);
    }

    private void initializeEGL(Object sharedContext) {
        if (this.mSurface == null) {
            LiteavLog.e(this.mThrottlers.a("initGLNoSurface"), this.mTAG, "Initialize EGL failed because surface is null", new Object[0]);
            return;
        }
        try {
            LiteavLog.i(this.mThrottlers.a("initGL"), this.mTAG, "initializeEGL surface=" + this.mSurface + ",size=" + this.mLastSurfaceSize, new Object[0]);
            this.mEGLCore = new EGLCore();
            this.mEGLCore.initialize(sharedContext, this.mSurface, this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
            this.mSharedContext = sharedContext;
            this.mEGLCore.makeCurrent();
            if (this.mGLTexturePool == null) {
                this.mGLTexturePool = new GLTexturePool();
            }
            this.mGLFrameBuffer.initialize();
            return;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("initGLError"), this.mTAG, "initializeEGL failed.", eGLException);
            this.mEGLCore = null;
            return;
        }
    }

    private void uninitializeEGL() {
        if (this.mEGLCore == null) {
            return;
        }
        LiteavLog.i(this.mThrottlers.a("uninitGL"), this.mTAG, "uninitializeEGL %d %s", this.mSurface != null ? this.mSurface.hashCode() : 0, this.mLastSurfaceSize);
        try {
            this.mEGLCore.makeCurrent();
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentError"), this.mTAG, "uninitializeEGL EGLCore makeCurrent failed.".concat(String.valueOf(eGLException)), new Object[0]);
        }
        this.uninitializePostProcessor();
        this.uninitializePixelFrameRender();
        this.mGLFrameBuffer.uninitialize();
        if (this.mGLTexturePool != null) {
            this.mGLTexturePool.evictAll();
            this.mGLTexturePool.destroy();
            this.mGLTexturePool = null;
        }
        EGLCore.destroy(this.mEGLCore);
        this.mEGLCore = null;
    }

    private void setDisplayViewInternal(DisplayTarget displayTarget, boolean clearLastImage) {
        LiteavLog.i(this.mTAG, "setDisplayViewInternal=" + displayTarget + ",clearLastImage=" + clearLastImage);
        boolean bl2 = CommonUtil.equals(this.mDisplayTarget, displayTarget);
        if (bl2 && displayTarget != null && this.mRenderViewHelper != null) {
            LiteavLog.w(this.mTAG, "view is equal and RenderViewHelper is created.");
            return;
        }
        if (!bl2) {
            this.mIsRenderViewChanged = true;
            if (this.mDisplayTarget != null && clearLastImage) {
                this.mDisplayTarget.hideAll();
            }
        }
        this.destroyRenderViewHelper(clearLastImage);
        this.mDisplayTarget = displayTarget;
        if (displayTarget == null) {
            return;
        }
        displayTarget.showAll();
        this.mRenderViewHelper = RenderViewHelperInterface.create(displayTarget, this);
    }

    private void renderFrameInternal(PixelFrame pixelFrame) {
        this.mCaptureRealFrameSize.set(pixelFrame.getWidth(), pixelFrame.getHeight());
        FrameMetaData frameMetaData = pixelFrame.getMetaData();
        if (frameMetaData != null) {
            this.mRenderRotation = frameMetaData.getRenderRotation();
            this.mIsHorizontalMirror = frameMetaData.isRenderMirrorHorizontal();
            this.mIsVerticalMirror = frameMetaData.isRenderMirrorVertical();
            this.mCaptureRealFrameSize.set(frameMetaData.getCaptureRealSize());
        }
        if (this.mCheckViewStatusThrottler.a() && this.mRenderViewHelper != null) {
            this.mRenderViewHelper.checkViewAvailability();
        }
        if (this.mIsHDR) {
            if (this.mRenderViewHelper != null) {
                this.mRenderViewHelper.updateVideoFrameInfo(this.mScaleType, pixelFrame.getWidth(), pixelFrame.getHeight(), this.mIsHDR);
            }
            this.notifyFrameRenderResult(pixelFrame, VideoRenderListener.RenderResult.RENDER_WITH_HDR);
            return;
        }
        if (this.mRenderViewHelper == null) {
            this.notifyFrameRenderResult(pixelFrame, VideoRenderListener.RenderResult.RENDER_WITHOUT_VIEW);
            return;
        }
        if (!this.makeCurrentForFrame(pixelFrame)) {
            this.notifyFrameRenderResult(pixelFrame, VideoRenderListener.RenderResult.RENDER_FAILED);
            LiteavLog.e(this.mThrottlers.a("makeCurrent"), this.mTAG, "make current failed.", new Object[0]);
            return;
        }
        this.updateSurfaceSize();
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        this.applyRenderParamsToPixelFrame(pixelFrame2, this.mIsHorizontalMirror, this.mIsVerticalMirror, this.mRenderRotation);
        this.mVideoSizeWithRenderParams.width = pixelFrame2.getWidth();
        this.mVideoSizeWithRenderParams.height = pixelFrame2.getHeight();
        this.renderPixelFrameToSurface(pixelFrame2, this.mScaleType);
        if (this.mSnapshotListener != null) {
            OpenGlUtils.bindFramebuffer(36160, 0);
            VideoRenderer videoRenderer = this;
            videoRenderer.snapshotVideoFrameFromFrameBuffer(videoRenderer.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        }
        if (this.swapBuffers() && OpenGlUtils.getGLErrorCount() <= 0) {
            this.notifyFrameRenderResult(pixelFrame, VideoRenderListener.RenderResult.RENDER_ON_VIEW);
            this.notifyFirstFrameRenderToView(pixelFrame);
            return;
        }
        this.notifyFrameRenderResult(pixelFrame, VideoRenderListener.RenderResult.RENDER_FAILED);
        LiteavLog.e(this.mThrottlers.a("renderFailed"), this.mTAG, "render frame failed.", new Object[0]);
    }

    private void applyRenderParamsToPixelFrame(PixelFrame frame, boolean isHorizontalMirror, boolean isVerticalMirror, l renderRotation) {
        PixelFrame pixelFrame = frame;
        pixelFrame.setRotation(l.a((pixelFrame.getRotation().mValue + renderRotation.mValue) % 360));
        if (isHorizontalMirror) {
            PixelFrame pixelFrame2 = frame;
            pixelFrame2.setMirrorHorizontal(!pixelFrame2.isMirrorHorizontal());
        }
        if (isVerticalMirror) {
            PixelFrame pixelFrame3 = frame;
            pixelFrame3.setMirrorVertical(!pixelFrame3.isMirrorVertical());
        }
        if (renderRotation == l.b || renderRotation == l.d) {
            int n2 = frame.getWidth();
            PixelFrame pixelFrame4 = frame;
            pixelFrame4.setWidth(pixelFrame4.getHeight());
            frame.setHeight(n2);
        }
        PixelFrame pixelFrame5 = frame;
        pixelFrame5.setMirrorVertical(!pixelFrame5.isMirrorVertical());
        if (frame.getRotation() != l.a && frame.getRotation() != l.c) {
            PixelFrame pixelFrame6 = frame;
            pixelFrame6.setRotation(l.a((pixelFrame6.getRotation().mValue + l.c.mValue) % 360));
        }
    }

    private void updateSurfaceSize() {
        if (this.mEGLCore == null) {
            return;
        }
        Size size = this.mEGLCore.getSurfaceSize();
        if (this.mLastSurfaceSize.equals(size)) {
            return;
        }
        LiteavLog.i(this.mThrottlers.a("updateSurfaceSize"), this.mTAG, "surface size changed,old size=" + this.mLastSurfaceSize + ",new size=" + size, new Object[0]);
        this.mLastSurfaceSize.set(size);
        if (this.mVideoRenderListener != null) {
            this.mVideoRenderListener.onRenderTargetSizeChanged(this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        }
    }

    private void notifyFirstFrameRenderToView(PixelFrame frame) {
        if (this.mIsRenderViewChanged) {
            this.mIsRenderViewChanged = false;
        }
    }

    private void notifyFrameRenderResult(PixelFrame frame, VideoRenderListener.RenderResult result) {
        if (this.mVideoRenderListener != null) {
            this.mVideoRenderListener.onRenderFrame(frame, result);
        }
    }

    private boolean makeCurrentForFrame(PixelFrame frame) {
        Object object = frame.getGLContext();
        if (this.mEGLCore == null || object != null && !CommonUtil.equals(this.mSharedContext, object)) {
            this.uninitializeEGL();
            this.initializeEGL(frame.getGLContext());
        }
        if (this.mEGLCore == null) {
            return false;
        }
        try {
            this.mEGLCore.makeCurrent();
            return true;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("makeCurrentForFrameError"), this.mTAG, "EGLCore makeCurrent failed.".concat(String.valueOf(eGLException)), new Object[0]);
            return false;
        }
    }

    private boolean swapBuffers() {
        try {
            this.mEGLCore.swapBuffers();
            return true;
        }
        catch (EGLException eGLException) {
            LiteavLog.e(this.mThrottlers.a("swapBuffers"), this.mTAG, "EGLCore swapBuffers failed.".concat(String.valueOf(eGLException)), new Object[0]);
            return false;
        }
    }

    private void renderPixelFrameToSurface(PixelFrame frame, GLConstants.GLScaleType scaleType) {
        if (this.mRenderViewHelper != null) {
            this.mRenderViewHelper.updateVideoFrameInfo(this.mScaleType, this.mVideoSizeWithRenderParams.getWidth(), this.mVideoSizeWithRenderParams.getHeight(), this.mIsHDR);
        }
        if (!this.mLastSurfaceSize.isValid()) {
            return;
        }
        GLConstants.GLScaleType gLScaleType = this.mRenderViewHelper instanceof TextureViewRenderHelper ? GLConstants.GLScaleType.c : scaleType;
        VideoRenderer videoRenderer = this;
        if (videoRenderer.isPerspectiveCorrectionPointsValid(videoRenderer.mPerspectiveCorrectionSrcPoints, this.mPerspectiveCorrectionDstPoints)) {
            this.renderPixelFrameWithPostProcess(frame, gLScaleType);
            return;
        }
        this.renderPixelFrameWithoutPostProcess(frame, gLScaleType);
    }

    private void renderPixelFrameWithPostProcess(PixelFrame frame, GLConstants.GLScaleType scaleType) {
        if (this.mPostProcessor == null) {
            this.mPostProcessor = new PostProcessor(this.mGLTexturePool, this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
            this.mPostProcessor.setPerspectiveCorrectionPoints(this.mPerspectiveCorrectionSrcPoints, this.mPerspectiveCorrectionDstPoints);
        }
        if (this.mRenderViewHelper != null) {
            this.mPostProcessor.setRenderViewTransformMatrix(this.mRenderViewHelper.getTransformMatrix(this.mLastSurfaceSize.width, this.mLastSurfaceSize.height));
        }
        this.mPostProcessor.setOutputSize(this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        this.mPostProcessor.processFrame(frame, scaleType);
    }

    private void renderPixelFrameWithoutPostProcess(PixelFrame frame, GLConstants.GLScaleType scaleType) {
        OpenGlUtils.glViewport(0, 0, this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        if (this.mPixelFrameRender == null) {
            LiteavLog.i(this.mTAG, "create PixelFrameRenderer, surfaceSize=" + this.mLastSurfaceSize);
            this.mPixelFrameRender = new PixelFrameRenderer(this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        }
        this.mPixelFrameRender.setOutputSize(this.mLastSurfaceSize.width, this.mLastSurfaceSize.height);
        this.mPixelFrameRender.renderFrame(frame, scaleType, null);
    }

    private void snapshotVideoFrameFromFrameBuffer(int width, int height) {
        TakeSnapshotListener takeSnapshotListener = this.mSnapshotListener;
        if (takeSnapshotListener == null) {
            return;
        }
        this.mSnapshotListener = null;
        ByteBuffer byteBuffer = MemoryAllocator.allocateDirectBuffer(width * height * 4);
        if (byteBuffer == null) {
            LiteavLog.e(this.mTAG, "snapshotVideoFrameFromFrameBuffer, allocate direct buffer failed.");
            takeSnapshotListener.onComplete(null);
            return;
        }
        byteBuffer.order(ByteOrder.nativeOrder());
        byteBuffer.position(0);
        GLES20.glReadPixels((int)0, (int)0, (int)width, (int)height, (int)6408, (int)5121, (Buffer)byteBuffer);
        RenderViewHelperInterface renderViewHelperInterface = this.mRenderViewHelper;
        this.mUIHandler.post(q.a(this, renderViewHelperInterface, byteBuffer, width, height, takeSnapshotListener));
    }

    private void notifySnapshotCompleted(ByteBuffer buffer, int width, int height, Matrix matrix, TakeSnapshotListener listener) {
        try {
            buffer.position(0);
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.copyPixelsFromBuffer((Buffer)buffer);
            Matrix matrix2 = matrix == null ? new Matrix() : matrix;
            matrix2.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
            bitmap = BitmapUtils.createBitmap(bitmap, matrix2, true);
            listener.onComplete(bitmap);
            return;
        }
        catch (Throwable throwable) {
            LiteavLog.e(this.mTAG, "build snapshot bitmap failed.", throwable);
            listener.onComplete(null);
            return;
        }
    }

    private void updateSurface(Surface surface, boolean isNeedReleaseSurface) {
        if (i.a(this.mSurface, surface)) {
            LiteavLog.d(this.mTAG, "updateSurface same surface!");
            return;
        }
        this.uninitializeEGL();
        if (this.mIsNeedReleaseSurface && this.mSurface != null) {
            this.mSurface.release();
        }
        if (this.mSurface != surface && this.mVideoRenderListener != null) {
            this.mVideoRenderListener.onRenderSurfaceChanged(surface);
        }
        this.mSurface = surface;
        if (this.mSurface == null) {
            this.mLastSurfaceSize.set(0, 0);
        }
        this.mIsNeedReleaseSurface = isNeedReleaseSurface;
    }

    private void destroyRenderViewHelper(boolean clearLastImage) {
        if (this.mRenderViewHelper != null) {
            this.mRenderViewHelper.release(clearLastImage);
            this.mRenderViewHelper = null;
        }
    }

    @Override
    public void onSurfaceChanged(Surface surface, boolean isNeedRelease) {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(r.a(videoRenderer, surface, isNeedRelease));
    }

    @Override
    public void onRequestRedraw(Bitmap bitmap) {
        this.updatePendingRedrawBitmap(bitmap);
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThread(s.a(videoRenderer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bitmap updatePendingRedrawBitmap(Bitmap bitmap) {
        VideoRenderer videoRenderer = this;
        synchronized (videoRenderer) {
            Bitmap bitmap2 = this.mPendingRedrawBitmap;
            this.mPendingRedrawBitmap = bitmap;
            return bitmap2;
        }
    }

    @Override
    public void onSurfaceDestroy() {
        VideoRenderer videoRenderer = this;
        videoRenderer.runOnRenderThreadAndWaitDone(t.a(videoRenderer), 2000L);
    }

    private boolean isPerspectiveCorrectionPointsValid(List<PointF> srcPoints, List<PointF> dstPoints) {
        return srcPoints != null && srcPoints.size() == 4 && dstPoints != null && dstPoints.size() == 4;
    }

    private void uninitializePixelFrameRender() {
        if (this.mPixelFrameRender != null) {
            this.mPixelFrameRender.uninitialize();
            this.mPixelFrameRender = null;
        }
    }

    private void uninitializePostProcessor() {
        if (this.mPostProcessor == null) {
            return;
        }
        this.mPostProcessor.uninitialize();
        this.mPostProcessor = null;
    }

    static /* synthetic */ void lambda$onSurfaceDestroy$15(VideoRenderer this_) {
        LiteavLog.i(this_.mTAG, "onSurfaceDestroy " + this_.mSurface);
        this_.updateSurface(null, this_.mIsNeedReleaseSurface);
    }

    static /* synthetic */ void lambda$onRequestRedraw$14(VideoRenderer this_) {
        Bitmap bitmap = this_.updatePendingRedrawBitmap(null);
        if (bitmap == null) {
            return;
        }
        PixelFrame pixelFrame = PixelFrame.createFromBitmap(bitmap);
        if (pixelFrame == null) {
            return;
        }
        if (!this_.makeCurrentForFrame(pixelFrame)) {
            return;
        }
        this_.updateSurfaceSize();
        pixelFrame.setMirrorVertical(true);
        this_.renderPixelFrameToSurface(pixelFrame, this_.mScaleType);
        this_.swapBuffers();
    }

    static /* synthetic */ void lambda$onSurfaceChanged$13(VideoRenderer this_, Surface surface, boolean isNeedRelease) {
        LiteavLog.i(this_.mTAG, "onSurfaceChanged surface: %s, oldSurface: %s, isNeedRelease: %b", surface, this_.mSurface, isNeedRelease);
        this_.updateSurface(surface, isNeedRelease);
    }

    static /* synthetic */ void lambda$snapshotVideoFrameFromFrameBuffer$12(VideoRenderer this_, RenderViewHelperInterface renderViewHelper, ByteBuffer buffer, int width, int height, TakeSnapshotListener listener) {
        TextureView textureView = null;
        if (renderViewHelper instanceof TextureViewRenderHelper) {
            textureView = ((TextureViewRenderHelper)renderViewHelper).getTextureView();
        }
        Matrix matrix = textureView == null ? null : textureView.getTransform(new Matrix());
        this_.mSnapshotTaskRunner.a(u.a(this_, buffer, width, height, matrix, listener));
    }

    static /* synthetic */ void lambda$null$11(VideoRenderer this_, ByteBuffer buffer, int width, int height, Matrix matrix, TakeSnapshotListener listener) {
        this_.notifySnapshotCompleted(buffer, width, height, matrix, listener);
    }

    static /* synthetic */ void lambda$setHDRRender$10(VideoRenderer this_, boolean isHDR) {
        this_.mIsHDR = isHDR;
    }

    static /* synthetic */ void lambda$renderFrame$9(VideoRenderer this_) {
        PixelFrame pixelFrame = this_.mRenderFrameQueue.poll();
        if (pixelFrame == null) {
            LiteavLog.d(this_.mTAG, "renderFrameInternal pixelFrame is null!");
            return;
        }
        this_.renderFrameInternal(pixelFrame);
        pixelFrame.release();
    }

    static /* synthetic */ void lambda$setVerticalMirror$8(VideoRenderer this_, boolean mirror) {
        if (this_.mIsVerticalMirror != mirror) {
            LiteavLog.i(this_.mTAG, "setVerticalMirror ".concat(String.valueOf(mirror)));
        }
        this_.mIsVerticalMirror = mirror;
    }

    static /* synthetic */ void lambda$setHorizontalMirror$7(VideoRenderer this_, boolean mirror) {
        if (this_.mIsHorizontalMirror != mirror) {
            LiteavLog.i(this_.mTAG, "setHorizontalMirror ".concat(String.valueOf(mirror)));
        }
        this_.mIsHorizontalMirror = mirror;
    }

    static /* synthetic */ void lambda$setRenderRotation$6(VideoRenderer this_, l rotation) {
        if (this_.mRenderRotation != rotation) {
            LiteavLog.i(this_.mTAG, "setRenderRotation ".concat(String.valueOf((Object)rotation)));
            this_.mRenderRotation = rotation;
        }
    }

    static /* synthetic */ void lambda$setScaleType$5(VideoRenderer this_, GLConstants.GLScaleType scaleType) {
        if (this_.mScaleType != scaleType) {
            LiteavLog.i(this_.mTAG, "setScaleType ".concat(String.valueOf((Object)scaleType)));
            this_.mScaleType = scaleType;
        }
    }

    static /* synthetic */ void lambda$setPerspectiveCorrectionPoints$4(VideoRenderer this_, List srcPoints, List dstPoints) {
        this_.mPerspectiveCorrectionSrcPoints = srcPoints;
        this_.mPerspectiveCorrectionDstPoints = dstPoints;
        if (!this_.isPerspectiveCorrectionPointsValid(srcPoints, dstPoints)) {
            this_.uninitializePostProcessor();
            return;
        }
        if (this_.mPostProcessor != null) {
            this_.mPostProcessor.setPerspectiveCorrectionPoints(srcPoints, dstPoints);
        }
    }

    static /* synthetic */ void lambda$takeSnapshot$3(VideoRenderer this_, TakeSnapshotListener listener) {
        LiteavLog.i(this_.mTAG, "takeSnapshot ");
        this_.mSnapshotListener = listener;
    }

    static /* synthetic */ void lambda$setDisplayView$2(VideoRenderer this_, DisplayTarget displayTarget, boolean clearLastImage) {
        this_.setDisplayViewInternal(displayTarget, clearLastImage);
    }

    static /* synthetic */ void lambda$stop$1(VideoRenderer this_, boolean clearLastImage) {
        LiteavLog.i(this_.mTAG, "Stop,clearLastImage=".concat(String.valueOf(clearLastImage)));
        if (!this_.mIsStarted) {
            LiteavLog.w(this_.mTAG, "renderer is not started!");
            return;
        }
        this_.mIsStarted = false;
        this_.mSnapshotListener = null;
        this_.destroyRenderViewHelper(clearLastImage);
        if (this_.mDisplayTarget != null && clearLastImage) {
            this_.mDisplayTarget.hideAll();
        }
        this_.mRenderFrameQueue.evictAll();
        this_.uninitializeEGL();
        if (this_.mIsNeedReleaseSurface && this_.mSurface != null) {
            this_.mSurface.release();
            this_.mIsNeedReleaseSurface = false;
        }
        this_.mSurface = null;
        this_.mLastSurfaceSize.set(0, 0);
        this_.mCaptureRealFrameSize.set(0, 0);
        this_.mIsReceivedFirstFrame = false;
    }

    static /* synthetic */ void lambda$start$0(VideoRenderer this_, VideoRenderListener listener) {
        LiteavLog.i(this_.mTAG, "Start");
        if (this_.mIsStarted) {
            LiteavLog.w(this_.mTAG, "renderer is started!");
            return;
        }
        this_.mIsStarted = true;
        this_.mVideoRenderListener = listener;
        if (this_.mSurface != null && this_.mVideoRenderListener != null) {
            this_.mVideoRenderListener.onRenderSurfaceChanged(this_.mSurface);
        }
        if (this_.mDisplayTarget != null) {
            VideoRenderer videoRenderer = this_;
            videoRenderer.setDisplayViewInternal(videoRenderer.mDisplayTarget, true);
        }
        this_.mCheckViewStatusThrottler.a = SystemClock.elapsedRealtime();
    }
}

