/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.renderer;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Looper;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.rtmp.ui.TXCloudVideoView;
import com.tencent.ugc.renderer.RenderViewHelperInterface;
import com.tencent.ugc.renderer.d;
import com.tencent.ugc.renderer.e;
import com.tencent.ugc.renderer.f;
import com.tencent.ugc.renderer.g;

public class SurfaceViewRenderHelper
extends RenderViewHelperInterface {
    private final String mTAG = "SurfaceViewRenderHelper_" + this.hashCode();
    private final CustomHandler mUIHandler = new CustomHandler(Looper.getMainLooper());
    private final RenderViewHelperInterface.RenderViewListener mListener;
    private SurfaceView mSurfaceView;
    private final Size mFrameSize = new Size();
    private final Size mLastViewSize = new Size();
    private GLConstants.GLScaleType mScaleType = null;
    private boolean mIsHDR = false;
    private final SurfaceHolder.Callback mSurfaceViewListener = new SurfaceHolder.Callback(){

        public final void surfaceCreated(SurfaceHolder holder) {
            if (holder != null) {
                Rect rect = holder.getSurfaceFrame();
                LiteavLog.i(SurfaceViewRenderHelper.this.mTAG, "surfaceCreated,Size(%dx%d)", rect.width(), rect.height());
                SurfaceViewRenderHelper.this.notifySurfaceChanged(holder.getSurface());
            }
        }

        public final void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
            if (holder != null) {
                LiteavLog.i(SurfaceViewRenderHelper.this.mTAG, "surfaceChanged,format=%d,Size(%dx%d)", format, width, height);
                SurfaceViewRenderHelper.this.notifySurfaceChanged(holder.getSurface());
            }
        }

        public final void surfaceDestroyed(SurfaceHolder holder) {
            LiteavLog.i(SurfaceViewRenderHelper.this.mTAG, "surfaceDestroyed");
            SurfaceViewRenderHelper.this.notifySurfaceDestroy();
        }
    };
    private final View.OnLayoutChangeListener mOnLayoutChangeListener = new View.OnLayoutChangeListener(){

        public final void onLayoutChange(View v2, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (SurfaceViewRenderHelper.this.mIsHDR && (((SurfaceViewRenderHelper)SurfaceViewRenderHelper.this).mLastViewSize.width != v2.getWidth() || ((SurfaceViewRenderHelper)SurfaceViewRenderHelper.this).mLastViewSize.height != v2.getHeight())) {
                SurfaceViewRenderHelper.this.updateViewLayoutForHDR();
            }
        }
    };

    public SurfaceViewRenderHelper(SurfaceView surfaceView, RenderViewHelperInterface.RenderViewListener listener) {
        this.mListener = listener;
        if (surfaceView == null) {
            LiteavLog.w(this.mTAG, "surfaceView is null.");
            return;
        }
        this.mSurfaceView = surfaceView;
        this.mUIHandler.post(d.a(this, surfaceView));
    }

    @Override
    public void release(boolean clearLastImage) {
        this.mUIHandler.post(e.a(this));
    }

    @Override
    public Matrix getTransformMatrix(int width, int height) {
        Matrix matrix = new Matrix();
        matrix.postScale(1.0f, -1.0f, (float)width / 2.0f, (float)height / 2.0f);
        return matrix;
    }

    @Override
    public void checkViewAvailability() {
        this.mUIHandler.post(f.a(this));
    }

    @Override
    public void updateVideoFrameInfo(GLConstants.GLScaleType scaleType, int width, int height, boolean isHDR) {
        if (this.mScaleType == scaleType && this.mIsHDR == isHDR && this.mFrameSize.width == width && this.mFrameSize.height == height) {
            return;
        }
        this.mIsHDR = isHDR;
        this.mScaleType = scaleType;
        this.mFrameSize.set(width, height);
        if (this.mIsHDR) {
            this.mUIHandler.runOrPost(g.a(this));
        }
    }

    @Override
    public boolean isUsingTextureView() {
        return false;
    }

    private void notifySurfaceChanged(Surface surface) {
        if (this.mListener != null) {
            this.mListener.onSurfaceChanged(surface, false);
        }
    }

    private void notifySurfaceDestroy() {
        if (this.mListener != null) {
            this.mListener.onSurfaceDestroy();
        }
    }

    private void updateViewLayoutForHDR() {
        double d2;
        if (this.mSurfaceView == null || !(this.mSurfaceView.getParent() instanceof TXCloudVideoView)) {
            return;
        }
        TXCloudVideoView tXCloudVideoView = (TXCloudVideoView)this.mSurfaceView.getParent();
        Size size = new Size(tXCloudVideoView.getWidth(), tXCloudVideoView.getHeight());
        if (!this.mFrameSize.isValid() || !size.isValid()) {
            return;
        }
        if (!this.mLastViewSize.isValid()) {
            tXCloudVideoView.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        }
        this.mLastViewSize.set(size);
        double d3 = 1.0;
        double d4 = 1.0;
        double d5 = size.aspectRatio();
        double d6 = this.mFrameSize.aspectRatio();
        if (d2 < d5) {
            if (this.mScaleType == GLConstants.GLScaleType.b) {
                d3 = d6 / d5;
            } else if (this.mScaleType == GLConstants.GLScaleType.a) {
                d4 = d5 / d6;
            }
        } else if (this.mScaleType == GLConstants.GLScaleType.b) {
            d4 = d5 / d6;
        } else if (this.mScaleType == GLConstants.GLScaleType.a) {
            d3 = d6 / d5;
        }
        ViewGroup.LayoutParams layoutParams = this.mSurfaceView.getLayoutParams();
        this.mSurfaceView.getLayoutParams().width = (int)((double)size.getWidth() * d3);
        layoutParams.height = (int)((double)size.getHeight() * d4);
        if (layoutParams instanceof FrameLayout.LayoutParams) {
            ((FrameLayout.LayoutParams)layoutParams).gravity = 17;
        }
        this.mSurfaceView.setLayoutParams(layoutParams);
        LiteavLog.i(this.mTAG, "adjust view size to %d*%d", layoutParams.width, layoutParams.height);
    }

    static /* synthetic */ void lambda$updateVideoFrameInfo$3(SurfaceViewRenderHelper this_) {
        this_.updateViewLayoutForHDR();
    }

    static /* synthetic */ void lambda$checkViewAvailability$2(SurfaceViewRenderHelper this_) {
        if (this_.mSurfaceView == null) {
            LiteavLog.i(this_.mTAG, "view is not available when surfaceView is null");
            return;
        }
        Surface surface = this_.mSurfaceView.getHolder().getSurface();
        boolean bl2 = surface != null && surface.isValid();
        if (!(bl2 && this_.mSurfaceView.getWidth() != 0 && this_.mSurfaceView.getHeight() != 0 && this_.mSurfaceView.isShown())) {
            LiteavLog.i(this_.mTAG, "%s is not available when isShown:%b, surface isValid:%b", this_.mSurfaceView, this_.mSurfaceView.isShown(), bl2);
        }
    }

    static /* synthetic */ void lambda$release$1(SurfaceViewRenderHelper this_) {
        LiteavLog.i(this_.mTAG, "release,mSurfaceView=" + this_.mSurfaceView);
        if (this_.mSurfaceView == null) {
            return;
        }
        this_.notifySurfaceDestroy();
        this_.mSurfaceView.getHolder().removeCallback(this_.mSurfaceViewListener);
        this_.mSurfaceView = null;
    }

    static /* synthetic */ void lambda$new$0(SurfaceViewRenderHelper this_, SurfaceView surfaceView) {
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (surfaceHolder.getSurface().isValid()) {
            Surface surface = surfaceHolder.getSurface();
            Rect rect = surfaceHolder.getSurfaceFrame();
            LiteavLog.i(this_.mTAG, "construct,surface=%s,Size(%dx%d)", surface, rect.width(), rect.height());
            this_.notifySurfaceChanged(surface);
        } else {
            LiteavLog.i(this_.mTAG, "construct,surfaceView not valid.");
        }
        surfaceHolder.addCallback(this_.mSurfaceViewListener);
    }
}

