/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.preprocessor;

import android.content.Context;
import android.graphics.Bitmap;
import android.util.SparseArray;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.l;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.preprocessor.BeautyProcessor;
import com.tencent.ugc.preprocessor.GPUPreprocessor;
import com.tencent.ugc.preprocessor.VideoPreprocessorListener;
import com.tencent.ugc.videobase.frame.FrameMetaData;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.videobase.ConvertParams;

public class VideoPreprocessor {
    private final String TAG = "VideoPreprocessor_" + this.hashCode();
    private final GPUPreprocessor mPreprocessor;
    private final SparseArray<ConvertParams> mConvertParamsList = new SparseArray();

    public VideoPreprocessor(Context context, BeautyProcessor beautyProcessor) {
        this.mPreprocessor = new GPUPreprocessor(context, beautyProcessor);
    }

    public synchronized void processFrame(PixelFrame pixelFrame) {
        PixelFrame pixelFrame2 = new PixelFrame(pixelFrame);
        this.applyMetaData(pixelFrame2);
        this.mPreprocessor.processFrame(pixelFrame2, this.getScaleTypeFromMetaData(pixelFrame2));
    }

    private void applyMetaData(PixelFrame pixelFrame) {
        FrameMetaData frameMetaData = pixelFrame.getMetaData();
        if (frameMetaData == null) {
            return;
        }
        pixelFrame.setRotation(l.a);
        pixelFrame.postRotate(frameMetaData.getPreprocessorRotation());
        pixelFrame.setMirrorHorizontal(frameMetaData.isPreprocessorMirrorHorizontal());
        pixelFrame.setMirrorVertical(frameMetaData.isPreprocessorMirrorVertical());
        Size size = frameMetaData.getRenderSize();
        if (size.isValid()) {
            this.mPreprocessor.setProcessSize(size.width, size.height);
        }
    }

    private GLConstants.GLScaleType getScaleTypeFromMetaData(PixelFrame pixelFrame) {
        FrameMetaData frameMetaData = pixelFrame.getMetaData();
        if (frameMetaData == null) {
            return GLConstants.GLScaleType.a;
        }
        return frameMetaData.getPreprocessorScaleType();
    }

    public void registerVideoProcessedListener(int identity, ConvertParams convertParams, GLConstants.a bufferType, GLConstants.PixelFormatType formatType, boolean withWatermark, VideoPreprocessorListener listener) {
        if (bufferType == GLConstants.a.b) {
        }
        this.mPreprocessor.registerVideoProcessedListener(identity, convertParams, bufferType, formatType, withWatermark, listener);
        this.mConvertParamsList.put(identity, (Object)convertParams);
        this.recalculateProcessSizeInternal();
    }

    public void unregisterVideoProcessedListener(int identity, VideoPreprocessorListener listener) {
        this.mPreprocessor.unregisterVideoProcessedListener(identity, listener);
        this.mConvertParamsList.remove(identity);
        this.recalculateProcessSizeInternal();
    }

    public void setFilterMixLevel(float mixLevel) {
        LiteavLog.i(this.TAG, "setFilterMixLevel: ".concat(String.valueOf(mixLevel)));
        this.mPreprocessor.setFilterMixLevel(mixLevel);
    }

    public void setFilterGroupImages(float leftBitmapRatio, Bitmap leftBitmap, float leftSpecialRatio, Bitmap rightBitmap, float rightSpecialRatio) {
        this.mPreprocessor.setFilterGroupImages(leftBitmapRatio, leftBitmap, leftSpecialRatio, rightBitmap, rightSpecialRatio);
    }

    public void setGaussianBlurLevel(float level) {
        this.mPreprocessor.setGaussianBlurLevel(level / 4.0f);
    }

    public void uninitialize() {
        this.mPreprocessor.uninitialize();
    }

    public BeautyProcessor getBeautyProcessor() {
        return this.mPreprocessor.getBeautyProcessor();
    }

    private void recalculateProcessSizeInternal() {
        if (this.mConvertParamsList.size() == 0) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        for (int i2 = 0; i2 < this.mConvertParamsList.size(); ++i2) {
            int n4;
            ConvertParams convertParams = (ConvertParams)this.mConvertParamsList.valueAt(i2);
            boolean bl2 = convertParams.rotation == l.b || convertParams.rotation == l.d;
            int n5 = bl2 ? convertParams.height : convertParams.width;
            int n6 = n4 = bl2 ? convertParams.width : convertParams.height;
            if (n2 * n4 != n3 * n5) {
                LiteavLog.w(this.TAG, "video preprocessor has different w/h ratio: %dx%d vs %dx%d", n2, n3, n5, n4);
            }
            if (n5 * n4 <= n2 * n3) continue;
            n2 = n5;
            n3 = n4;
        }
        this.mPreprocessor.setProcessSize(n2, n3);
    }
}

