/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import com.tencent.liteav.base.annotations.JNINamespace;
import com.tencent.liteav.base.util.CommonUtil;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import java.lang.reflect.Field;

@JNINamespace(value="liteav::ugc")
public final class VideoEncodeParams {
    public int width = 0;
    public int height = 0;
    public int fps = 20;
    public int gop = 3;
    public int bitrate = 0;
    public boolean annexb = true;
    public d encoderProfile = null;
    public VideoEncoderDef.BitrateMode bitrateMode = VideoEncoderDef.BitrateMode.b;
    public boolean fullIFrame = false;
    public boolean enableBFrame = false;
    public CodecType codecType = CodecType.b;
    public GLConstants.ColorRange colorRange = GLConstants.ColorRange.a;
    public GLConstants.ColorSpace colorSpace = GLConstants.ColorSpace.a;

    public VideoEncodeParams() {
    }

    public VideoEncodeParams(VideoEncodeParams copyFrom) {
        if (copyFrom == null) {
            return;
        }
        this.width = copyFrom.width;
        this.height = copyFrom.height;
        this.fps = copyFrom.fps;
        this.gop = copyFrom.gop;
        this.bitrate = copyFrom.bitrate;
        this.annexb = copyFrom.annexb;
        this.encoderProfile = copyFrom.encoderProfile;
        this.bitrateMode = copyFrom.bitrateMode;
        this.fullIFrame = copyFrom.fullIFrame;
        this.enableBFrame = copyFrom.enableBFrame;
        this.codecType = copyFrom.codecType;
        this.colorSpace = copyFrom.colorSpace;
        this.colorRange = copyFrom.colorRange;
    }

    public final int getWidth() {
        return this.width;
    }

    public final int getHeight() {
        return this.height;
    }

    public final int getFps() {
        return this.fps;
    }

    public final int getGop() {
        return this.gop;
    }

    public final int getBitrate() {
        return this.bitrate;
    }

    public final int getEncoderProfile() {
        return this.encoderProfile.mValue;
    }

    public final int getBitrateMode() {
        return this.bitrateMode.mValue;
    }

    public final int getColorRange() {
        if (this.colorRange != null) {
            return this.colorRange.getValue();
        }
        return GLConstants.ColorSpace.a.getValue();
    }

    public final int getColorSpace() {
        if (this.colorSpace != null) {
            return this.colorSpace.getValue();
        }
        return GLConstants.ColorRange.a.getValue();
    }

    public final boolean isEnablesBframe() {
        return this.enableBFrame;
    }

    public final boolean isFullIFrame() {
        return this.fullIFrame;
    }

    public final boolean isAnnexb() {
        return this.annexb;
    }

    public final void setFullIFrame(boolean fullIFrame) {
        this.fullIFrame = fullIFrame;
    }

    public final void setAnnexb(boolean annexb) {
        this.annexb = annexb;
    }

    public final void setWidth(int width) {
        this.width = width;
    }

    public final void setHeight(int height) {
        this.height = height;
    }

    public final void setFps(int fps) {
        this.fps = fps;
    }

    public final void setGop(int gop) {
        this.gop = gop;
    }

    public final void setBitrate(int bitrate) {
        this.bitrate = bitrate;
    }

    public final void setBitrateMode(int mode) {
        this.bitrateMode = VideoEncoderDef.BitrateMode.a(mode);
    }

    public final void setEnableBFrame(boolean enableBFrame) {
        this.enableBFrame = enableBFrame;
    }

    public final void setEncoderProfile(int profile) {
        this.encoderProfile = d.a(profile);
    }

    public final void setCodecType(int type) {
        this.codecType = CodecType.a(type);
    }

    public final void setColorRange(int colorRange) {
        this.colorRange = GLConstants.ColorRange.a(colorRange);
    }

    public final void setColorSpace(int colorSpace) {
        this.colorSpace = GLConstants.ColorSpace.a(colorSpace);
    }

    private int checkFieldDiffCounts(Object left, Object right) {
        Field[] fieldArray = VideoEncodeParams.class.getDeclaredFields();
        int n2 = 0;
        Field[] fieldArray2 = fieldArray;
        int n3 = fieldArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            Field field = fieldArray2[i2];
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                if (CommonUtil.equals(field.get(left), field.get(right))) continue;
                ++n2;
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
        }
        return n2;
    }

    public final boolean equals(Object obj) {
        if (obj instanceof VideoEncodeParams) {
            VideoEncodeParams videoEncodeParams = this;
            return videoEncodeParams.checkFieldDiffCounts(videoEncodeParams, obj) == 0;
        }
        return false;
    }

    public final String toString() {
        return "width=" + this.width + ", height=" + this.height + ", fps=" + this.fps + ", gop=" + this.gop + ", bitrate=" + this.bitrate + ", annexb=" + this.annexb + ", encoderProfile=" + (Object)((Object)this.encoderProfile) + ", bitrateMode=" + (Object)((Object)this.bitrateMode) + ", fullIFrame=" + this.fullIFrame + ", enableBFrame=" + this.enableBFrame + ", codecType=" + (Object)((Object)this.codecType) + ", colorRange=" + (Object)((Object)this.colorRange) + ", colorSpace=" + (Object)((Object)this.colorSpace);
    }
}

