/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.encoder;

import android.media.MediaCodec;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.media.MediaFormat;
import android.util.Pair;
import android.util.Range;
import com.tencent.liteav.base.system.LiteavSystemInfo;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.videobase.common.CodecType;
import com.tencent.liteav.videobase.common.d;
import com.tencent.liteav.videoproducer.encoder.VideoEncoderDef;
import com.tencent.ugc.encoder.VideoEncodeParams;

public class MediaFormatBuilder {
    private static final String TAG = "MediaFormatBuilder";
    private static final String MIME_TYPE_H264 = "video/avc";
    private static final String MIME_TYPE_H265 = "video/hevc";
    private final MediaCodec mMediaCodec;
    private final String mMimeType;
    private final VideoEncodeParams mVideoEncodeParams;
    private boolean mEnableSetBitrateModeIfSupport = true;
    private boolean mUseProfileAndLevel = true;

    public MediaFormatBuilder(MediaCodec mediaCodec, String mimeType, VideoEncodeParams inParams) {
        this.mMediaCodec = mediaCodec;
        this.mMimeType = mimeType;
        this.mVideoEncodeParams = inParams;
    }

    public MediaFormatBuilder enableSetBitrateModeIfSupport(boolean enable) {
        this.mEnableSetBitrateModeIfSupport = enable;
        return this;
    }

    public MediaFormatBuilder useProfileAndLevel(boolean enable) {
        this.mUseProfileAndLevel = enable;
        return this;
    }

    public MediaFormat build() {
        MediaCodecInfo.CodecCapabilities codecCapabilities;
        MediaFormat mediaFormat = this.createBaseFormat();
        if (mediaFormat == null) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities2 = this.getCodecCapabilities();
        if (codecCapabilities2 != null && LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
            int n2;
            this.setComplexity(mediaFormat, codecCapabilities2);
            if (this.mUseProfileAndLevel) {
                n2 = MediaFormatBuilder.getMediaCodecProfile(this.mVideoEncodeParams.encoderProfile, this.mVideoEncodeParams.codecType == CodecType.c);
                this.setProfileAndLevel(mediaFormat, codecCapabilities2, n2);
            }
            if (this.mEnableSetBitrateModeIfSupport) {
                n2 = MediaFormatBuilder.getMediaCodecBitrateMode(this.mVideoEncodeParams.bitrateMode);
                this.setBitrateModeIfDeviceSupport(mediaFormat, codecCapabilities2, n2);
            }
        }
        if ((codecCapabilities = this.createCodecCapabilities(mediaFormat)) != null) {
            codecCapabilities2 = codecCapabilities;
        }
        this.updateBitRateFromSupportRange(mediaFormat, codecCapabilities2);
        this.updateToCodecSupportSize(mediaFormat);
        return mediaFormat;
    }

    private void setProfileAndLevel(MediaFormat mediaFormat, MediaCodecInfo.CodecCapabilities caps, int targetProfile) {
        int n2 = 0;
        int n3 = 0;
        int n4 = Integer.MIN_VALUE;
        int n5 = Integer.MAX_VALUE;
        if (this.mMimeType.equals(MIME_TYPE_H264)) {
            n4 = 256;
            n5 = 32768;
        }
        MediaCodecInfo.CodecProfileLevel[] codecProfileLevelArray = caps.profileLevels;
        int n6 = caps.profileLevels.length;
        for (int i2 = 0; i2 < n6; ++i2) {
            MediaCodecInfo.CodecProfileLevel codecProfileLevel = codecProfileLevelArray[i2];
            if (codecProfileLevel.level < n4 || codecProfileLevel.profile > targetProfile || codecProfileLevel.profile <= n2 && (codecProfileLevel.profile != n2 || codecProfileLevel.level <= n3)) continue;
            n2 = codecProfileLevel.profile;
            n3 = Math.min(codecProfileLevel.level, n5);
        }
        mediaFormat.setInteger("profile", n2);
        if (LiteavSystemInfo.getSystemOSVersionInt() >= 23) {
            mediaFormat.setInteger("level", n3);
        }
    }

    private void setComplexity(MediaFormat format, MediaCodecInfo.CodecCapabilities caps) {
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = caps.getEncoderCapabilities();
        if (encoderCapabilities == null) {
            return;
        }
        Range range = encoderCapabilities.getComplexityRange();
        if (range == null) {
            return;
        }
        format.setInteger("complexity", ((Integer)range.getUpper()).intValue());
    }

    private void setBitrateModeIfDeviceSupport(MediaFormat format, MediaCodecInfo.CodecCapabilities caps, int bitrateMode) {
        MediaCodecInfo.EncoderCapabilities encoderCapabilities = caps.getEncoderCapabilities();
        if (encoderCapabilities == null) {
            return;
        }
        if (this.isBitrateModeSupported(bitrateMode, encoderCapabilities)) {
            format.setInteger("bitrate-mode", bitrateMode);
            return;
        }
        if (this.mVideoEncodeParams.fullIFrame) {
            if (this.isBitrateModeSupported(1, encoderCapabilities)) {
                format.setInteger("bitrate-mode", 1);
                return;
            }
            if (this.isBitrateModeSupported(2, encoderCapabilities)) {
                format.setInteger("bitrate-mode", 2);
                return;
            }
        } else if (this.isBitrateModeSupported(2, encoderCapabilities)) {
            format.setInteger("bitrate-mode", 2);
        }
    }

    private boolean isBitrateModeSupported(int bitrateMode, MediaCodecInfo.EncoderCapabilities capabilities) {
        return capabilities.isBitrateModeSupported(bitrateMode);
    }

    private MediaFormat createBaseFormat() {
        if (this.mVideoEncodeParams.width == 0 || this.mVideoEncodeParams.height == 0 || this.mVideoEncodeParams.bitrate == 0 || this.mVideoEncodeParams.fps == 0) {
            return null;
        }
        MediaFormat mediaFormat = MediaFormat.createVideoFormat((String)this.mMimeType, (int)this.mVideoEncodeParams.width, (int)this.mVideoEncodeParams.height);
        if (mediaFormat == null) {
            return null;
        }
        mediaFormat.setInteger("bitrate", this.mVideoEncodeParams.bitrate * 1024);
        mediaFormat.setInteger("frame-rate", this.mVideoEncodeParams.fps);
        mediaFormat.setInteger("color-format", 2130708361);
        int n2 = this.mVideoEncodeParams.fullIFrame ? 0 : this.mVideoEncodeParams.gop;
        mediaFormat.setInteger("i-frame-interval", n2);
        return mediaFormat;
    }

    private MediaCodecInfo.CodecCapabilities getCodecCapabilities() {
        int n2 = MediaCodecList.getCodecCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MediaCodecInfo mediaCodecInfo = MediaCodecList.getCodecInfoAt((int)i2);
            if (!mediaCodecInfo.isEncoder()) continue;
            String[] stringArray = mediaCodecInfo.getSupportedTypes();
            int n3 = stringArray.length;
            for (int i3 = 0; i3 < n3; ++i3) {
                if (!stringArray[i3].equalsIgnoreCase(this.mMimeType)) continue;
                return mediaCodecInfo.getCapabilitiesForType(this.mMimeType);
            }
        }
        return null;
    }

    private MediaCodecInfo.CodecCapabilities createCodecCapabilities(MediaFormat format) {
        if (format == null) {
            return null;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            return null;
        }
        Pair<Integer, Integer> pair = this.getProfileAndLevel(format);
        int n2 = (Integer)pair.first;
        int n3 = (Integer)pair.second;
        return MediaCodecInfo.CodecCapabilities.createFromProfileLevel((String)this.mMimeType, (int)n2, (int)n3);
    }

    private void updateBitRateFromSupportRange(MediaFormat format, MediaCodecInfo.CodecCapabilities caps) {
        if (caps == null || format == null) {
            return;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = caps.getVideoCapabilities();
        if (videoCapabilities == null) {
            return;
        }
        Range range = videoCapabilities.getBitrateRange();
        int n2 = format.getInteger("bitrate");
        int n3 = (Integer)range.clamp((Comparable)Integer.valueOf(n2));
        LiteavLog.i(TAG, "bitrateRange=(%d, %d),bitrate=%d,clampBitrate=%d", range.getLower(), range.getUpper(), n2, n3);
        if (n2 != n3) {
            format.setInteger("bitrate", n3);
        }
    }

    private void updateToCodecSupportSize(MediaFormat format) {
        if (format == null) {
            return;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 23) {
            return;
        }
        Pair<Integer, Integer> pair = this.getProfileAndLevel(format);
        int n2 = (Integer)pair.first;
        int n3 = (Integer)pair.second;
        this.updateMediaFormatToUpperSize(format, n2, n3);
        this.updateMediaFormatToLowerSize(format, n2, n3);
        this.updateMediaFormatWithAlignment(format, n2, n3);
    }

    private Pair<Integer, Integer> getProfileAndLevel(MediaFormat format) {
        int n2 = 0;
        int n3 = 0;
        try {
            n2 = format.getInteger("profile");
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "get profile fail.", throwable);
        }
        try {
            n3 = format.getInteger("level");
        }
        catch (Throwable throwable) {
            LiteavLog.i(TAG, "get level fail.", throwable);
        }
        return new Pair((Object)n2, (Object)n3);
    }

    private void updateMediaFormatToUpperSize(MediaFormat format, int profile, int level) {
        int n2;
        if (format == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.getVideoCapabilitiesByProfileLevel(profile, level);
        if (videoCapabilities == null) {
            return;
        }
        Range range = videoCapabilities.getSupportedWidths();
        Range range2 = videoCapabilities.getSupportedHeights();
        if (range == null || range2 == null) {
            return;
        }
        Integer n3 = (Integer)range.getUpper();
        Integer n4 = (Integer)range2.getUpper();
        int n5 = format.getInteger("width");
        if (n5 > (n2 = format.getInteger("height")) && n3 < n4 || n5 < n2 && n3 > n4) {
            int n6 = n3;
            n3 = n4;
            n4 = n6;
        }
        if (n3 < n5 || n4 < n2) {
            float f2 = Math.min((float)n3.intValue() / ((float)n5 * 1.0f), (float)n4.intValue() / ((float)n2 * 1.0f));
            format.setInteger("width", (int)(f2 * (float)n5));
            format.setInteger("height", (int)(f2 * (float)n2));
            LiteavLog.i(TAG, "updateMediaFormatToUpperSize:srcWidth=%d,srcHeight=%d,upperW=%d,upperH=%d", n5, n2, n3, n4);
        }
    }

    private void updateMediaFormatToLowerSize(MediaFormat format, int profile, int level) {
        if (format == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.getVideoCapabilitiesByProfileLevel(profile, level);
        if (videoCapabilities == null) {
            return;
        }
        Range range = videoCapabilities.getSupportedWidths();
        Range range2 = videoCapabilities.getSupportedHeights();
        if (range == null || range2 == null) {
            return;
        }
        Integer n2 = (Integer)range.getLower();
        Integer n3 = (Integer)range2.getLower();
        MediaCodecInfo.VideoCapabilities videoCapabilities2 = this.getVideoCapabilitiesByMimeType();
        if (videoCapabilities2 != null) {
            range = videoCapabilities2.getSupportedWidths();
            range2 = videoCapabilities2.getSupportedHeights();
            if (range != null && range2 != null) {
                n2 = Math.max(n2, (Integer)range.getLower());
                n3 = Math.max(n3, (Integer)range2.getLower());
            }
        }
        if (n2 < 0 || n3 < 0) {
            return;
        }
        int n4 = format.getInteger("width");
        int n5 = format.getInteger("height");
        if (n2 > n4 || n3 > n5) {
            float f2 = Math.max((float)n2.intValue() / ((float)n4 * 1.0f), (float)n3.intValue() / ((float)n5 * 1.0f));
            format.setInteger("width", (int)(f2 * (float)n4));
            format.setInteger("height", (int)(f2 * (float)n5));
            LiteavLog.i(TAG, "updateMediaFormatToLowerSize:lowerW=%d,lowerH=%d", n2, n3);
        }
    }

    private void updateMediaFormatWithAlignment(MediaFormat format, int profile, int level) {
        if (format == null) {
            return;
        }
        MediaCodecInfo.VideoCapabilities videoCapabilities = this.getVideoCapabilitiesByProfileLevel(profile, level);
        if (videoCapabilities == null) {
            return;
        }
        int n2 = videoCapabilities.getWidthAlignment();
        int n3 = videoCapabilities.getHeightAlignment();
        LiteavLog.i(TAG, "widthAlignment=%d,heightAlignment=%d", n2, n3);
        if (n2 < 2 || n3 < 2 || n2 % 2 != 0 || n3 % 2 != 0) {
            return;
        }
        int n4 = format.getInteger("width");
        int n5 = format.getInteger("height");
        int n6 = n4 / n2 * n2;
        int n7 = n5 / n3 * n3;
        if (n4 != n6 || n5 != n7) {
            format.setInteger("width", n6);
            format.setInteger("height", n7);
            LiteavLog.i(TAG, "updateMediaFormatWithAlignment,srcSize=(%d x %d),fixSize=(%d x %d),widthAlignment=%d,heightAlignment=%d", n4, n5, n6, n7, n2, n3);
        }
    }

    private MediaCodecInfo.VideoCapabilities getVideoCapabilitiesByProfileLevel(int profile, int level) {
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = MediaCodecInfo.CodecCapabilities.createFromProfileLevel((String)this.mMimeType, (int)profile, (int)level);
        if (codecCapabilities == null) {
            return null;
        }
        return codecCapabilities.getVideoCapabilities();
    }

    private MediaCodecInfo.VideoCapabilities getVideoCapabilitiesByMimeType() {
        if (this.mMediaCodec == null) {
            return null;
        }
        if (LiteavSystemInfo.getSystemOSVersionInt() < 21) {
            return null;
        }
        MediaCodecInfo.CodecCapabilities codecCapabilities = this.mMediaCodec.getCodecInfo().getCapabilitiesForType(this.mMimeType);
        if (codecCapabilities == null) {
            return null;
        }
        return codecCapabilities.getVideoCapabilities();
    }

    private static int getMediaCodecBitrateMode(VideoEncoderDef.BitrateMode bitrateMode) {
        int n2 = 2;
        if (bitrateMode == null) {
            return 2;
        }
        switch (bitrateMode) {
            case b: {
                n2 = 2;
                break;
            }
            case c: {
                n2 = 1;
                break;
            }
            case d: {
                n2 = 0;
            }
        }
        return n2;
    }

    private static int getMediaCodecProfile(d profile, boolean isHevc) {
        int n2;
        if (isHevc && LiteavSystemInfo.getSystemOSVersionInt() >= 21) {
            return 1;
        }
        if (profile == null) {
            return 1;
        }
        switch (profile) {
            case c: {
                n2 = 2;
                break;
            }
            case d: {
                n2 = 8;
                break;
            }
            default: {
                n2 = 1;
            }
        }
        return n2;
    }
}

