/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.os.HandlerThread;
import com.tencent.liteav.base.b.b;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.liteav.base.util.w;
import com.tencent.liteav.videobase.base.GLConstants;
import com.tencent.ugc.GlobalContextManager;
import com.tencent.ugc.UGCFrameQueue;
import com.tencent.ugc.decoder.HardwareVideoDecoder;
import com.tencent.ugc.decoder.SoftwareVideoDecoder;
import com.tencent.ugc.decoder.SpsInfo;
import com.tencent.ugc.decoder.UGCVideoDecodeControllerListener;
import com.tencent.ugc.decoder.VideoDecoderInterface;
import com.tencent.ugc.decoder.VideoDecoderListener;
import com.tencent.ugc.decoder.k;
import com.tencent.ugc.decoder.l;
import com.tencent.ugc.decoder.m;
import com.tencent.ugc.decoder.n;
import com.tencent.ugc.decoder.o;
import com.tencent.ugc.decoder.p;
import com.tencent.ugc.decoder.q;
import com.tencent.ugc.decoder.r;
import com.tencent.ugc.decoder.s;
import com.tencent.ugc.decoder.t;
import com.tencent.ugc.videobase.common.EncodedVideoFrame;
import com.tencent.ugc.videobase.frame.PixelFrame;
import java.util.concurrent.atomic.AtomicBoolean;

public class UGCVideoDecodeController {
    private static final int INTERVAL_DRAIN_DECODED_FRAME = 15;
    private static final int MAX_CACHE_FRAME_COUNT = 1;
    private static final int MAX_DECODE_FRAME_FAIL_COUNT = 30;
    private static final int MAX_DECODING_FRAME_COUNT = 30;
    private static final int MAX_DECODING_FRAME_TIME = 2500;
    private final String mTAG;
    private final b mThrottlers;
    private final AtomicBoolean mHasDecodeError;
    private final UGCFrameQueue<EncodedVideoFrame> mPendingFrameQueue;
    private CustomHandler mWorkHandler;
    private w mDecodeTimer;
    private UGCVideoDecodeControllerListener mListener;
    private a mDecoderListener;
    private VideoDecoderInterface mDecoder;
    private boolean mIsUsingHardwareDecoder = true;
    private boolean mIsRedecodingFromBeginOfThisGop = false;
    private Long mLastOutputFramePts = null;
    private int mDecodingFrameCount = 0;
    private int mSendFrameFailCount = 0;
    private long mInputFramePts = 0L;
    private long mOutputFramePts = 0L;
    private GLConstants.ColorRange mColorRange = GLConstants.ColorRange.a;
    private GLConstants.ColorSpace mColorSpace = GLConstants.ColorSpace.a;
    private final UGCFrameQueue.UGCFrameQueueListener mUGCFrameQueueListener = new UGCFrameQueue.UGCFrameQueueListener(){

        @Override
        public final void onFrameDequeued() {
            UGCVideoDecodeController.this.runOnWorkThread(q.a(this));
        }

        static /* synthetic */ void a(1 var0) {
            if (var0.UGCVideoDecodeController.this.mListener != null) {
                var0.UGCVideoDecodeController.this.mListener.onFrameEnqueuedToDecoder();
            }
        }
    };

    public UGCVideoDecodeController() {
        this.mTAG = "UGCVideoDecodeController_" + this.hashCode();
        this.mThrottlers = new b();
        this.mHasDecodeError = new AtomicBoolean(false);
        this.mPendingFrameQueue = new UGCFrameQueue();
        this.mPendingFrameQueue.setUGCFrameQueueListener(this.mUGCFrameQueueListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(UGCVideoDecodeControllerListener listener) {
        LiteavLog.i(this.mThrottlers.a("start"), this.mTAG, "start", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        synchronized (uGCVideoDecodeController) {
            if (this.mWorkHandler != null) {
                LiteavLog.w(this.mThrottlers.a("startWorkHandler"), this.mTAG, "UGCDecodeController is start", new Object[0]);
                return;
            }
            HandlerThread handlerThread = new HandlerThread("ugc-decoder-controller");
            handlerThread.start();
            this.mWorkHandler = new CustomHandler(handlerThread.getLooper());
            UGCVideoDecodeController uGCVideoDecodeController2 = this;
            this.mDecodeTimer = new w(this.mWorkHandler.getLooper(), new k(uGCVideoDecodeController2));
            this.mDecodeTimer.a(15);
        }
        UGCVideoDecodeController uGCVideoDecodeController3 = this;
        uGCVideoDecodeController3.runOnWorkThread(l.a(uGCVideoDecodeController3, listener));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        LiteavLog.i(this.mThrottlers.a("stop"), this.mTAG, "stop", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(m.a(uGCVideoDecodeController));
        UGCVideoDecodeController uGCVideoDecodeController2 = this;
        synchronized (uGCVideoDecodeController2) {
            if (this.mWorkHandler != null) {
                this.mWorkHandler.quitLooperAndWaitDone();
                this.mWorkHandler = null;
            }
            return;
        }
    }

    public void decode(EncodedVideoFrame frame) {
        if (frame == null) {
            return;
        }
        this.mPendingFrameQueue.queue(frame);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(n.a(uGCVideoDecodeController, frame));
    }

    public void abandonDecodingFrames() {
        LiteavLog.i(this.mThrottlers.a("abandonFrames"), this.mTAG, "abandonDecodingFrames", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(o.a(uGCVideoDecodeController));
    }

    public void signalEndOfStream() {
        LiteavLog.i(this.mThrottlers.a("signalEndOfStream"), this.mTAG, "signalEndOfStream", new Object[0]);
        UGCVideoDecodeController uGCVideoDecodeController = this;
        uGCVideoDecodeController.runOnWorkThread(p.a(uGCVideoDecodeController));
    }

    public boolean isInputQueueFull() {
        return this.mPendingFrameQueue.size() > 0;
    }

    private void notifyAbandonDecodingFramesCompleted() {
        LiteavLog.i(this.mThrottlers.a("onAbandonCompleted"), this.mTAG, "onAbandonDecodingFramesCompleted", new Object[0]);
        if (this.mListener != null) {
            this.mListener.onAbandonDecodingFramesCompleted();
        }
    }

    private void notifyDecodeCompleted() {
        LiteavLog.i(this.mThrottlers.a("onDecodeCompleted"), this.mTAG, "onDecodeCompleted", new Object[0]);
        if (this.mListener != null) {
            this.mListener.onDecodeCompleted();
        }
    }

    private void handleDecoderError() {
        if (!this.isDecoderError()) {
            return;
        }
        if (this.mIsUsingHardwareDecoder) {
            LiteavLog.i(this.mThrottlers.a("handleDecoderError"), this.mTAG, "handle Hardware Decoder Error", new Object[0]);
            this.mIsUsingHardwareDecoder = false;
            this.mIsRedecodingFromBeginOfThisGop = true;
            this.destroyDecoder();
            this.clearFrameQueue();
            if (this.mListener != null) {
                this.mListener.onRequestSeekToLastKeyFrame(this.mLastOutputFramePts == null ? 0L : this.mLastOutputFramePts);
            }
        } else {
            LiteavLog.i(this.mThrottlers.a("handleDecoderError"), this.mTAG, "notify DecodeFailed", new Object[0]);
            if (this.mListener != null) {
                this.mListener.onDecodeFailed();
            }
        }
        this.mHasDecodeError.set(false);
        this.mSendFrameFailCount = 0;
        this.mDecodingFrameCount = 0;
        this.mInputFramePts = 0L;
        this.mOutputFramePts = 0L;
    }

    private boolean isDecoderError() {
        if (this.mHasDecodeError.get()) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "mIsDecodeError is true", new Object[0]);
            return true;
        }
        if (this.mSendFrameFailCount > 30) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "mSendFrameFailCount = " + this.mSendFrameFailCount, new Object[0]);
            return true;
        }
        if (this.mDecodingFrameCount > 30 && this.mInputFramePts - this.mOutputFramePts > 2500L) {
            LiteavLog.e(this.mThrottlers.a("isDecoderError"), this.mTAG, "internal decoder cache too big", new Object[0]);
            return true;
        }
        return false;
    }

    private void decodeInternal() {
        EncodedVideoFrame encodedVideoFrame;
        this.handleDecoderError();
        if (this.mDecoder == null) {
            UGCVideoDecodeController uGCVideoDecodeController = this;
            if (!uGCVideoDecodeController.createDecoder(uGCVideoDecodeController.mIsUsingHardwareDecoder)) {
                return;
            }
        }
        if ((encodedVideoFrame = this.mPendingFrameQueue.peek()) == null) {
            this.mDecoder.decode(null);
            return;
        }
        if (this.mDecoder.decode(encodedVideoFrame)) {
            ++this.mDecodingFrameCount;
            this.mInputFramePts = encodedVideoFrame.pts;
            this.mSendFrameFailCount = 0;
            this.mPendingFrameQueue.dequeue();
            return;
        }
        ++this.mSendFrameFailCount;
    }

    private void onDecodeFrameInternal(PixelFrame pixelFrame) {
        long l2;
        --this.mDecodingFrameCount;
        pixelFrame.setColorFormat(this.mColorRange, this.mColorSpace);
        this.mOutputFramePts = pixelFrame.getTimestamp();
        long l3 = l2 = this.mLastOutputFramePts == null ? 0L : this.mLastOutputFramePts;
        if (!this.mIsRedecodingFromBeginOfThisGop || pixelFrame.getTimestamp() > l2) {
            if (this.mListener != null) {
                this.mListener.onFrameDecoded(pixelFrame);
            }
            this.mLastOutputFramePts = pixelFrame.getTimestamp();
            this.mIsRedecodingFromBeginOfThisGop = false;
        }
        this.decodeInternal();
    }

    private void stopInternal() {
        LiteavLog.i(this.mThrottlers.a("stopInternal"), this.mTAG, "stopInternal", new Object[0]);
        this.mIsUsingHardwareDecoder = true;
        this.mIsRedecodingFromBeginOfThisGop = false;
        this.mListener = null;
        this.mLastOutputFramePts = null;
        this.mHasDecodeError.set(false);
        this.mDecodingFrameCount = 0;
        this.mSendFrameFailCount = 0;
        this.mInputFramePts = 0L;
        this.mOutputFramePts = 0L;
        this.destroyDecoder();
        this.clearFrameQueue();
        if (this.mDecodeTimer != null) {
            this.mDecodeTimer.a();
            this.mDecodeTimer = null;
        }
    }

    private boolean createDecoder(boolean useHardwareDecoder) {
        EncodedVideoFrame encodedVideoFrame = this.getIDRFrameFromQueue();
        if (encodedVideoFrame == null) {
            return false;
        }
        this.mDecoder = useHardwareDecoder ? this.createHardwareDecoder(encodedVideoFrame) : new SoftwareVideoDecoder(encodedVideoFrame.isH265());
        this.mDecoder.initialize();
        this.mDecoderListener = new a(0);
        this.mDecoder.start(GlobalContextManager.getInstance().getGLContext(), this.mDecoderListener);
        this.mDecoder.decode(encodedVideoFrame);
        return true;
    }

    private EncodedVideoFrame getIDRFrameFromQueue() {
        while (this.mPendingFrameQueue.size() != 0) {
            EncodedVideoFrame encodedVideoFrame = this.mPendingFrameQueue.dequeue();
            if (encodedVideoFrame == null || !encodedVideoFrame.isIDRFrame()) continue;
            return encodedVideoFrame;
        }
        return null;
    }

    private VideoDecoderInterface createHardwareDecoder(EncodedVideoFrame idrFrame) {
        this.parserColorFormatInfo(idrFrame);
        LiteavLog.i(this.mTAG, "video color info: " + (Object)((Object)this.mColorRange) + ", " + (Object)((Object)this.mColorSpace));
        HardwareVideoDecoder.HardwareVideoDecoderParams hardwareVideoDecoderParams = new HardwareVideoDecoder.HardwareVideoDecoderParams();
        boolean bl2 = new HardwareVideoDecoder.HardwareVideoDecoderParams().useOutputBuffer = this.mColorSpace == GLConstants.ColorSpace.c;
        if (idrFrame.videoFormat != null) {
            hardwareVideoDecoderParams.mediaFormat = idrFrame.videoFormat;
        } else {
            hardwareVideoDecoderParams.useHevc = idrFrame.isH265();
            hardwareVideoDecoderParams.resolution = new Size(idrFrame.width, idrFrame.height);
        }
        return new HardwareVideoDecoder(hardwareVideoDecoderParams, null);
    }

    private void parserColorFormatInfo(EncodedVideoFrame idrFrame) {
        SpsInfo spsInfo = SpsInfo.nativeDecodeSps(idrFrame.isH265(), idrFrame.data);
        if (spsInfo == null) {
            return;
        }
        LiteavLog.i(this.mTAG, " sps info is ".concat(String.valueOf(spsInfo)));
        this.mColorRange = GLConstants.ColorRange.b;
        if (spsInfo.videoFullRangeFlag != null && spsInfo.videoFullRangeFlag == 1) {
            this.mColorRange = GLConstants.ColorRange.c;
        }
        this.mColorSpace = GLConstants.ColorSpace.b;
        if (spsInfo.colourPrimaries != null && spsInfo.colourPrimaries == 1 && spsInfo.transferCharacteristics != null && spsInfo.transferCharacteristics == 1) {
            this.mColorSpace = GLConstants.ColorSpace.c;
        }
    }

    private void clearFrameQueue() {
        this.mPendingFrameQueue.clear();
    }

    private void destroyDecoder() {
        if (this.mDecoder != null) {
            this.mDecoder.stop();
            this.mDecoder.uninitialize();
            this.mDecoder = null;
            this.mDecoderListener = null;
        }
    }

    private boolean runOnWorkThread(Runnable runnable) {
        CustomHandler customHandler = this.mWorkHandler;
        return customHandler != null && customHandler.runOrPost(runnable);
    }

    static /* synthetic */ void lambda$signalEndOfStream$3(UGCVideoDecodeController this_) {
        if (this_.mDecoder != null) {
            EncodedVideoFrame encodedVideoFrame = new EncodedVideoFrame();
            new EncodedVideoFrame().isEosFrame = true;
            this_.mPendingFrameQueue.queue(encodedVideoFrame);
            return;
        }
        this_.notifyDecodeCompleted();
    }

    static /* synthetic */ void lambda$abandonDecodingFrames$2(UGCVideoDecodeController this_) {
        this_.clearFrameQueue();
        this_.mIsRedecodingFromBeginOfThisGop = false;
        this_.mDecodingFrameCount = 0;
        this_.mInputFramePts = 0L;
        this_.mOutputFramePts = 0L;
        if (this_.mDecoder != null) {
            this_.mDecoder.abandonDecodingFrames();
            return;
        }
        this_.notifyAbandonDecodingFramesCompleted();
    }

    static /* synthetic */ void lambda$decode$1(UGCVideoDecodeController this_, EncodedVideoFrame frame) {
        if (this_.mLastOutputFramePts == null) {
            this_.mLastOutputFramePts = frame.pts - 1L;
        }
        this_.mSendFrameFailCount = 0;
        this_.decodeInternal();
    }

    static /* synthetic */ void lambda$start$0(UGCVideoDecodeController this_, UGCVideoDecodeControllerListener listener) {
        this_.mListener = listener;
    }

    static /* synthetic */ void access$lambda$0(UGCVideoDecodeController uGCVideoDecodeController) {
        uGCVideoDecodeController.decodeInternal();
    }

    static /* synthetic */ void access$lambda$1(UGCVideoDecodeController uGCVideoDecodeController) {
        uGCVideoDecodeController.stopInternal();
    }

    final class a
    extends VideoDecoderListener {
        private a() {
        }

        @Override
        public final void onDecodeFrame(PixelFrame pixelFrame, long dts) {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener || pixelFrame == null) {
                return;
            }
            pixelFrame.retain();
            CustomHandler customHandler = UGCVideoDecodeController.this.mWorkHandler;
            if (customHandler != null) {
                customHandler.post(r.a(this, pixelFrame));
            }
        }

        @Override
        public final void onDecodeFailed() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            LiteavLog.i(UGCVideoDecodeController.this.mThrottlers.a("onDecodeFailed"), UGCVideoDecodeController.this.mTAG, "onDecodeFailed", new Object[0]);
            UGCVideoDecodeController.this.mHasDecodeError.set(true);
        }

        @Override
        public final void onAbandonDecodingFramesCompleted() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            UGCVideoDecodeController.this.runOnWorkThread(s.a(UGCVideoDecodeController.this));
        }

        @Override
        public final void onDecodeCompleted() {
            a a2 = this;
            if (a2 != a2.UGCVideoDecodeController.this.mDecoderListener) {
                return;
            }
            UGCVideoDecodeController.this.runOnWorkThread(t.a(UGCVideoDecodeController.this));
        }

        static /* synthetic */ void a(UGCVideoDecodeController uGCVideoDecodeController) {
            uGCVideoDecodeController.notifyDecodeCompleted();
        }

        static /* synthetic */ void b(UGCVideoDecodeController uGCVideoDecodeController) {
            uGCVideoDecodeController.notifyAbandonDecodingFramesCompleted();
        }

        static /* synthetic */ void a(a a2, PixelFrame pixelFrame) {
            a2.UGCVideoDecodeController.this.onDecodeFrameInternal(pixelFrame);
            pixelFrame.release();
        }

        /* synthetic */ a(byte by2) {
            this();
        }
    }
}

