/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.ugc.decoder;

import android.media.MediaCodec;
import android.media.MediaFormat;
import android.view.Surface;
import com.tencent.liteav.base.util.CustomHandler;
import com.tencent.liteav.base.util.LiteavLog;
import com.tencent.liteav.base.util.Size;
import com.tencent.ugc.decoder.MediaCodecDecoder;
import com.tencent.ugc.decoder.MediaCodecWrapper;
import com.tencent.ugc.decoder.i;
import com.tencent.ugc.videobase.frame.PixelFrame;
import com.tencent.ugc.videobase.utils.HardwareDecoderMediaFormatBuilder;
import java.util.concurrent.TimeUnit;

public class MediaCodecHDRDecoder
extends MediaCodecDecoder {
    private Surface mOutputSurface;

    public MediaCodecHDRDecoder(HardwareDecoderMediaFormatBuilder builder, Size resolution, boolean useSoftwareDecoder, MediaCodecDecoder.MediaCodecDecoderListener listener, CustomHandler handler) {
        super(builder, resolution, useSoftwareDecoder, listener, handler);
        this.mTAG = "MediaCodecHDRDecoder" + this.hashCode();
    }

    @Override
    public boolean start(Object sharedGLContext) {
        return true;
    }

    @Override
    protected boolean configureMediaCodec(MediaCodec mediaCodec, MediaFormat mediaFormat) {
        if (this.mOutputSurface == null) {
            return false;
        }
        MediaCodecWrapper.configure(mediaCodec, mediaFormat, this.mOutputSurface, null, 0);
        return true;
    }

    @Override
    protected void updateOutputSurface(MediaCodec preloadMediaCodec) {
    }

    @Override
    protected boolean handleOutputBuffer(MediaCodec mediaCodec, MediaCodec.BufferInfo bufferInfo, int bufferIndex) {
        mediaCodec.releaseOutputBuffer(bufferIndex, true);
        if ((bufferInfo.flags & 4) != 0) {
            LiteavLog.i(this.mTAG, "meet end of stream.");
            if (this.mListener != null) {
                this.mListener.onDecodeFrame(null, true);
            }
        } else {
            PixelFrame pixelFrame = new PixelFrame();
            pixelFrame.setWidth(this.mResolution.width);
            pixelFrame.setHeight(this.mResolution.height);
            pixelFrame.setTimestamp(TimeUnit.MICROSECONDS.toMillis(bufferInfo.presentationTimeUs));
            if (this.mListener != null) {
                this.mListener.onDecodeFrame(pixelFrame, false);
            }
        }
        return false;
    }

    public void setOutputSurface(Surface surface) {
        MediaCodecHDRDecoder mediaCodecHDRDecoder = this;
        mediaCodecHDRDecoder.runOnWorkThread(i.a(mediaCodecHDRDecoder, surface));
    }

    static /* synthetic */ void lambda$setOutputSurface$0(MediaCodecHDRDecoder this_, Surface surface) {
        this_.mOutputSurface = surface;
    }
}

